/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.value.LongValueStream;

public class LongMultiPointField
extends AnalyticsField
implements LongValueStream.CastingLongValueStream {
    private SortedNumericDocValues docValues;
    private int count = 0;
    private long[] values = new long[20];

    public LongMultiPointField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues.advanceExact(doc)) {
            this.count = this.docValues.docValueCount();
            this.resizeEmptyValues(this.count);
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.docValues.nextValue();
            }
        } else {
            this.count = 0;
        }
    }

    private void resizeEmptyValues(int count) {
        if (count > this.values.length) {
            this.values = new long[count];
        }
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        this.streamLongs(value -> cons.accept(value));
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamLongs(value -> cons.accept(Long.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamLongs(value -> cons.accept(value));
    }
}

