/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.util.function.Consumer;
import org.apache.solr.analytics.facet.compare.ConstantComparator;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.constant.ConstantValue;

public class ConstantBooleanValue
extends ConstantValue
implements BooleanValue.CastingBooleanValue {
    private final boolean value;
    private final String valueStr;
    public static final String name = "const_bool";
    private final String exprStr;

    public ConstantBooleanValue(boolean value) {
        this.value = value;
        this.valueStr = Boolean.toString(value);
        this.exprStr = ConstantValue.createExpressionString(this, this.valueStr);
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.valueStr;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        cons.accept(this.valueStr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        cons.accept(this.value);
    }

    @Override
    public ConstantComparator getObjectComparator(String expression) {
        return new ConstantComparator();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.CONST;
    }
}

