/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Transformer;

public class NumberFormatTransformer
extends Transformer {
    public static final String FORMAT_STYLE = "formatStyle";
    public static final String LOCALE = "locale";
    public static final String NUMBER = "number";
    public static final String PERCENT = "percent";
    public static final String INTEGER = "integer";
    public static final String CURRENCY = "currency";

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        for (Map<String, String> fld : context.getAllEntityFields()) {
            String style = context.replaceTokens(fld.get(FORMAT_STYLE));
            if (style == null) continue;
            String column = fld.get("column");
            String srcCol = fld.get("sourceColName");
            String localeStr = context.replaceTokens(fld.get(LOCALE));
            if (srcCol == null) {
                srcCol = column;
            }
            Locale locale = Locale.ROOT;
            if (localeStr != null) {
                try {
                    locale = new Locale.Builder().setLanguageTag(localeStr).build();
                }
                catch (IllformedLocaleException e) {
                    throw new DataImportHandlerException(500, "Invalid Locale '" + localeStr + "' specified for field: " + fld, e);
                }
            }
            Object val = row.get(srcCol);
            String styleSmall = style.toLowerCase(Locale.ROOT);
            if (val instanceof List) {
                List inputs = (List)val;
                ArrayList<Number> results = new ArrayList<Number>();
                for (String input : inputs) {
                    try {
                        results.add(this.process(input, styleSmall, locale));
                    }
                    catch (ParseException e) {
                        throw new DataImportHandlerException(500, "Failed to apply NumberFormat on column: " + column, e);
                    }
                }
                row.put(column, results);
                continue;
            }
            if (val == null || val.toString().trim().equals("")) continue;
            try {
                row.put(column, this.process(val.toString(), styleSmall, locale));
            }
            catch (ParseException e) {
                throw new DataImportHandlerException(500, "Failed to apply NumberFormat on column: " + column, e);
            }
        }
        return row;
    }

    private Number process(String val, String style, Locale locale) throws ParseException {
        if (INTEGER.equals(style)) {
            return this.parseNumber(val, NumberFormat.getIntegerInstance(locale));
        }
        if (NUMBER.equals(style)) {
            return this.parseNumber(val, NumberFormat.getNumberInstance(locale));
        }
        if (CURRENCY.equals(style)) {
            return this.parseNumber(val, NumberFormat.getCurrencyInstance(locale));
        }
        if (PERCENT.equals(style)) {
            return this.parseNumber(val, NumberFormat.getPercentInstance(locale));
        }
        return null;
    }

    private Number parseNumber(String val, NumberFormat numFormat) throws ParseException {
        ParsePosition parsePos = new ParsePosition(0);
        Number num = numFormat.parse(val, parsePos);
        if (parsePos.getIndex() != val.length()) {
            throw new ParseException("illegal number format", parsePos.getIndex());
        }
        return num;
    }
}

