/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.Litmus;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Filter
extends SingleRel {
    protected final RexNode condition;

    protected Filter(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child);
        this.condition = Objects.requireNonNull(condition, "condition");
        assert (RexUtil.isFlat(condition)) : "RexUtil.isFlat should be true for condition " + condition;
        assert (this.isValid(Litmus.THROW, null));
    }

    protected Filter(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), Objects.requireNonNull(input.getExpression("condition"), "condition"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Filter.sole(inputs), this.getCondition());
    }

    public abstract Filter copy(RelTraitSet var1, RelNode var2, RexNode var3);

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition = shuttle.apply(this.condition);
        if (this.condition == condition) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), condition);
    }

    public RexNode getCondition() {
        return this.condition;
    }

    public final boolean containsOver() {
        return RexOver.containsOver(this.condition);
    }

    @Override
    public boolean isValid(Litmus litmus, @Nullable RelNode.Context context) {
        if (RexUtil.isNullabilityCast(this.getCluster().getTypeFactory(), this.condition)) {
            return litmus.fail("Cast for just nullability not allowed", new Object[0]);
        }
        RexChecker checker = new RexChecker(this.getInput().getRowType(), context, litmus);
        this.condition.accept(checker);
        if (checker.getFailureCount() > 0) {
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this);
        double dCpu = mq.getRowCount(this.getInput());
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return RelMdUtil.estimateFilteredRows(this.getInput(), this.condition, mq);
    }

    @Deprecated
    public static double estimateFilteredRows(RelNode child, RexProgram program) {
        RelMetadataQuery mq = child.getCluster().getMetadataQuery();
        return RelMdUtil.estimateFilteredRows(child, program, mq);
    }

    @Deprecated
    public static double estimateFilteredRows(RelNode child, RexNode condition) {
        RelMetadataQuery mq = child.getCluster().getMetadataQuery();
        return RelMdUtil.estimateFilteredRows(child, condition, mq);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("condition", this.condition);
    }

    @API(since="1.24", status=API.Status.INTERNAL)
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    protected boolean deepEquals0(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Filter o = (Filter)obj;
        return this.traitSet.equals(o.traitSet) && this.input.deepEquals(o.input) && this.condition.equals(o.condition) && this.getRowType().equalsSansFieldNames(o.getRowType());
    }

    @API(since="1.24", status=API.Status.INTERNAL)
    protected int deepHashCode0() {
        return Objects.hash(this.traitSet, this.input.deepHashCode(), this.condition);
    }
}

