/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;

public class JoinToCorrelateRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinToCorrelateRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinToCorrelateRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(LogicalJoin.class));
    }

    @Deprecated
    protected JoinToCorrelateRule(RelFactories.FilterFactory filterFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(RelBuilder.proto(Contexts.of((Object)filterFactory))).as(Config.class).withOperandFor(LogicalJoin.class));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        return !join.getJoinType().generatesNullsOnLeft();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        assert (this.matches(call));
        Join join = (Join)call.rel(0);
        RelNode right = join.getRight();
        RelNode left = join.getLeft();
        final int leftFieldCount = left.getRowType().getFieldCount();
        RelOptCluster cluster = join.getCluster();
        final RexBuilder rexBuilder = cluster.getRexBuilder();
        RelBuilder relBuilder = call.builder();
        CorrelationId correlationId = cluster.createCorrel();
        final RexNode corrVar = rexBuilder.makeCorrel(left.getRowType(), correlationId);
        final ImmutableBitSet.Builder requiredColumns = ImmutableBitSet.builder();
        RexNode joinCondition = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int field = input.getIndex();
                if (field >= leftFieldCount) {
                    return rexBuilder.makeInputRef(input.getType(), input.getIndex() - leftFieldCount);
                }
                requiredColumns.set(field);
                return rexBuilder.makeFieldAccess(corrVar, field);
            }
        });
        relBuilder.push(right).filter(joinCondition);
        LogicalCorrelate newRel = LogicalCorrelate.create(left, relBuilder.build(), correlationId, requiredColumns.build(), join.getJoinType());
        call.transformTo(newRel);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(LogicalJoin.class);

        @Override
        default public JoinToCorrelateRule toRule() {
            return new JoinToCorrelateRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b -> b.operand(joinClass).anyInputs()).as(Config.class);
        }
    }
}

