/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.BaseShape;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public class RectangleImpl
extends BaseShape<SpatialContext>
implements Rectangle {
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public RectangleImpl(double minX, double maxX, double minY, double maxY, SpatialContext ctx) {
        super(ctx);
        this.reset(minX, maxX, minY, maxY);
    }

    public RectangleImpl(Point lowerLeft, Point upperRight, SpatialContext ctx) {
        this(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY(), ctx);
    }

    public RectangleImpl(Rectangle r, SpatialContext ctx) {
        this(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY(), ctx);
    }

    @Override
    public void reset(double minX, double maxX, double minY, double maxY) {
        assert (!this.isEmpty());
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        assert (minY <= maxY || Double.isNaN(minY)) : "minY, maxY: " + minY + ", " + maxY;
    }

    @Override
    public boolean isEmpty() {
        return Double.isNaN(this.minX);
    }

    @Override
    public Rectangle getBuffered(double distance, SpatialContext ctx) {
        if (ctx.isGeo()) {
            if (this.maxY + distance >= 90.0) {
                return ctx.makeRectangle(-180.0, 180.0, Math.max(-90.0, this.minY - distance), 90.0);
            }
            if (this.minY - distance <= -90.0) {
                return ctx.makeRectangle(-180.0, 180.0, -90.0, Math.min(90.0, this.maxY + distance));
            }
            double latDistance = distance;
            double closestToPoleY = Math.abs(this.maxY) > Math.abs(this.minY) ? this.maxY : this.minY;
            double lonDistance = DistanceUtils.calcBoxByDistFromPt_deltaLonDEG(closestToPoleY, this.minX, distance);
            if (lonDistance * 2.0 + this.getWidth() >= 360.0) {
                return ctx.makeRectangle(-180.0, 180.0, this.minY - latDistance, this.maxY + latDistance);
            }
            return ctx.makeRectangle(DistanceUtils.normLonDEG(this.minX - lonDistance), DistanceUtils.normLonDEG(this.maxX + lonDistance), this.minY - latDistance, this.maxY + latDistance);
        }
        Rectangle worldBounds = ctx.getWorldBounds();
        double newMinX = Math.max(worldBounds.getMinX(), this.minX - distance);
        double newMaxX = Math.min(worldBounds.getMaxX(), this.maxX + distance);
        double newMinY = Math.max(worldBounds.getMinY(), this.minY - distance);
        double newMaxY = Math.min(worldBounds.getMaxY(), this.maxY + distance);
        return ctx.makeRectangle(newMinX, newMaxX, newMinY, newMaxY);
    }

    @Override
    public boolean hasArea() {
        return this.maxX != this.minX && this.maxY != this.minY;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        if (ctx == null) {
            return this.getWidth() * this.getHeight();
        }
        return ctx.getDistCalc().area(this);
    }

    @Override
    public boolean getCrossesDateLine() {
        return this.minX > this.maxX;
    }

    @Override
    public double getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public double getWidth() {
        double w = this.maxX - this.minX;
        if (w < 0.0) assert ((w += 360.0) >= 0.0);
        return w;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (this.isEmpty() || other.isEmpty()) {
            return SpatialRelation.DISJOINT;
        }
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        return other.relate(this).transpose();
    }

    public SpatialRelation relate(Point point) {
        if (point.getY() > this.getMaxY() || point.getY() < this.getMinY()) {
            return SpatialRelation.DISJOINT;
        }
        double minX = this.minX;
        double maxX = this.maxX;
        double pX = point.getX();
        if (this.ctx.isGeo()) {
            double rawWidth = maxX - minX;
            if (rawWidth < 0.0) {
                maxX = minX + (rawWidth + 360.0);
            }
            if (pX < minX) {
                pX += 360.0;
            } else if (pX > maxX) {
                pX -= 360.0;
            } else {
                return SpatialRelation.CONTAINS;
            }
        }
        if (pX < minX || pX > maxX) {
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.CONTAINS;
    }

    public SpatialRelation relate(Rectangle rect) {
        SpatialRelation yIntersect = this.relateYRange(rect.getMinY(), rect.getMaxY());
        if (yIntersect == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        SpatialRelation xIntersect = this.relateXRange(rect.getMinX(), rect.getMaxX());
        if (xIntersect == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        if (xIntersect == yIntersect) {
            return xIntersect;
        }
        if (this.getMinY() == rect.getMinY() && this.getMaxY() == rect.getMaxY()) {
            return xIntersect;
        }
        if (this.getMinX() == rect.getMinX() && this.getMaxX() == rect.getMaxX() || this.ctx.isGeo() && RectangleImpl.verticalAtDateline(this, rect)) {
            return yIntersect;
        }
        return SpatialRelation.INTERSECTS;
    }

    private static boolean verticalAtDateline(RectangleImpl rect1, Rectangle rect2) {
        if (rect1.getMinX() == rect1.getMaxX() && rect2.getMinX() == rect2.getMaxX()) {
            if (rect1.getMinX() == -180.0) {
                return rect2.getMinX() == 180.0;
            }
            if (rect1.getMinX() == 180.0) {
                return rect2.getMinX() == -180.0;
            }
        }
        return false;
    }

    private static SpatialRelation relate_range(double int_min, double int_max, double ext_min, double ext_max) {
        if (ext_min > int_max || ext_max < int_min) {
            return SpatialRelation.DISJOINT;
        }
        if (ext_min >= int_min && ext_max <= int_max) {
            return SpatialRelation.CONTAINS;
        }
        if (ext_min <= int_min && ext_max >= int_max) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public SpatialRelation relateYRange(double ext_minY, double ext_maxY) {
        return RectangleImpl.relate_range(this.minY, this.maxY, ext_minY, ext_maxY);
    }

    @Override
    public SpatialRelation relateXRange(double ext_minX, double ext_maxX) {
        double minX = this.minX;
        double maxX = this.maxX;
        if (this.ctx.isGeo()) {
            double ext_rawWidth;
            double rawWidth = maxX - minX;
            if (rawWidth == 360.0) {
                return SpatialRelation.CONTAINS;
            }
            if (rawWidth < 0.0) {
                maxX = minX + (rawWidth + 360.0);
            }
            if ((ext_rawWidth = ext_maxX - ext_minX) == 360.0) {
                return SpatialRelation.WITHIN;
            }
            if (ext_rawWidth < 0.0) {
                ext_maxX = ext_minX + (ext_rawWidth + 360.0);
            }
            if (maxX < ext_minX) {
                minX += 360.0;
                maxX += 360.0;
            } else if (ext_maxX < minX) {
                ext_minX += 360.0;
                ext_maxX += 360.0;
            }
        }
        return RectangleImpl.relate_range(minX, maxX, ext_minX, ext_maxX);
    }

    public String toString() {
        return "Rect(minX=" + this.minX + ",maxX=" + this.maxX + ",minY=" + this.minY + ",maxY=" + this.maxY + ")";
    }

    @Override
    public Point getCenter() {
        if (Double.isNaN(this.minX)) {
            return this.ctx.makePoint(Double.NaN, Double.NaN);
        }
        double y = this.getHeight() / 2.0 + this.minY;
        double x = this.getWidth() / 2.0 + this.minX;
        if (this.minX > this.maxX) {
            x = DistanceUtils.normLonDEG(x);
        }
        return new PointImpl(x, y, this.ctx);
    }

    @Override
    public boolean equals(Object obj) {
        return RectangleImpl.equals(this, obj);
    }

    public static boolean equals(Rectangle thiz, Object o) {
        assert (thiz != null);
        if (thiz == o) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        RectangleImpl rectangle = (RectangleImpl)o;
        if (Double.compare(rectangle.getMaxX(), thiz.getMaxX()) != 0) {
            return false;
        }
        if (Double.compare(rectangle.getMaxY(), thiz.getMaxY()) != 0) {
            return false;
        }
        if (Double.compare(rectangle.getMinX(), thiz.getMinX()) != 0) {
            return false;
        }
        return Double.compare(rectangle.getMinY(), thiz.getMinY()) == 0;
    }

    public int hashCode() {
        return RectangleImpl.hashCode(this);
    }

    public static int hashCode(Rectangle thiz) {
        long temp = thiz.getMinX() != 0.0 ? Double.doubleToLongBits(thiz.getMinX()) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = thiz.getMaxX() != 0.0 ? Double.doubleToLongBits(thiz.getMaxX()) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = thiz.getMinY() != 0.0 ? Double.doubleToLongBits(thiz.getMinY()) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = thiz.getMaxY() != 0.0 ? Double.doubleToLongBits(thiz.getMaxY()) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

