/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.fieldaccess;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.ThisObject;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedStringFieldAccess;

public class StringFieldAccess
extends FieldAccess {
    private JsonQuery field;

    public StringFieldAccess(JsonQuery obj, JsonQuery field, boolean permissive) {
        super(obj, permissive);
        this.field = field;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!(this.target instanceof ThisObject)) {
            builder.append(this.target.toString());
        }
        builder.append(".");
        builder.append(this.field);
        if (this.permissive) {
            builder.append("?");
        }
        return builder.toString();
    }

    @Override
    public ResolvedFieldAccess resolveFieldAccess(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<String> keys = new ArrayList<String>();
        for (JsonNode key : this.field.apply(scope, in)) {
            if (!key.isTextual()) {
                throw new IllegalStateException();
            }
            keys.add(key.asText());
        }
        return new ResolvedStringFieldAccess(this.permissive, keys);
    }
}

