/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.PreemptiveAuth;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.util.SolrBasicAuthentication;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.eclipse.jetty.client.HttpAuthenticationStore;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ProxyAuthenticationProtocolHandler;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;

public class PreemptiveBasicAuthClientBuilderFactory
implements HttpClientBuilderFactory {
    public static final String SYS_PROP_HTTP_CLIENT_CONFIG = "solr.httpclient.config";
    public static final String SYS_PROP_BASIC_AUTH_CREDENTIALS = "basicauth";
    private static PreemptiveAuth requestInterceptor = new PreemptiveAuth((AuthScheme)new BasicScheme());
    private static CredentialsResolver CREDENTIAL_RESOLVER = new CredentialsResolver();

    public static void setDefaultSolrParams(SolrParams params) {
        PreemptiveBasicAuthClientBuilderFactory.CREDENTIAL_RESOLVER.defaultParams = params;
    }

    @Override
    public void close() throws IOException {
        HttpClientUtil.removeRequestInterceptor(requestInterceptor);
    }

    @Override
    public void setup(Http2SolrClient client) {
        String basicAuthUser = PreemptiveBasicAuthClientBuilderFactory.CREDENTIAL_RESOLVER.defaultParams.get("httpBasicAuthUser");
        String basicAuthPass = PreemptiveBasicAuthClientBuilderFactory.CREDENTIAL_RESOLVER.defaultParams.get("httpBasicAuthPassword");
        this.setup(client, basicAuthUser, basicAuthPass);
    }

    public void setup(Http2SolrClient client, String basicAuthUser, String basicAuthPass) {
        if (basicAuthUser == null || basicAuthPass == null) {
            throw new IllegalArgumentException("username & password must be specified with " + this.getClass().getName());
        }
        HttpAuthenticationStore authenticationStore = new HttpAuthenticationStore();
        authenticationStore.addAuthentication((Authentication)new SolrBasicAuthentication(basicAuthUser, basicAuthPass));
        client.getHttpClient().setAuthenticationStore((AuthenticationStore)authenticationStore);
        client.getProtocolHandlers().put((ProtocolHandler)new WWWAuthenticationProtocolHandler(client.getHttpClient()));
        client.getProtocolHandlers().put((ProtocolHandler)new ProxyAuthenticationProtocolHandler(client.getHttpClient()));
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(Optional<SolrHttpClientBuilder> optionalBuilder) {
        String basicAuthUser = PreemptiveBasicAuthClientBuilderFactory.CREDENTIAL_RESOLVER.defaultParams.get("httpBasicAuthUser");
        String basicAuthPass = PreemptiveBasicAuthClientBuilderFactory.CREDENTIAL_RESOLVER.defaultParams.get("httpBasicAuthPassword");
        if (basicAuthUser == null || basicAuthPass == null) {
            throw new IllegalArgumentException("username & password must be specified with " + this.getClass().getName());
        }
        SolrHttpClientBuilder builder = optionalBuilder.isPresent() ? this.initHttpClientBuilder(optionalBuilder.get(), basicAuthUser, basicAuthPass) : this.initHttpClientBuilder(SolrHttpClientBuilder.create(), basicAuthUser, basicAuthPass);
        return builder;
    }

    private SolrHttpClientBuilder initHttpClientBuilder(SolrHttpClientBuilder builder, String basicAuthUser, String basicAuthPass) {
        builder.setDefaultCredentialsProvider(() -> {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthUser, basicAuthPass));
            return credsProvider;
        });
        HttpClientUtil.addRequestInterceptor(requestInterceptor);
        return builder;
    }

    static class CredentialsResolver {
        public volatile SolrParams defaultParams;

        public CredentialsResolver() {
            String credentials = System.getProperty(PreemptiveBasicAuthClientBuilderFactory.SYS_PROP_BASIC_AUTH_CREDENTIALS);
            String configFile = System.getProperty(PreemptiveBasicAuthClientBuilderFactory.SYS_PROP_HTTP_CLIENT_CONFIG);
            if (credentials != null && configFile != null) {
                throw new IllegalArgumentException("Basic authentication credentials passed via a configuration file as well as java system property. Please choose one mechanism!");
            }
            if (credentials != null) {
                List<String> ss = StrUtils.splitSmart(credentials, ':');
                if (ss.size() != 2 || StringUtils.isEmpty(ss.get(0)) || StringUtils.isEmpty(ss.get(1))) {
                    throw new IllegalArgumentException("Invalid Authentication credentials: Please provide 'basicauth' in the 'user:password' format");
                }
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("httpBasicAuthUser", ss.get(0));
                map.put("httpBasicAuthPassword", ss.get(1));
                this.defaultParams = new MapSolrParams(map);
            } else if (configFile != null) {
                Properties defaultProps = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(Paths.get(configFile, new String[0]), StandardCharsets.UTF_8);){
                    defaultProps.load(reader);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to read credentials file at " + configFile, e);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                defaultProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put((String)k, (String)v)));
                this.defaultParams = new MapSolrParams(map);
            } else {
                this.defaultParams = null;
            }
        }
    }
}

