/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDoubleArray;
import org.rrd4j.core.RrdInt;
import org.rrd4j.core.Util;

class RobinArray
implements Robin {
    private final Archive parentArc;
    private final RrdInt<Robin> pointer;
    private final RrdDoubleArray<Robin> values;
    private int rows;

    RobinArray(Archive parentArc, int rows, boolean shouldInitialize) throws IOException {
        this.parentArc = parentArc;
        this.pointer = new RrdInt<Robin>(this);
        this.values = new RrdDoubleArray<Robin>(this, rows);
        this.rows = rows;
        if (shouldInitialize) {
            this.pointer.set(0);
            this.values.set(0, Double.NaN, rows);
        }
    }

    @Override
    public double[] getValues() throws IOException {
        return this.getValues(0, this.rows);
    }

    @Override
    public void store(double newValue) throws IOException {
        int position = this.pointer.get();
        this.values.set(position, newValue);
        this.pointer.set((position + 1) % this.rows);
    }

    @Override
    public void bulkStore(double newValue, int bulkCount) throws IOException {
        assert (bulkCount <= this.rows) : "Invalid number of bulk updates: " + bulkCount + " rows=" + this.rows;
        int position = this.pointer.get();
        int tailUpdateCount = Math.min(this.rows - position, bulkCount);
        this.values.set(position, newValue, tailUpdateCount);
        this.pointer.set((position + tailUpdateCount) % this.rows);
        int headUpdateCount = bulkCount - tailUpdateCount;
        if (headUpdateCount > 0) {
            this.values.set(0, newValue, headUpdateCount);
            this.pointer.set(headUpdateCount);
        }
    }

    @Override
    public void update(double[] newValues) throws IOException {
        assert (this.rows == newValues.length) : "Invalid number of robin values supplied (" + newValues.length + "), exactly " + this.rows + " needed";
        this.pointer.set(0);
        this.values.writeDouble(0, newValues);
    }

    @Override
    public void setValues(double ... newValues) throws IOException {
        if (this.rows != newValues.length) {
            throw new IllegalArgumentException("Invalid number of robin values supplied (" + newValues.length + "), exactly " + this.rows + " needed");
        }
        this.update(newValues);
    }

    @Override
    public void setValues(double newValue) throws IOException {
        double[] values = new double[this.rows];
        for (int i = 0; i < values.length; ++i) {
            values[i] = newValue;
        }
        this.update(values);
    }

    @Override
    public String dump() throws IOException {
        double[] values;
        StringBuilder buffer = new StringBuilder("Robin " + this.pointer.get() + "/" + this.rows + ": ");
        for (double value : values = this.getValues()) {
            buffer.append(Util.formatDouble(value, true)).append(" ");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    @Override
    public double getValue(int index) throws IOException {
        int arrayIndex = (this.pointer.get() + index) % this.rows;
        return this.values.get(arrayIndex);
    }

    @Override
    public void setValue(int index, double value) throws IOException {
        int arrayIndex = (this.pointer.get() + index) % this.rows;
        this.values.set(arrayIndex, value);
    }

    @Override
    public double[] getValues(int index, int count) throws IOException {
        assert (count <= this.rows) : "Too many values requested: " + count + " rows=" + this.rows;
        int startIndex = (this.pointer.get() + index) % this.rows;
        int tailReadCount = Math.min(this.rows - startIndex, count);
        double[] tailValues = this.values.get(startIndex, tailReadCount);
        if (tailReadCount < count) {
            int headReadCount = count - tailReadCount;
            double[] headValues = this.values.get(0, headReadCount);
            double[] values = new double[count];
            int k = 0;
            for (double tailValue : tailValues) {
                values[k++] = tailValue;
            }
            for (double headValue : headValues) {
                values[k++] = headValue;
            }
            return values;
        }
        return tailValues;
    }

    @Override
    public Archive getParent() {
        return this.parentArc;
    }

    @Override
    public int getSize() {
        return this.rows;
    }

    @Override
    public void copyStateTo(Robin robin) throws IOException {
        int rowsDiff = this.rows - robin.getSize();
        for (int i = 0; i < robin.getSize(); ++i) {
            int j = i + rowsDiff;
            robin.store(j >= 0 ? this.getValue(j) : Double.NaN);
        }
    }

    @Override
    public void filterValues(double minValue, double maxValue) throws IOException {
        for (int i = 0; i < this.rows; ++i) {
            double value = this.values.get(i);
            if (!Double.isNaN(minValue) && !Double.isNaN(value) && minValue > value) {
                this.values.set(i, Double.NaN);
            }
            if (Double.isNaN(maxValue) || Double.isNaN(value) || !(maxValue < value)) continue;
            this.values.set(i, Double.NaN);
        }
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

