/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.analysis.ko.util.ConnectionCostsBuilder;
import org.apache.lucene.analysis.ko.util.TokenInfoDictionaryBuilder;
import org.apache.lucene.analysis.ko.util.UnknownDictionaryBuilder;

public class DictionaryBuilder {
    private DictionaryBuilder() {
    }

    public static void build(Path inputDir, Path outputDir, String encoding, boolean normalizeEntry) throws IOException {
        new TokenInfoDictionaryBuilder(encoding, normalizeEntry).build(inputDir).write(outputDir);
        new UnknownDictionaryBuilder(encoding).build(inputDir).write(outputDir);
        ConnectionCostsBuilder.build(inputDir.resolve("matrix.def")).write(outputDir);
    }

    public static void main(String[] args) throws IOException {
        String inputDirname = args[0];
        String outputDirname = args[1];
        String inputEncoding = args[2];
        boolean normalizeEntries = Boolean.parseBoolean(args[3]);
        DictionaryBuilder.build(Paths.get(inputDirname, new String[0]), Paths.get(outputDirname, new String[0]), inputEncoding, normalizeEntries);
    }
}

