/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.lucene.mockfile.FilterFileSystemProvider;

public class ShuffleFS
extends FilterFileSystemProvider {
    final long seed;

    public ShuffleFS(FileSystem delegate, long seed) {
        super("shuffle://", delegate);
        this.seed = seed;
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        try (DirectoryStream<Path> stream = super.newDirectoryStream(dir, filter);){
            final ArrayList<Path> contents = new ArrayList<Path>();
            for (Path path : stream) {
                contents.add(path);
            }
            Collections.sort(contents, (path1, path2) -> path1.getFileName().toString().compareTo(path2.getFileName().toString()));
            Collections.shuffle(contents, new Random(this.seed));
            DirectoryStream<Path> directoryStream = new DirectoryStream<Path>(){

                @Override
                public Iterator<Path> iterator() {
                    return contents.iterator();
                }

                @Override
                public void close() throws IOException {
                }
            };
            return directoryStream;
        }
    }
}

