/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;

public class PSTGlobalObjectId {
    protected static final byte[] ReferenceByteArrayID = new byte[]{4, 0, 0, 0, -126, 0, -32, 0, 116, -59, -73, 16, 26, -126, -32, 8};
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    byte[] ByteArrayID = new byte[16];
    byte YH;
    byte YL;
    byte M;
    byte D;
    int CreationTimeH;
    int CreationTimeL;
    Date CreationTime;
    long X = 0L;
    int Size;
    byte[] Data;

    public PSTGlobalObjectId(byte[] pidData) {
        if (pidData.length < 32) {
            throw new AssertionError((Object)"pidDate is too short");
        }
        System.arraycopy(pidData, 0, this.ByteArrayID, 0, ReferenceByteArrayID.length);
        if (!Arrays.equals(this.ByteArrayID, ReferenceByteArrayID)) {
            throw new AssertionError((Object)"ByteArrayID is incorrect");
        }
        ByteBuffer buffer = ByteBuffer.wrap(pidData, ReferenceByteArrayID.length, pidData.length - ReferenceByteArrayID.length).order(ByteOrder.LITTLE_ENDIAN);
        this.YH = buffer.get();
        this.YL = buffer.get();
        this.M = buffer.get();
        this.D = buffer.get();
        this.CreationTimeL = buffer.getInt();
        this.CreationTimeH = buffer.getInt();
        this.CreationTime = PSTObject.filetimeToDate(this.CreationTimeH, this.CreationTimeL);
        this.X = buffer.getLong();
        this.Size = buffer.getInt();
        if (buffer.remaining() != this.Size) {
            throw new AssertionError((Object)"Incorrect remaining date in buffer to extract data");
        }
        this.Data = new byte[buffer.remaining()];
        buffer.get(this.Data, 0, buffer.remaining());
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    protected int getYearHigh() {
        return this.YH;
    }

    protected int getYearLow() {
        return this.YL & 0xFF;
    }

    public int getYear() {
        return this.YH << 8 | this.YL & 0xFF;
    }

    public int getMonth() {
        return this.M;
    }

    public int getDay() {
        return this.D;
    }

    public Date getCreationTime() {
        return this.CreationTime;
    }

    protected int getCreationTimeLow() {
        return this.CreationTimeL;
    }

    protected int getCreationTimeHigh() {
        return this.CreationTimeH;
    }

    public int getDataSize() {
        return this.Size;
    }

    public byte[] getData() {
        return this.Data;
    }

    public String toString() {
        return "Byte Array ID[" + PSTGlobalObjectId.bytesToHex(this.ByteArrayID) + "] " + "Year [" + this.getYear() + "] " + "Month[" + this.M + "] " + "Day[" + this.D + "] CreationTime[" + this.CreationTime + "] " + "X[" + this.X + "] " + "Size[" + this.Size + "] " + "Data[" + PSTGlobalObjectId.bytesToHex(this.Data) + "]";
    }
}

