/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrMetricReporter
implements Closeable,
PluginInfoInitialized {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final String registryName;
    protected final SolrMetricManager metricManager;
    protected PluginInfo pluginInfo;
    protected boolean enabled = true;
    protected int period = 60;

    protected SolrMetricReporter(SolrMetricManager metricManager, String registryName) {
        this.registryName = registryName;
        this.metricManager = metricManager;
    }

    @Override
    public void init(PluginInfo pluginInfo) {
        if (pluginInfo != null) {
            this.pluginInfo = pluginInfo.copy();
            if (this.pluginInfo.initArgs != null) {
                SolrPluginUtils.invokeSetters(this, (Iterable<Map.Entry<String, Object>>)this.pluginInfo.initArgs);
            }
        }
        this.validate();
        if (!this.enabled) {
            log.info("Reporter disabled for registry {}", (Object)this.registryName);
            return;
        }
        log.debug("Initializing for registry {}", (Object)this.registryName);
        this.doInit();
    }

    protected abstract void doInit();

    public void setEnabled(Boolean enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getPeriod() {
        return this.period;
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    protected abstract void validate() throws IllegalStateException;

    public String toString() {
        return this.getClass().getName() + "{registryName='" + this.registryName + '\'' + ", pluginInfo=" + this.pluginInfo + '}';
    }
}

