/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.PostFilter;

public abstract class AnalyticsQuery
extends ExtendedQueryBase
implements PostFilter {
    @Override
    public boolean getCache() {
        return false;
    }

    @Override
    public int getCost() {
        return Math.max(super.getCost(), 100);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public AnalyticsQuery() {
    }

    public AnalyticsQuery(MergeStrategy mergeStrategy) {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        ResponseBuilder rb = info.getResponseBuilder();
        rb.addMergeStrategy(mergeStrategy);
    }

    @Override
    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        ResponseBuilder rb = null;
        if (info != null) {
            rb = info.getResponseBuilder();
        }
        if (rb == null) {
            return new DelegatingCollector();
        }
        return this.getAnalyticsCollector(rb, searcher);
    }

    public abstract DelegatingCollector getAnalyticsCollector(ResponseBuilder var1, IndexSearcher var2);

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }
}

