/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.query.FilterQuery;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.WrappedQuery;
import org.apache.solr.search.join.FiltersQParser;

public class BoolQParserPlugin
extends QParserPlugin {
    public static final String NAME = "bool";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new FiltersQParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                return this.parseImpl();
            }

            @Override
            protected Query unwrapQuery(Query query, BooleanClause.Occur occur) {
                if (occur == BooleanClause.Occur.FILTER) {
                    if (!(query instanceof ExtendedQuery) || ((ExtendedQuery)query).getCache()) {
                        return new FilterQuery(query);
                    }
                } else if (query instanceof WrappedQuery) {
                    return ((WrappedQuery)query).getWrappedQuery();
                }
                return query;
            }

            @Override
            protected Map<QParser, BooleanClause.Occur> clauses() throws SyntaxError {
                IdentityHashMap<QParser, BooleanClause.Occur> clauses = new IdentityHashMap<QParser, BooleanClause.Occur>();
                SolrParams solrParams = SolrParams.wrapDefaults((SolrParams)this.localParams, (SolrParams)this.params);
                this.addQueries(clauses, solrParams.getParams("must"), BooleanClause.Occur.MUST);
                this.addQueries(clauses, solrParams.getParams("must_not"), BooleanClause.Occur.MUST_NOT);
                this.addQueries(clauses, solrParams.getParams("filter"), BooleanClause.Occur.FILTER);
                this.addQueries(clauses, solrParams.getParams("should"), BooleanClause.Occur.SHOULD);
                return clauses;
            }

            private void addQueries(Map<QParser, BooleanClause.Occur> clausesDest, String[] subQueries, BooleanClause.Occur occur) throws SyntaxError {
                if (subQueries != null) {
                    for (String subQuery : subQueries) {
                        QParser subParser = this.subQuery(subQuery, null);
                        clausesDest.put(subParser, occur);
                    }
                }
            }
        };
    }
}

