/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.facet.SingletonDocIterator;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SweepCountAware;
import org.apache.solr.search.facet.UnionDocIterator;

abstract class SweepDocIterator
implements DocIterator,
SweepCountAware {
    public final int size;

    public SweepDocIterator(int size) {
        this.size = size;
    }

    static SweepIteratorAndCounts newInstance(SlotAcc.SweepCountAccStruct base, List<SlotAcc.SweepCountAccStruct> others) throws IOException {
        SlotAcc.SweepCountAccStruct entry;
        int activeCt;
        if (base == null) {
            activeCt = others.size();
            entry = others.get(0);
        } else {
            activeCt = others.size() + 1;
            entry = base;
        }
        if (activeCt == 1) {
            SlotAcc.CountSlotAcc[] countAccs = new SlotAcc.CountSlotAcc[]{entry.countAcc};
            return new SweepIteratorAndCounts(new SingletonDocIterator(entry.docSet.iterator(), base != null), countAccs);
        }
        DocIterator[] subIterators = new DocIterator[activeCt];
        SlotAcc.CountSlotAcc[] countAccs = new SlotAcc.CountSlotAcc[activeCt];
        Iterator<SlotAcc.SweepCountAccStruct> othersIter = others.iterator();
        int i = 0;
        while (true) {
            subIterators[i] = entry.docSet.iterator();
            countAccs[i] = entry.countAcc;
            if (++i == activeCt) break;
            entry = othersIter.next();
        }
        return new SweepIteratorAndCounts(new UnionDocIterator(subIterators, base == null ? -1 : 0), countAccs);
    }

    @Override
    public float score() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Integer next() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public abstract int registerCounts(SweepCountAware.SegCounter var1);

    static class SweepIteratorAndCounts {
        final SweepDocIterator iter;
        final SlotAcc.CountSlotAcc[] countAccs;

        public SweepIteratorAndCounts(SweepDocIterator iter, SlotAcc.CountSlotAcc[] countAccs) {
            this.iter = iter;
            this.countAccs = countAccs;
        }
    }
}

