/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.RuleBasedAuthorizationPluginBase;
import org.apache.solr.security.VerifiedUserRoles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalRoleRuleBasedAuthorizationPlugin
extends RuleBasedAuthorizationPluginBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void init(Map<String, Object> initInfo) {
        super.init(initInfo);
        if (initInfo.containsKey("user-role")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration should not contain 'user-role' mappings");
        }
    }

    @Override
    public Set<String> getUserRoles(Principal principal) {
        if (principal instanceof VerifiedUserRoles) {
            return ((VerifiedUserRoles)((Object)principal)).getVerifiedRoles();
        }
        return Collections.emptySet();
    }
}

