/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class DateTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId typeId, boolean bl) {
        if (typeId.isStringTypeId() && !typeId.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == typeId.getTypeFormatId();
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        int n = typeId.getJDBCTypeId();
        if (n == 91 || n == 1 || n == 12) {
            return true;
        }
        return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), "java.sql.Date");
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Date";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 10;
    }

    String nullMethodName() {
        return "getNullDate";
    }
}

