/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.utils.Validate;

@NotThreadSafe
@SdkProtectedApi
public final class DefaultServiceEndpointBuilder {
    private final String serviceName;
    private final String protocol;
    private Region region;
    private ProfileFile profileFile;
    private String profileName;

    public DefaultServiceEndpointBuilder(String serviceName, String protocol) {
        this.serviceName = (String)Validate.paramNotNull((Object)serviceName, (String)"serviceName");
        this.protocol = (String)Validate.paramNotNull((Object)protocol, (String)"protocol");
    }

    public DefaultServiceEndpointBuilder withRegion(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("Region cannot be null");
        }
        this.region = region;
        return this;
    }

    public DefaultServiceEndpointBuilder withProfileFile(ProfileFile profileFile) {
        this.profileFile = profileFile;
        return this;
    }

    public DefaultServiceEndpointBuilder withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public URI getServiceEndpoint() {
        ServiceMetadata serviceMetadata = ServiceMetadata.of((String)this.serviceName).reconfigure(c -> c.profileFile(() -> this.profileFile).profileName(this.profileName));
        URI endpoint = this.addProtocolToServiceEndpoint(serviceMetadata.endpointFor(this.region));
        if (endpoint.getHost() == null) {
            String error = "Configured region (" + this.region + ") resulted in an invalid URI: " + endpoint;
            List exampleRegions = serviceMetadata.regions();
            if (!exampleRegions.isEmpty()) {
                error = error + " Valid region examples: " + exampleRegions;
            }
            throw SdkClientException.create((String)error);
        }
        return endpoint;
    }

    private URI addProtocolToServiceEndpoint(URI endpointWithoutProtocol) throws IllegalArgumentException {
        try {
            return new URI(this.protocol + "://" + endpointWithoutProtocol);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Region getRegion() {
        return this.region;
    }
}

