/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.MetaData;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="The component that registers beans as MBeans")
public class MBeanContainer
implements Container.InheritedListener,
Dumpable,
Destroyable {
    private static final Logger LOG = Log.getLogger((String)MBeanContainer.class.getName());
    private static final ConcurrentMap<String, AtomicInteger> __unique = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Container ROOT = new ContainerLifeCycle();
    private final MBeanServer _mbeanServer;
    private final boolean _useCacheForOtherClassLoaders;
    private final ConcurrentMap<Class, MetaData> _metaData = new ConcurrentHashMap<Class, MetaData>();
    private final ConcurrentMap<Object, Container> _beans = new ConcurrentHashMap<Object, Container>();
    private final ConcurrentMap<Object, ObjectName> _mbeans = new ConcurrentHashMap<Object, ObjectName>();
    private String _domain = null;

    public MBeanContainer(MBeanServer server) {
        this(server, true);
    }

    public MBeanContainer(MBeanServer server, boolean cacheOtherClassLoaders) {
        this._mbeanServer = server;
        this._useCacheForOtherClassLoaders = cacheOtherClassLoaders;
    }

    public MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    @ManagedAttribute(value="Whether to use the cache for MBeans loaded by other ClassLoaders", readonly=true)
    public boolean isUseCacheForOtherClassLoaders() {
        return this._useCacheForOtherClassLoaders;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    @ManagedAttribute(value="The default ObjectName domain")
    public String getDomain() {
        return this._domain;
    }

    public Object mbeanFor(Object o) {
        return MBeanContainer.mbeanFor(this, o);
    }

    static Object mbeanFor(MBeanContainer container, Object o) {
        if (o == null) {
            return null;
        }
        Object mbean = MBeanContainer.findMetaData(container, o.getClass()).newInstance(o);
        if (mbean instanceof ObjectMBean) {
            ((ObjectMBean)mbean).setMBeanContainer(container);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MBean for {} is {}", new Object[]{o, mbean});
            if (mbean instanceof ObjectMBean) {
                MBeanInfo info = ((ObjectMBean)mbean).getMBeanInfo();
                for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
                    LOG.debug("  {}", new Object[]{mBeanAttributeInfo});
                }
                for (MBeanFeatureInfo mBeanFeatureInfo : info.getOperations()) {
                    LOG.debug("  {}", new Object[]{mBeanFeatureInfo});
                }
            }
        }
        return mbean;
    }

    static MetaData findMetaData(MBeanContainer container, Class<?> klass) {
        if (klass == null) {
            return null;
        }
        MetaData metaData = MBeanContainer.getMetaData(container, klass);
        if (metaData != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found cached {}", new Object[]{metaData});
            }
            return metaData;
        }
        return MBeanContainer.newMetaData(container, klass);
    }

    private static MetaData getMetaData(MBeanContainer container, Class<?> klass) {
        return container == null ? null : (MetaData)container._metaData.get(klass);
    }

    private static MetaData newMetaData(MBeanContainer container, Class<?> klass) {
        if (klass == null) {
            return null;
        }
        if (klass == Object.class) {
            return new MetaData(klass, null, null, Collections.emptyList());
        }
        List<MetaData> interfaces = Arrays.stream(klass.getInterfaces()).map(intf -> MBeanContainer.findMetaData(container, intf)).collect(Collectors.toList());
        MetaData metaData = new MetaData(klass, MBeanContainer.findConstructor(klass), MBeanContainer.findMetaData(container, klass.getSuperclass()), interfaces);
        if (container != null && (container.isUseCacheForOtherClassLoaders() || klass.getClassLoader() == container.getClass().getClassLoader())) {
            MetaData existing = container._metaData.putIfAbsent(klass, metaData);
            if (existing != null) {
                metaData = existing;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cached {}", new Object[]{metaData});
            }
        }
        return metaData;
    }

    private static Constructor<?> findConstructor(Class<?> klass) {
        Package pkg = klass.getPackage();
        if (pkg == null) {
            return null;
        }
        String pName = pkg.getName();
        String cName = klass.getName().substring(pName.isEmpty() ? 0 : pName.length() + 1);
        String mName = pName + ".jmx." + cName + "MBean";
        try {
            Constructor constructor;
            Class mbeanClass = Loader.loadClass(klass, (String)mName);
            Constructor constructor2 = constructor = ModelMBean.class.isAssignableFrom(mbeanClass) ? mbeanClass.getConstructor(new Class[0]) : mbeanClass.getConstructor(Object.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found MBean wrapper: {} for {}", new Object[]{mName, klass.getName()});
            }
            return constructor;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("MBean wrapper not found: {} for {}", new Object[]{mName, klass.getName()});
            }
            return null;
        }
    }

    public ObjectName findMBean(Object object) {
        return (ObjectName)this._mbeans.get(object);
    }

    public Object findBean(ObjectName objectName) {
        for (Map.Entry entry : this._mbeans.entrySet()) {
            if (!((ObjectName)entry.getValue()).equals(objectName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void beanAdded(Container parent, Object obj) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beanAdded {}->{}", new Object[]{parent, obj});
        }
        if (obj == null) {
            return;
        }
        if (parent == null) {
            parent = ROOT;
        }
        if (this._beans.putIfAbsent(obj, parent) != null) {
            return;
        }
        ObjectName parentObjectName = null;
        if (parent != ROOT && (parentObjectName = this.findMBean(parent)) == null) {
            this.beanAdded(null, parent);
            parentObjectName = this.findMBean(parent);
        }
        try {
            Object mbean = this.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName objectName = null;
            if (mbean instanceof ObjectMBean) {
                objectName = ((ObjectMBean)mbean).getObjectName();
            }
            if (objectName == null) {
                AtomicInteger existing;
                String basis;
                AtomicInteger count;
                String name;
                String context;
                String type;
                int dot;
                Class<?> klass = obj.getClass();
                while (klass.isArray()) {
                    klass = klass.getComponentType();
                }
                String domain = this._domain;
                if (domain == null) {
                    Package pkg = klass.getPackage();
                    String string = domain = pkg == null ? "" : pkg.getName();
                }
                if ((dot = (type = klass.getName().toLowerCase(Locale.ENGLISH)).lastIndexOf(46)) >= 0) {
                    type = type.substring(dot + 1);
                }
                StringBuilder buf = new StringBuilder();
                String string = context = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectContextBasis()) : null;
                if (context == null && parentObjectName != null) {
                    context = parentObjectName.getKeyProperty("context");
                }
                if (context != null && context.length() > 1) {
                    buf.append("context=").append(context).append(",");
                }
                buf.append("type=").append(type);
                String string2 = name = mbean instanceof ObjectMBean ? this.makeName(((ObjectMBean)mbean).getObjectNameBasis()) : context;
                if (name != null && name.length() > 1) {
                    buf.append(",").append("name=").append(name);
                }
                if ((count = (AtomicInteger)__unique.get(basis = buf.toString())) == null && (existing = __unique.putIfAbsent(basis, count = new AtomicInteger())) != null) {
                    count = existing;
                }
                objectName = ObjectName.getInstance(domain + ":" + basis + ",id=" + count.getAndIncrement());
            }
            this._mbeanServer.registerMBean(mbean, objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered {}", new Object[]{objectName});
            }
            this._mbeans.put(obj, objectName);
        }
        catch (Throwable x) {
            LOG.warn("bean: " + obj, x);
        }
    }

    public void beanRemoved(Container parent, Object obj) {
        ObjectName objectName;
        if (LOG.isDebugEnabled()) {
            LOG.debug("beanRemoved {}->{}", new Object[]{parent, obj});
        }
        if (parent == null) {
            parent = ROOT;
        }
        if (this._beans.remove(obj, parent) && (objectName = (ObjectName)this._mbeans.remove(obj)) != null) {
            this.unregister(objectName);
        }
    }

    public String makeName(String basis) {
        return StringUtil.sanitizeFileSystemName((String)basis);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this._mbeans.entrySet()});
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void destroy() {
        this._metaData.clear();
        this._mbeans.values().stream().filter(Objects::nonNull).forEach(this::unregister);
        this._mbeans.clear();
        this._beans.clear();
    }

    private void unregister(ObjectName objectName) {
        try {
            this.getMBeanServer().unregisterMBean(objectName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistered {}", new Object[]{objectName});
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException x) {
            LOG.ignore((Throwable)x);
        }
        catch (Throwable x) {
            LOG.warn(x);
        }
    }
}

