/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.boost;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.search.BoostAttribute;

public final class DelimitedBoostTokenFilter
extends TokenFilter {
    private final char delimiter;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final BoostAttribute boostAtt = (BoostAttribute)this.addAttribute(BoostAttribute.class);

    public DelimitedBoostTokenFilter(TokenStream input, char delimiter) {
        super(input);
        this.delimiter = delimiter;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != this.delimiter) continue;
                float boost = Float.parseFloat(new String(buffer, i + 1, length - (i + 1)));
                this.boostAtt.setBoost(boost);
                this.termAtt.setLength(i);
                return true;
            }
            return true;
        }
        return false;
    }
}

