/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

final class StackTraceElementResolver
implements TemplateResolver<StackTraceElement> {
    private static final TemplateResolver<StackTraceElement> CLASS_NAME_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeString(stackTraceElement.getClassName());
    private static final TemplateResolver<StackTraceElement> METHOD_NAME_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeString(stackTraceElement.getMethodName());
    private static final TemplateResolver<StackTraceElement> FILE_NAME_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeString(stackTraceElement.getFileName());
    private static final TemplateResolver<StackTraceElement> LINE_NUMBER_RESOLVER = (stackTraceElement, jsonWriter) -> jsonWriter.writeNumber(stackTraceElement.getLineNumber());
    private final TemplateResolver<StackTraceElement> internalResolver;

    StackTraceElementResolver(TemplateResolverConfig config) {
        this.internalResolver = this.createInternalResolver(config);
    }

    static String getName() {
        return "stackTraceElement";
    }

    private TemplateResolver<StackTraceElement> createInternalResolver(TemplateResolverConfig config) {
        String fieldName = config.getString("field");
        if ("className".equals(fieldName)) {
            return CLASS_NAME_RESOLVER;
        }
        if ("methodName".equals(fieldName)) {
            return METHOD_NAME_RESOLVER;
        }
        if ("fileName".equals(fieldName)) {
            return FILE_NAME_RESOLVER;
        }
        if ("lineNumber".equals(fieldName)) {
            return LINE_NUMBER_RESOLVER;
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    @Override
    public void resolve(StackTraceElement stackTraceElement, JsonWriter jsonWriter) {
        this.internalResolver.resolve(stackTraceElement, jsonWriter);
    }
}

