/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

class SimpleTextUtil {
    public static final byte NEWLINE = 10;
    public static final byte ESCAPE = 92;
    static final BytesRef CHECKSUM = new BytesRef((CharSequence)"checksum ");

    SimpleTextUtil() {
    }

    public static void write(DataOutput out, String s, BytesRefBuilder scratch) throws IOException {
        scratch.copyChars((CharSequence)s, 0, s.length());
        SimpleTextUtil.write(out, scratch.get());
    }

    public static void write(DataOutput out, BytesRef b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            byte bx = b.bytes[b.offset + i];
            if (bx == 10 || bx == 92) {
                out.writeByte((byte)92);
            }
            out.writeByte(bx);
        }
    }

    public static void writeNewline(DataOutput out) throws IOException {
        out.writeByte((byte)10);
    }

    public static void readLine(DataInput in, BytesRefBuilder scratch) throws IOException {
        int upto = 0;
        while (true) {
            byte b = in.readByte();
            scratch.grow(1 + upto);
            if (b == 92) {
                scratch.setByteAt(upto++, in.readByte());
                continue;
            }
            if (b == 10) break;
            scratch.setByteAt(upto++, b);
        }
        scratch.setLength(upto);
    }

    public static void writeChecksum(IndexOutput out, BytesRefBuilder scratch) throws IOException {
        String checksum = String.format(Locale.ROOT, "%020d", out.getChecksum());
        SimpleTextUtil.write((DataOutput)out, CHECKSUM);
        SimpleTextUtil.write((DataOutput)out, checksum, scratch);
        SimpleTextUtil.writeNewline((DataOutput)out);
    }

    public static void checkFooter(ChecksumIndexInput input) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        String expectedChecksum = String.format(Locale.ROOT, "%020d", input.getChecksum());
        SimpleTextUtil.readLine((DataInput)input, scratch);
        if (!StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)CHECKSUM)) {
            throw new CorruptIndexException("SimpleText failure: expected checksum line but got " + scratch.get().utf8ToString(), (DataInput)input);
        }
        String actualChecksum = new BytesRef(scratch.bytes(), SimpleTextUtil.CHECKSUM.length, scratch.length() - SimpleTextUtil.CHECKSUM.length).utf8ToString();
        if (!expectedChecksum.equals(actualChecksum)) {
            throw new CorruptIndexException("SimpleText checksum failure: " + actualChecksum + " != " + expectedChecksum, (DataInput)input);
        }
        if (input.length() != input.getFilePointer()) {
            throw new CorruptIndexException("Unexpected stuff at the end of file, please be careful with your text editor!", (DataInput)input);
        }
    }

    public static BytesRef fromBytesRefString(String s) {
        if (s.length() < 2) {
            throw new IllegalArgumentException("string " + s + " was not created from BytesRef.toString?");
        }
        if (s.charAt(0) != '[' || s.charAt(s.length() - 1) != ']') {
            throw new IllegalArgumentException("string " + s + " was not created from BytesRef.toString?");
        }
        String[] parts = s.substring(1, s.length() - 1).split(" ");
        byte[] bytes = new byte[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(parts[i], 16);
        }
        return new BytesRef(bytes);
    }
}

