/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.AutoValue_HttpRequestRunnable;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class HttpRequestRunnable<RequestT, ResponseT>
implements Runnable {
    HttpRequestRunnable() {
    }

    abstract HttpJsonCallOptions getHttpJsonCallOptions();

    abstract RequestT getRequest();

    abstract ApiMethodDescriptor<RequestT, ResponseT> getApiMethodDescriptor();

    abstract HttpTransport getHttpTransport();

    abstract String getEndpoint();

    abstract JsonFactory getJsonFactory();

    abstract ImmutableList<HttpJsonHeaderEnhancer> getHeaderEnhancers();

    abstract SettableApiFuture<ResponseT> getResponseFuture();

    HttpRequest createHttpRequest() throws IOException {
        EmptyContent jsonHttpContent;
        GenericData tokenRequest = new GenericData();
        HttpRequestFormatter<RequestT> requestFormatter = this.getApiMethodDescriptor().getRequestFormatter();
        Credentials credentials = this.getHttpJsonCallOptions().getCredentials();
        HttpRequestFactory requestFactory = credentials != null ? this.getHttpTransport().createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter(credentials)) : this.getHttpTransport().createRequestFactory();
        String requestBody = requestFormatter.getRequestBody(this.getRequest());
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            this.getJsonFactory().createJsonParser(requestBody).parse((Object)tokenRequest);
            jsonHttpContent = new JsonHttpContent(this.getJsonFactory(), (Object)tokenRequest).setMediaType(new HttpMediaType("application/json"));
        } else {
            jsonHttpContent = new EmptyContent();
        }
        GenericUrl url = new GenericUrl(this.getEndpoint() + requestFormatter.getPath(this.getRequest()));
        Map<String, List<String>> queryParams = requestFormatter.getQueryParamNames(this.getRequest());
        for (Map.Entry<String, List<String>> queryParam : queryParams.entrySet()) {
            if (queryParam.getValue() == null) continue;
            url.set(queryParam.getKey(), queryParam.getValue());
        }
        HttpRequest httpRequest = requestFactory.buildRequest(this.getApiMethodDescriptor().getHttpMethod(), url, (HttpContent)jsonHttpContent);
        for (HttpJsonHeaderEnhancer enhancer : this.getHeaderEnhancers()) {
            enhancer.enhance(httpRequest.getHeaders());
        }
        httpRequest.setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
        return httpRequest;
    }

    @Override
    public void run() {
        try {
            HttpRequest httpRequest = this.createHttpRequest();
            HttpResponse httpResponse = httpRequest.execute();
            if (!httpResponse.isSuccessStatusCode()) {
                ApiExceptionFactory.createException(null, (StatusCode)HttpJsonStatusCode.of(httpResponse.getStatusCode(), httpResponse.getStatusMessage()), (boolean)false);
            }
            if (this.getApiMethodDescriptor().getResponseParser() != null) {
                ResponseT response = this.getApiMethodDescriptor().getResponseParser().parse(httpResponse.getContent());
                this.getResponseFuture().set(response);
            } else {
                this.getResponseFuture().set(null);
            }
        }
        catch (Exception e) {
            this.getResponseFuture().setException((Throwable)e);
        }
    }

    static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new AutoValue_HttpRequestRunnable.Builder().setHeaderEnhancers(new LinkedList<HttpJsonHeaderEnhancer>());
    }

    static abstract class Builder<RequestT, ResponseT> {
        Builder() {
        }

        abstract Builder<RequestT, ResponseT> setHttpJsonCallOptions(HttpJsonCallOptions var1);

        abstract Builder<RequestT, ResponseT> setRequest(RequestT var1);

        abstract Builder<RequestT, ResponseT> setApiMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> var1);

        abstract Builder<RequestT, ResponseT> setHttpTransport(HttpTransport var1);

        abstract Builder<RequestT, ResponseT> setEndpoint(String var1);

        abstract Builder<RequestT, ResponseT> setJsonFactory(JsonFactory var1);

        abstract Builder<RequestT, ResponseT> setHeaderEnhancers(List<HttpJsonHeaderEnhancer> var1);

        abstract Builder<RequestT, ResponseT> setResponseFuture(SettableApiFuture<ResponseT> var1);

        abstract HttpRequestRunnable<RequestT, ResponseT> build();
    }
}

