/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.lang.UCharacter;
import org.apache.lucene.analysis.icu.segmentation.BreakIteratorWrapper;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ScriptIterator;

final class CompositeBreakIterator {
    private final ICUTokenizerConfig config;
    private final BreakIteratorWrapper[] wordBreakers = new BreakIteratorWrapper[1 + UCharacter.getIntPropertyMaxValue((int)4106)];
    private BreakIteratorWrapper rbbi;
    private final ScriptIterator scriptIterator;
    private char[] text;

    CompositeBreakIterator(ICUTokenizerConfig config) {
        this.config = config;
        this.scriptIterator = new ScriptIterator(config.combineCJ());
    }

    int next() {
        int next = this.rbbi.next();
        while (next == -1 && this.scriptIterator.next()) {
            this.rbbi = this.getBreakIterator(this.scriptIterator.getScriptCode());
            this.rbbi.setText(this.text, this.scriptIterator.getScriptStart(), this.scriptIterator.getScriptLimit() - this.scriptIterator.getScriptStart());
            next = this.rbbi.next();
        }
        return next == -1 ? -1 : next + this.scriptIterator.getScriptStart();
    }

    int current() {
        int current = this.rbbi.current();
        return current == -1 ? -1 : current + this.scriptIterator.getScriptStart();
    }

    int getRuleStatus() {
        return this.rbbi.getRuleStatus();
    }

    int getScriptCode() {
        return this.scriptIterator.getScriptCode();
    }

    void setText(char[] text, int start, int length) {
        this.text = text;
        this.scriptIterator.setText(text, start, length);
        if (this.scriptIterator.next()) {
            this.rbbi = this.getBreakIterator(this.scriptIterator.getScriptCode());
            this.rbbi.setText(text, this.scriptIterator.getScriptStart(), this.scriptIterator.getScriptLimit() - this.scriptIterator.getScriptStart());
        } else {
            this.rbbi = this.getBreakIterator(0);
            this.rbbi.setText(text, 0, 0);
        }
    }

    private BreakIteratorWrapper getBreakIterator(int scriptCode) {
        if (this.wordBreakers[scriptCode] == null) {
            this.wordBreakers[scriptCode] = new BreakIteratorWrapper(this.config.getBreakIterator(scriptCode));
        }
        return this.wordBreakers[scriptCode];
    }
}

