/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.request.SolrQueryRequest;

public class SolrQueryRequestContextUtils {
    private static final String LTR_PREFIX = "ltr.";
    private static final String FEATURE_LOGGER = "ltr.feature_logger";
    private static final String SCORING_QUERIES = "ltr.scoring_queries";
    private static final String IS_EXTRACTING_FEATURES = "ltr.isExtractingFeatures";
    private static final String STORE = "ltr.store";

    public static void setFeatureLogger(SolrQueryRequest req, FeatureLogger featureLogger) {
        req.getContext().put(FEATURE_LOGGER, featureLogger);
    }

    public static FeatureLogger getFeatureLogger(SolrQueryRequest req) {
        return (FeatureLogger)req.getContext().get(FEATURE_LOGGER);
    }

    public static void setScoringQueries(SolrQueryRequest req, LTRScoringQuery[] scoringQueries) {
        req.getContext().put(SCORING_QUERIES, scoringQueries);
    }

    public static LTRScoringQuery[] getScoringQueries(SolrQueryRequest req) {
        return (LTRScoringQuery[])req.getContext().get(SCORING_QUERIES);
    }

    public static void setIsExtractingFeatures(SolrQueryRequest req) {
        req.getContext().put(IS_EXTRACTING_FEATURES, Boolean.TRUE);
    }

    public static void clearIsExtractingFeatures(SolrQueryRequest req) {
        req.getContext().put(IS_EXTRACTING_FEATURES, Boolean.FALSE);
    }

    public static boolean isExtractingFeatures(SolrQueryRequest req) {
        return Boolean.TRUE.equals(req.getContext().get(IS_EXTRACTING_FEATURES));
    }

    public static void setFvStoreName(SolrQueryRequest req, String fvStoreName) {
        req.getContext().put(STORE, fvStoreName);
    }

    public static String getFvStoreName(SolrQueryRequest req) {
        return (String)req.getContext().get(STORE);
    }
}

