/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.MetadataElement;
import com.adobe.epubcheck.ctc.epubpackage.SpineItem;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.outWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EpubSpineCheck
implements DocumentValidator {
    private static final int MAX_SPINE_ITEM_THRESHOLD = 100;
    private final EpubPackage epubPack;
    private final Document doc;
    private final String pathRootFile;
    private final Report report;

    public EpubSpineCheck(EpubPackage epubPack, Report report) {
        this.epubPack = epubPack;
        this.doc = epubPack.getPackDoc();
        this.pathRootFile = epubPack.getPackageMainFile();
        this.report = report;
    }

    @Override
    public boolean validate() {
        boolean resExists = this.isSpineDefined(this.doc, this.pathRootFile);
        boolean resElements = this.tooManySpineElements(this.doc, this.pathRootFile, 100);
        return resExists && resElements;
    }

    private boolean isSpineDefined(Document doc, String pathRootFile) {
        Node spine;
        NodeList spines = doc.getElementsByTagNameNS("http://www.idpf.org/2007/opf", "spine");
        Node node = spine = spines.getLength() > 0 ? spines.item(0) : null;
        if (spine == null) {
            this.report.message(MessageId.OPF_019, EPUBLocation.create(pathRootFile), new Object[0]);
            outWriter.println("Spine element not found within package root document " + pathRootFile);
            return false;
        }
        return true;
    }

    private boolean tooManySpineElements(Document doc, String pathRootFile, int maxSpineElements) {
        NodeList spineElements;
        NodeList spine;
        boolean isFixedFormat = false;
        for (SpineItem si : this.epubPack.getSpine().getItems()) {
            String val = si.getProperties();
            if (val == null || !val.equalsIgnoreCase("rendition:layout-pre-paginated")) continue;
            isFixedFormat = true;
            break;
        }
        if (!isFixedFormat) {
            for (MetadataElement e : this.epubPack.getMetadata().getMetaElements()) {
                String val;
                String prop;
                if (!e.getName().equals("meta") || (prop = e.getAttribute("property")) == null || !prop.equalsIgnoreCase("rendition:layout") || (val = e.getValue()) == null || !val.equalsIgnoreCase("pre-paginated")) continue;
                isFixedFormat = true;
                break;
            }
        }
        if (!isFixedFormat && (spine = doc.getElementsByTagName("spine")).getLength() > 0 && (spineElements = spine.item(0).getChildNodes()).getLength() > maxSpineElements) {
            this.report.message(MessageId.OPF_020, EPUBLocation.create(pathRootFile), new Object[0]);
            return false;
        }
        return true;
    }
}

