/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.impl.PatternFuture;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.impl.SchemaReaderImpl;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.ParseReceiver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SchemaReceiverImpl
implements SchemaReceiver {
    private final ParseReceiver parser;
    private final PropertyMap properties;

    public SchemaReceiverImpl(ParseReceiver parseReceiver, PropertyMap propertyMap) {
        this.parser = parseReceiver;
        this.properties = propertyMap;
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xMLReader) throws SAXException {
        final SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(this.properties);
        DatatypeLibraryFactory datatypeLibraryFactory = RngProperty.DATATYPE_LIBRARY_FACTORY.get(this.properties);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        final PatternFuture patternFuture = SchemaBuilderImpl.installHandlers(this.parser, xMLReader, errorHandler, datatypeLibraryFactory, schemaPatternBuilder);
        return new SchemaFuture(){

            @Override
            public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
                try {
                    return SchemaReaderImpl.wrapPattern(patternFuture.getPattern(SchemaReceiverImpl.this.properties.contains(WrapProperty.ATTRIBUTE_OWNER)), schemaPatternBuilder, SchemaReceiverImpl.this.properties);
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    throw new IncorrectSchemaException();
                }
            }

            @Override
            public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
                if (runtimeException instanceof BuildException) {
                    try {
                        return SchemaBuilderImpl.unwrapBuildException((BuildException)runtimeException);
                    }
                    catch (IllegalSchemaException illegalSchemaException) {
                        throw new IncorrectSchemaException();
                    }
                }
                return runtimeException;
            }
        };
    }
}

