/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.mysql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.mysql.conf.MySQLDriver;
import org.apache.guacamole.auth.mysql.conf.MySQLEnvironment;
import org.apache.guacamole.auth.mysql.conf.MySQLSSLMode;
import org.mybatis.guice.datasource.helper.JdbcHelper;

public class MySQLAuthenticationProviderModule
implements Module {
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();
    private MySQLDriver mysqlDriver;

    public MySQLAuthenticationProviderModule(MySQLEnvironment environment) throws GuacamoleException {
        String clientPassword;
        File clientStore;
        String trustPassword;
        File trustStore;
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getMySQLHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getMySQLPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getMySQLDatabase());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
        this.driverProperties.setProperty("allowMultiQueries", "true");
        MySQLSSLMode sslMode = environment.getMySQLSSLMode();
        this.driverProperties.setProperty("sslMode", sslMode.getDriverValue());
        if (sslMode == MySQLSSLMode.DISABLED) {
            this.driverProperties.setProperty("useSSL", "false");
        }
        if ((trustStore = environment.getMySQLSSLTrustStore()) != null) {
            this.driverProperties.setProperty("trustCertificateKeyStoreUrl", trustStore.toURI().toString());
        }
        if ((trustPassword = environment.getMySQLSSLTrustPassword()) != null) {
            this.driverProperties.setProperty("trustCertificateKeyStorePassword", trustPassword);
        }
        if ((clientStore = environment.getMySQLSSLClientStore()) != null) {
            this.driverProperties.setProperty("clientCertificateKeyStoreUrl", clientStore.toURI().toString());
        }
        if ((clientPassword = environment.getMYSQLSSLClientPassword()) != null) {
            this.driverProperties.setProperty("clientCertificateKeyStorePassword", clientPassword);
        }
        this.mysqlDriver = environment.getMySQLDriver();
        TimeZone serverTz = environment.getServerTimeZone();
        if (serverTz != null) {
            this.driverProperties.setProperty("serverTimezone", serverTz.getID());
        }
    }

    @Override
    public void configure(Binder binder) {
        switch (this.mysqlDriver) {
            case MYSQL: {
                JdbcHelper.MySQL.configure(binder);
                break;
            }
            case MARIADB: {
                JdbcHelper.MariaDB.configure(binder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("A driver has been specified that is not supported by this module.");
            }
        }
        Names.bindProperties(binder, this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith(Names.named("JDBC.driverProperties")).toInstance(this.driverProperties);
    }
}

