"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./utils/constants");
function wrapToTau(a) {
    if (0 <= a && a <= constants_1.TAU)
        return a;
    if (a < 0)
        a -= constants_1.TAU * Math.floor(a / constants_1.TAU);
    return a > constants_1.TAU ? a % constants_1.TAU : a;
}
exports.wrapToTau = wrapToTau;
function diffAngle(a, b) {
    return ((a - b + Math.PI + constants_1.TAU) % constants_1.TAU) - Math.PI;
}
exports.diffAngle = diffAngle;
function meanAngle(a, b) {
    return (constants_1.TAU + b + diffAngle(a, b) / 2) % constants_1.TAU;
}
exports.meanAngle = meanAngle;
//# sourceMappingURL=geometry.js.map