/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherClassPathUtil;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;

public class ForkDefinition {
    private static final String STANDALONE_LAUNCHER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junitlauncher.StandaloneLauncher";
    private boolean includeAntRuntimeLibraries = true;
    private boolean includeJUnitPlatformLibraries = true;
    private final CommandlineJava commandLineJava;
    private final Environment env = new Environment();
    private String dir;
    private long timeout = -1L;

    ForkDefinition() {
        this.commandLineJava = new CommandlineJava();
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    String getDir() {
        return this.dir;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    long getTimeout() {
        return this.timeout;
    }

    public void setIncludeJUnitPlatformLibraries(boolean include) {
        this.includeJUnitPlatformLibraries = include;
    }

    public void setIncludeAntRuntimeLibraries(boolean include) {
        this.includeAntRuntimeLibraries = include;
    }

    public Commandline.Argument createJvmArg() {
        return this.commandLineJava.createVmArgument();
    }

    public void addConfiguredSysProperty(Environment.Variable sysProp) {
        sysProp.validate();
        this.commandLineJava.addSysproperty(sysProp);
    }

    public void addConfiguredSysPropertySet(PropertySet propertySet) {
        this.commandLineJava.addSyspropertyset(propertySet);
    }

    public void addConfiguredEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void addConfiguredModulePath(Path modulePath) {
        this.commandLineJava.createModulepath(modulePath.getProject()).add(modulePath);
    }

    public void addConfiguredUpgradeModulePath(Path upgradeModulePath) {
        this.commandLineJava.createUpgrademodulepath(upgradeModulePath.getProject()).add(upgradeModulePath);
    }

    Environment getEnv() {
        return this.env;
    }

    CommandlineJava generateCommandLine(JUnitLauncherTask task) {
        Path classPath;
        CommandlineJava cmdLine;
        try {
            cmdLine = (CommandlineJava)this.commandLineJava.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException((Throwable)e);
        }
        cmdLine.setClassname(STANDALONE_LAUNCHER_CLASS_NAME);
        Project project = task.getProject();
        ClassLoader taskClassLoader = ((Object)((Object)task)).getClass().getClassLoader();
        if (this.includeAntRuntimeLibraries) {
            Path antRuntimeResources = new Path(project);
            JUnitLauncherClassPathUtil.addAntRuntimeResourceLocations(antRuntimeResources, taskClassLoader);
            classPath = cmdLine.createClasspath(project);
            classPath.createPath().append(antRuntimeResources);
        } else {
            task.log("Excluding Ant runtime libraries from forked JVM classpath", 4);
        }
        if (this.includeJUnitPlatformLibraries) {
            Path junitPlatformResources = new Path(project);
            JUnitLauncherClassPathUtil.addJUnitPlatformResourceLocations(junitPlatformResources, taskClassLoader);
            classPath = cmdLine.createClasspath(project);
            classPath.createPath().append(junitPlatformResources);
        } else {
            task.log("Excluding JUnit platform libraries from forked JVM classpath", 4);
        }
        return cmdLine;
    }
}

