/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ArraySeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyHandler
implements InvocationHandler {
    final IPersistentMap fns;

    public ProxyHandler(IPersistentMap fns) {
        this.fns = fns;
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
        Class<?> rt = method.getReturnType();
        IFn fn2 = (IFn)this.fns.valAt(method.getName());
        if (fn2 == null) {
            if (rt == Void.TYPE) {
                return null;
            }
            if (method.getName().equals("equals")) {
                return proxy2 == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy2);
            }
            if (method.getName().equals("toString")) {
                return "Proxy: " + System.identityHashCode(proxy2);
            }
            throw new UnsupportedOperationException();
        }
        Object ret = fn2.applyTo(ArraySeq.create(args));
        if (rt == Void.TYPE) {
            return null;
        }
        if (rt.isPrimitive()) {
            if (rt == Character.TYPE) {
                return ret;
            }
            if (rt == Integer.TYPE) {
                return ((Number)ret).intValue();
            }
            if (rt == Long.TYPE) {
                return ((Number)ret).longValue();
            }
            if (rt == Float.TYPE) {
                return Float.valueOf(((Number)ret).floatValue());
            }
            if (rt == Double.TYPE) {
                return ((Number)ret).doubleValue();
            }
            if (rt == Boolean.TYPE && !(ret instanceof Boolean)) {
                return ret == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (rt == Byte.TYPE) {
                return (byte)((Number)ret).intValue();
            }
            if (rt == Short.TYPE) {
                return (short)((Number)ret).intValue();
            }
        }
        return ret;
    }
}

