/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class DependencyManagement
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<Dependency> dependencies;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation dependenciesLocation;

    public void addDependency(Dependency dependency) {
        this.getDependencies().add(dependency);
    }

    public DependencyManagement clone() {
        try {
            DependencyManagement copy2 = (DependencyManagement)super.clone();
            if (this.dependencies != null) {
                copy2.dependencies = new ArrayList<Dependency>();
                for (Dependency item : this.dependencies) {
                    copy2.dependencies.add(item.clone());
                }
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    return this.location;
                }
                case "dependencies": {
                    return this.dependenciesLocation;
                }
            }
            return this.getOtherLocation(key2);
        }
        return this.getOtherLocation(key2);
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    this.location = location;
                    return;
                }
                case "dependencies": {
                    this.dependenciesLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key2, location);
            return;
        }
        this.setOtherLocation(key2, location);
    }

    public void setOtherLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    private InputLocation getOtherLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public void removeDependency(Dependency dependency) {
        this.getDependencies().remove(dependency);
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }
}

