/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

public class BufferUtil {
    static final int TEMP_BUFFER_SIZE = 4096;
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    public static ByteBuffer allocate(int capacity) {
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.limit(0);
        return buf;
    }

    public static ByteBuffer allocateDirect(int capacity) {
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity);
        buf.limit(0);
        return buf;
    }

    public static ByteBuffer copy(ByteBuffer buffer2) {
        if (buffer2 == null) {
            return null;
        }
        int p = buffer2.position();
        ByteBuffer clone = buffer2.isDirect() ? ByteBuffer.allocateDirect(buffer2.remaining()) : ByteBuffer.allocate(buffer2.remaining());
        clone.put(buffer2);
        clone.flip();
        buffer2.position(p);
        return clone;
    }

    public static void reset(ByteBuffer buffer2) {
        if (buffer2 != null) {
            buffer2.order(ByteOrder.BIG_ENDIAN);
            buffer2.position(0);
            buffer2.limit(0);
        }
    }

    public static void clear(ByteBuffer buffer2) {
        if (buffer2 != null) {
            buffer2.position(0);
            buffer2.limit(0);
        }
    }

    public static void clearToFill(ByteBuffer buffer2) {
        if (buffer2 != null) {
            buffer2.position(0);
            buffer2.limit(buffer2.capacity());
        }
    }

    public static int flipToFill(ByteBuffer buffer2) {
        int limit;
        int position = buffer2.position();
        if (position == (limit = buffer2.limit())) {
            buffer2.position(0);
            buffer2.limit(buffer2.capacity());
            return 0;
        }
        int capacity = buffer2.capacity();
        if (limit == capacity) {
            buffer2.compact();
            return 0;
        }
        buffer2.position(limit);
        buffer2.limit(capacity);
        return position;
    }

    public static void flipToFlush(ByteBuffer buffer2, int position) {
        buffer2.limit(buffer2.position());
        buffer2.position(position);
    }

    public static void putIntLittleEndian(ByteBuffer buffer2, int value) {
        int p = BufferUtil.flipToFill(buffer2);
        buffer2.put((byte)(value & 0xFF));
        buffer2.put((byte)(value >>> 8 & 0xFF));
        buffer2.put((byte)(value >>> 16 & 0xFF));
        buffer2.put((byte)(value >>> 24 & 0xFF));
        BufferUtil.flipToFlush(buffer2, p);
    }

    public static byte[] toArray(ByteBuffer buffer2) {
        if (buffer2.hasArray()) {
            byte[] array2 = buffer2.array();
            int from = buffer2.arrayOffset() + buffer2.position();
            return Arrays.copyOfRange(array2, from, from + buffer2.remaining());
        }
        byte[] to = new byte[buffer2.remaining()];
        buffer2.slice().get(to);
        return to;
    }

    public static boolean isTheEmptyBuffer(ByteBuffer buf) {
        boolean isTheEmptyBuffer = buf == EMPTY_BUFFER;
        return isTheEmptyBuffer;
    }

    public static boolean isEmpty(ByteBuffer buf) {
        return buf == null || buf.remaining() == 0;
    }

    public static boolean isEmpty(ByteBuffer[] buf) {
        if (buf == null || buf.length == 0) {
            return true;
        }
        for (ByteBuffer b : buf) {
            if (b == null || !b.hasRemaining()) continue;
            return false;
        }
        return true;
    }

    public static long remaining(ByteBuffer ... buf) {
        long remaining = 0L;
        if (buf != null) {
            for (ByteBuffer b : buf) {
                if (b == null) continue;
                remaining += (long)b.remaining();
            }
        }
        return remaining;
    }

    public static boolean hasContent(ByteBuffer buf) {
        return buf != null && buf.remaining() > 0;
    }

    public static boolean isFull(ByteBuffer buf) {
        return buf != null && buf.limit() == buf.capacity();
    }

    public static int length(ByteBuffer buffer2) {
        return buffer2 == null ? 0 : buffer2.remaining();
    }

    public static int space(ByteBuffer buffer2) {
        if (buffer2 == null) {
            return 0;
        }
        return buffer2.capacity() - buffer2.limit();
    }

    public static boolean compact(ByteBuffer buffer2) {
        if (buffer2.position() == 0) {
            return false;
        }
        boolean full = buffer2.limit() == buffer2.capacity();
        buffer2.compact().flip();
        return full && buffer2.limit() < buffer2.capacity();
    }

    public static int put(ByteBuffer from, ByteBuffer to) {
        int put;
        int remaining = from.remaining();
        if (remaining > 0) {
            if (remaining <= to.remaining()) {
                to.put(from);
                put = remaining;
                from.position(from.limit());
            } else if (from.hasArray()) {
                put = to.remaining();
                to.put(from.array(), from.arrayOffset() + from.position(), put);
                from.position(from.position() + put);
            } else {
                put = to.remaining();
                ByteBuffer slice = from.slice();
                slice.limit(put);
                to.put(slice);
                from.position(from.position() + put);
            }
        } else {
            put = 0;
        }
        return put;
    }

    public static int flipPutFlip(ByteBuffer from, ByteBuffer to) {
        return BufferUtil.append(to, from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(ByteBuffer to, byte[] b, int off, int len) throws BufferOverflowException {
        int pos = BufferUtil.flipToFill(to);
        try {
            to.put(b, off, len);
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static void append(ByteBuffer to, byte b) {
        int pos = BufferUtil.flipToFill(to);
        try {
            to.put(b);
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int append(ByteBuffer to, ByteBuffer b) {
        int pos = BufferUtil.flipToFill(to);
        try {
            int n = BufferUtil.put(b, to);
            return n;
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fill(ByteBuffer to, byte[] b, int off, int len) {
        int pos = BufferUtil.flipToFill(to);
        try {
            int remaining = to.remaining();
            int take2 = remaining < len ? remaining : len;
            to.put(b, off, take2);
            int n = take2;
            return n;
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static void readFrom(File file2, ByteBuffer buffer2) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file2, "r");){
            FileChannel channel = raf.getChannel();
            for (long needed = raf.length(); needed > 0L && buffer2.hasRemaining(); needed -= (long)channel.read(buffer2)) {
            }
        }
    }

    public static void readFrom(InputStream is2, int needed, ByteBuffer buffer2) throws IOException {
        int l;
        ByteBuffer tmp = BufferUtil.allocate(8192);
        while (needed > 0 && buffer2.hasRemaining() && (l = is2.read(tmp.array(), 0, 8192)) >= 0) {
            tmp.position(0);
            tmp.limit(l);
            buffer2.put(tmp);
        }
    }

    public static void writeTo(ByteBuffer buffer2, OutputStream out) throws IOException {
        if (buffer2.hasArray()) {
            out.write(buffer2.array(), buffer2.arrayOffset() + buffer2.position(), buffer2.remaining());
            buffer2.position(buffer2.position() + buffer2.remaining());
        } else {
            byte[] bytes2 = new byte[Math.min(buffer2.remaining(), 4096)];
            while (buffer2.hasRemaining()) {
                int byteCountToWrite = Math.min(buffer2.remaining(), 4096);
                buffer2.get(bytes2, 0, byteCountToWrite);
                out.write(bytes2, 0, byteCountToWrite);
            }
        }
    }

    public static String toString(ByteBuffer buffer2) {
        return BufferUtil.toString(buffer2, StandardCharsets.ISO_8859_1);
    }

    public static String toUTF8String(ByteBuffer buffer2) {
        return BufferUtil.toString(buffer2, StandardCharsets.UTF_8);
    }

    public static String toString(ByteBuffer buffer2, Charset charset) {
        byte[] array2;
        if (buffer2 == null) {
            return null;
        }
        byte[] byArray = array2 = buffer2.hasArray() ? buffer2.array() : null;
        if (array2 == null) {
            byte[] to = new byte[buffer2.remaining()];
            buffer2.slice().get(to);
            return new String(to, 0, to.length, charset);
        }
        return new String(array2, buffer2.arrayOffset() + buffer2.position(), buffer2.remaining(), charset);
    }

    public static String toString(ByteBuffer buffer2, int position, int length, Charset charset) {
        byte[] array2;
        if (buffer2 == null) {
            return null;
        }
        byte[] byArray = array2 = buffer2.hasArray() ? buffer2.array() : null;
        if (array2 == null) {
            ByteBuffer ro = buffer2.asReadOnlyBuffer();
            ro.position(position);
            ro.limit(position + length);
            byte[] to = new byte[length];
            ro.get(to);
            return new String(to, 0, to.length, charset);
        }
        return new String(array2, buffer2.arrayOffset() + position, length, charset);
    }

    public static int toInt(ByteBuffer buffer2) {
        return BufferUtil.toInt(buffer2, buffer2.position(), buffer2.remaining());
    }

    public static int toInt(ByteBuffer buffer2, int position, int length) {
        int val2 = 0;
        boolean started = false;
        boolean minus = false;
        int limit = position + length;
        if (length <= 0) {
            throw new NumberFormatException(BufferUtil.toString(buffer2, position, length, StandardCharsets.UTF_8));
        }
        for (int i = position; i < limit; ++i) {
            byte b = buffer2.get(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val2 = val2 * 10 + (b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val2 : val2;
        }
        throw new NumberFormatException(BufferUtil.toString(buffer2));
    }

    public static int takeInt(ByteBuffer buffer2) {
        int i;
        int val2 = 0;
        boolean started = false;
        boolean minus = false;
        for (i = buffer2.position(); i < buffer2.limit(); ++i) {
            byte b = buffer2.get(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val2 = val2 * 10 + (b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus = true;
        }
        if (started) {
            buffer2.position(i);
            return minus ? -val2 : val2;
        }
        throw new NumberFormatException(BufferUtil.toString(buffer2));
    }

    public static long toLong(ByteBuffer buffer2) {
        long val2 = 0L;
        boolean started = false;
        boolean minus = false;
        for (int i = buffer2.position(); i < buffer2.limit(); ++i) {
            byte b = buffer2.get(i);
            if (b <= 32) {
                if (!started) continue;
                break;
            }
            if (b >= 48 && b <= 57) {
                val2 = val2 * 10L + (long)(b - 48);
                started = true;
                continue;
            }
            if (b != 45 || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val2 : val2;
        }
        throw new NumberFormatException(BufferUtil.toString(buffer2));
    }

    public static void putHexInt(ByteBuffer buffer2, int n) {
        if (n < 0) {
            buffer2.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer2.put((byte)56);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                buffer2.put((byte)48);
                return;
            }
            n = -n;
        }
        if (n < 16) {
            buffer2.put(DIGIT[n]);
        } else {
            boolean started = false;
            for (int hexDivisor : hexDivisors) {
                if (n < hexDivisor) {
                    if (!started) continue;
                    buffer2.put((byte)48);
                    continue;
                }
                started = true;
                int d = n / hexDivisor;
                buffer2.put(DIGIT[d]);
                n -= d * hexDivisor;
            }
        }
    }

    public static void putDecInt(ByteBuffer buffer2, int n) {
        if (n < 0) {
            buffer2.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer2.put((byte)50);
                n = 147483648;
            } else {
                n = -n;
            }
        }
        if (n < 10) {
            buffer2.put(DIGIT[n]);
        } else {
            boolean started = false;
            for (int decDivisor : decDivisors) {
                if (n < decDivisor) {
                    if (!started) continue;
                    buffer2.put((byte)48);
                    continue;
                }
                started = true;
                int d = n / decDivisor;
                buffer2.put(DIGIT[d]);
                n -= d * decDivisor;
            }
        }
    }

    public static void putDecLong(ByteBuffer buffer2, long n) {
        if (n < 0L) {
            buffer2.put((byte)45);
            if (n == Long.MIN_VALUE) {
                buffer2.put((byte)57);
                n = 223372036854775808L;
            } else {
                n = -n;
            }
        }
        if (n < 10L) {
            buffer2.put(DIGIT[(int)n]);
        } else {
            boolean started = false;
            for (long aDecDivisorsL : decDivisorsL) {
                if (n < aDecDivisorsL) {
                    if (!started) continue;
                    buffer2.put((byte)48);
                    continue;
                }
                started = true;
                long d = n / aDecDivisorsL;
                buffer2.put(DIGIT[(int)d]);
                n -= d * aDecDivisorsL;
            }
        }
    }

    public static ByteBuffer toBuffer(int value) {
        ByteBuffer buf = ByteBuffer.allocate(32);
        BufferUtil.putDecInt(buf, value);
        return buf;
    }

    public static ByteBuffer toBuffer(long value) {
        ByteBuffer buf = ByteBuffer.allocate(32);
        BufferUtil.putDecLong(buf, value);
        return buf;
    }

    public static ByteBuffer toBuffer(String s2) {
        return BufferUtil.toBuffer(s2, StandardCharsets.ISO_8859_1);
    }

    public static ByteBuffer toBuffer(String s2, Charset charset) {
        if (s2 == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(s2.getBytes(charset));
    }

    public static ByteBuffer toBuffer(byte[] array2) {
        if (array2 == null) {
            return EMPTY_BUFFER;
        }
        return BufferUtil.toBuffer(array2, 0, array2.length);
    }

    public static ByteBuffer toBuffer(byte[] array2, int offset, int length) {
        if (array2 == null) {
            return EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(array2, offset, length);
    }

    public static ByteBuffer toDirectBuffer(String s2) {
        return BufferUtil.toDirectBuffer(s2, StandardCharsets.ISO_8859_1);
    }

    public static ByteBuffer toDirectBuffer(String s2, Charset charset) {
        if (s2 == null) {
            return EMPTY_BUFFER;
        }
        byte[] bytes2 = s2.getBytes(charset);
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes2.length);
        buf.put(bytes2);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toMappedBuffer(File file2) throws IOException {
        return BufferUtil.toMappedBuffer(file2.toPath(), 0L, file2.length());
    }

    public static ByteBuffer toMappedBuffer(Path filePath, long pos, long len) throws IOException {
        try (FileChannel channel = FileChannel.open(filePath, StandardOpenOption.READ);){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, pos, len);
            return mappedByteBuffer;
        }
    }

    @Deprecated
    public static boolean isMappedBuffer(ByteBuffer buffer2) {
        return false;
    }

    public static ByteBuffer toBuffer(Resource resource2, boolean direct) throws IOException {
        long len = resource2.length();
        if (len < 0L) {
            throw new IllegalArgumentException("invalid resource: " + resource2 + " len=" + len);
        }
        if (len > Integer.MAX_VALUE) {
            return null;
        }
        int ilen = (int)len;
        ByteBuffer buffer2 = direct ? BufferUtil.allocateDirect(ilen) : BufferUtil.allocate(ilen);
        int pos = BufferUtil.flipToFill(buffer2);
        if (resource2.getFile() != null) {
            BufferUtil.readFrom(resource2.getFile(), buffer2);
        } else {
            try (InputStream is2 = resource2.getInputStream();){
                BufferUtil.readFrom(is2, ilen, buffer2);
            }
        }
        BufferUtil.flipToFlush(buffer2, pos);
        return buffer2;
    }

    public static String toSummaryString(ByteBuffer buffer2) {
        if (buffer2 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[p=");
        buf.append(buffer2.position());
        buf.append(",l=");
        buf.append(buffer2.limit());
        buf.append(",c=");
        buf.append(buffer2.capacity());
        buf.append(",r=");
        buf.append(buffer2.remaining());
        buf.append("]");
        return buf.toString();
    }

    public static String toDetailString(ByteBuffer[] buffer2) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < buffer2.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(BufferUtil.toDetailString(buffer2[i]));
        }
        builder.append(']');
        return builder.toString();
    }

    private static void idString(ByteBuffer buffer2, StringBuilder out) {
        out.append(buffer2.getClass().getSimpleName());
        out.append("@");
        if (buffer2.hasArray() && buffer2.arrayOffset() == 4) {
            out.append('T');
            byte[] array2 = buffer2.array();
            TypeUtil.toHex(array2[0], (Appendable)out);
            TypeUtil.toHex(array2[1], (Appendable)out);
            TypeUtil.toHex(array2[2], (Appendable)out);
            TypeUtil.toHex(array2[3], (Appendable)out);
        } else {
            out.append(Integer.toHexString(System.identityHashCode(buffer2)));
        }
    }

    public static String toIDString(ByteBuffer buffer2) {
        StringBuilder buf = new StringBuilder();
        BufferUtil.idString(buffer2, buf);
        return buf.toString();
    }

    public static String toDetailString(ByteBuffer buffer2) {
        if (buffer2 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        BufferUtil.idString(buffer2, buf);
        buf.append("[p=");
        buf.append(buffer2.position());
        buf.append(",l=");
        buf.append(buffer2.limit());
        buf.append(",c=");
        buf.append(buffer2.capacity());
        buf.append(",r=");
        buf.append(buffer2.remaining());
        buf.append("]={");
        BufferUtil.appendDebugString(buf, buffer2);
        buf.append("}");
        return buf.toString();
    }

    private static void appendDebugString(StringBuilder buf, ByteBuffer buffer2) {
        buffer2 = buffer2.asReadOnlyBuffer();
        try {
            int i;
            for (i = 0; i < buffer2.position(); ++i) {
                BufferUtil.appendContentChar(buf, buffer2.get(i));
                if (i != 8 || buffer2.position() <= 16) continue;
                buf.append("...");
                i = buffer2.position() - 8;
            }
            buf.append("<<<");
            for (i = buffer2.position(); i < buffer2.limit(); ++i) {
                BufferUtil.appendContentChar(buf, buffer2.get(i));
                if (i != buffer2.position() + 24 || buffer2.limit() <= buffer2.position() + 48) continue;
                buf.append("...");
                i = buffer2.limit() - 24;
            }
            buf.append(">>>");
            int limit = buffer2.limit();
            buffer2.limit(buffer2.capacity());
            for (int i2 = limit; i2 < buffer2.capacity(); ++i2) {
                BufferUtil.appendContentChar(buf, buffer2.get(i2));
                if (i2 != limit + 8 || buffer2.capacity() <= limit + 16) continue;
                buf.append("...");
                i2 = buffer2.capacity() - 8;
            }
            buffer2.limit(limit);
        }
        catch (Throwable x) {
            Log.getRootLogger().ignore(x);
            buf.append("!!concurrent mod!!");
        }
    }

    private static void appendContentChar(StringBuilder buf, byte b) {
        if (b == 92) {
            buf.append("\\\\");
        } else if (b >= 32 && b <= 126) {
            buf.append((char)b);
        } else if (b == 13) {
            buf.append("\\r");
        } else if (b == 10) {
            buf.append("\\n");
        } else if (b == 9) {
            buf.append("\\t");
        } else {
            buf.append("\\x").append(TypeUtil.toHexString(b));
        }
    }

    public static String toHexSummary(ByteBuffer buffer2) {
        if (buffer2 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("b[").append(buffer2.remaining()).append("]=");
        for (int i = buffer2.position(); i < buffer2.limit(); ++i) {
            TypeUtil.toHex(buffer2.get(i), (Appendable)buf);
            if (i != buffer2.position() + 24 || buffer2.limit() <= buffer2.position() + 32) continue;
            buf.append("...");
            i = buffer2.limit() - 8;
        }
        return buf.toString();
    }

    public static String toHexString(ByteBuffer buffer2) {
        if (buffer2 == null) {
            return "null";
        }
        return TypeUtil.toHexString(BufferUtil.toArray(buffer2));
    }

    public static void putCRLF(ByteBuffer buffer2) {
        buffer2.put((byte)13);
        buffer2.put((byte)10);
    }

    public static boolean isPrefix(ByteBuffer prefix, ByteBuffer buffer2) {
        if (prefix.remaining() > buffer2.remaining()) {
            return false;
        }
        int bi = buffer2.position();
        for (int i = prefix.position(); i < prefix.limit(); ++i) {
            if (prefix.get(i) == buffer2.get(bi++)) continue;
            return false;
        }
        return true;
    }

    public static ByteBuffer ensureCapacity(ByteBuffer buffer2, int capacity) {
        if (buffer2 == null) {
            return BufferUtil.allocate(capacity);
        }
        if (buffer2.capacity() >= capacity) {
            return buffer2;
        }
        if (buffer2.hasArray()) {
            return ByteBuffer.wrap(Arrays.copyOfRange(buffer2.array(), buffer2.arrayOffset(), buffer2.arrayOffset() + capacity), buffer2.position(), buffer2.remaining());
        }
        throw new UnsupportedOperationException();
    }
}

