/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InputMapUIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;

public class WindowsPasswordFieldPatch
implements LookAndFeelPatch {
    public boolean isApplicable(Environment env) {
        return env.isWindowsLookAndFeel();
    }

    public void patch(Environment env) {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("PasswordField.patchDisabledBackground", Boolean.TRUE);
        defaults.put("PasswordField.patchReadOnlyBackground", Boolean.TRUE);
        if (env.isWindowsXP()) {
            defaults.put("PasswordFieldUI", "net.java.plaf.windows.xp.XPPasswordFieldUI");
        } else {
            defaults.put("PasswordFieldUI", "net.java.plaf.windows.common.WindowsPasswordFieldUI");
        }
        Object o = defaults.get("PasswordField.focusInputMap");
        if (o != null && o instanceof InputMapUIResource) {
            InputMapUIResource inputMap = (InputMapUIResource)o;
            Object beginLine = inputMap.get(KeyStroke.getKeyStroke("HOME"));
            Object endLine = inputMap.get(KeyStroke.getKeyStroke("END"));
            Object selectionBeginLine = inputMap.get(KeyStroke.getKeyStroke("shift HOME"));
            Object selectionEndLine = inputMap.get(KeyStroke.getKeyStroke("shift END"));
            inputMap.put(KeyStroke.getKeyStroke("ctrl LEFT"), beginLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl KP_LEFT"), beginLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl RIGHT"), endLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl KP_RIGHT"), endLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl shift LEFT"), selectionBeginLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl shift KP_LEFT"), selectionBeginLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl shift RIGHT"), selectionEndLine);
            inputMap.put(KeyStroke.getKeyStroke("ctrl shift KP_RIGHT"), selectionEndLine);
            defaults.put("PasswordField.focusInputMap", inputMap);
        }
    }

    public void unpatch() {
    }
}

