/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.actions;

import com.almworks.tracklink.vcslinks.VCSUtil;
import com.almworks.util.Log;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.checkin.DifferenceType;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Date;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class ShowDiffDialogAction
extends AnAction {
    public void update(AnActionEvent e) {
        Date date;
        Project project = (Project)e.getDataContext().getData("project");
        VirtualFile file = (VirtualFile)e.getDataContext().getData("virtualFile");
        Date date2 = date = file != null ? (Date)file.getUserData(VCSUtil.VCS_MODIFICATION_DATE) : null;
        if (file == null || project == null || date == null) {
            e.getPresentation().setVisible(false);
        } else {
            e.getPresentation().setVisible(file.getUserData(VCSUtil.VCS_DIFFERENCE_TYPE) == DifferenceType.MODIFIED);
        }
        e.getPresentation().setEnabled(e.getPresentation().isVisible());
    }

    public void actionPerformed(AnActionEvent e) {
        if (!this.checkUsageEvent(e.getInputEvent())) {
            return;
        }
        Project project = (Project)e.getDataContext().getData("project");
        VirtualFile file = (VirtualFile)e.getDataContext().getData("virtualFile");
        if (file != null && project != null) {
            Date date = (Date)file.getUserData(VCSUtil.VCS_MODIFICATION_DATE);
            try {
                Pair<VcsFileRevision, VcsFileRevision> revisionPair = VCSUtil.getAppropriateRevisionPair(project, file, date, 60000L);
                if (revisionPair != null && revisionPair.getFirst() != null && revisionPair.getSecond() != null) {
                    VCSUtil.showDiffDialog((VcsFileRevision)revisionPair.getFirst(), (VcsFileRevision)revisionPair.getSecond(), project, file);
                }
            }
            catch (VcsException e1) {
                Log.warn("" + file, e1);
            }
            catch (IOException e1) {
                Log.warn("" + file, e1);
            }
        }
    }

    private boolean checkUsageEvent(InputEvent event) {
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        if (mouseEvent.getClickCount() != 2) {
            return true;
        }
        Point point = mouseEvent.getPoint();
        Component component = mouseEvent.getComponent();
        Component target = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        if (!(target instanceof JTree)) {
            return false;
        }
        JTree tree = (JTree)target;
        Point treePoint = SwingUtilities.convertPoint(component, point, target);
        TreePath path = tree.getPathForLocation(treePoint.x, treePoint.y);
        if (path == null) {
            return false;
        }
        Object node = path.getLastPathComponent();
        if (node == null) {
            assert (false) : path;
            return false;
        }
        String className = node.getClass().getName();
        if (!className.endsWith(".UsageNode")) {
            return false;
        }
        if (!(node instanceof Navigatable)) {
            return false;
        }
        boolean canNavigate = ((Navigatable)node).canNavigateToSource();
        return !canNavigate;
    }
}

