/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.util.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    public AWSCredentials getCredentials() {
        String accessKey = StringUtils.trim(System.getProperty("aws.accessKeyId"));
        String secretKey = StringUtils.trim(System.getProperty("aws.secretKey"));
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new AmazonClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

