/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;

public class LocalHttpCacheURIDereferencer
implements URIDereferencer {
    private final URIDereferencer ud = XMLSignatureFactory.getInstance().getURIDereferencer();
    private final File f;
    private static final String FS = System.getProperty("file.separator");
    private static final String BASEDIR = System.getProperty("basedir");

    public LocalHttpCacheURIDereferencer() {
        String string = BASEDIR == null ? "./" : BASEDIR;
        File file = new File(string + FS + "data" + FS + "javax" + FS + "xml" + FS + "crypto" + FS + "dsig");
        this.f = new File(file, "xml-stylesheet");
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        String string = uRIReference.getURI();
        if (string.equals("http://www.w3.org/TR/xml-stylesheet")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.f);
                return new OctetStreamData(fileInputStream, uRIReference.getURI(), uRIReference.getType());
            }
            catch (Exception exception) {
                throw new URIReferenceException(exception);
            }
        }
        return this.ud.dereference(uRIReference, xMLCryptoContext);
    }
}

