/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.CheckManager;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFChecker;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.ocf.OCFZipPackage;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.util.WriterReportImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipFile;

public class EpubCheck
implements DocumentValidator {
    private static String VERSION = null;
    private static String BUILD_DATE = null;
    private final File epubFile;
    private final EPUBProfile profile;
    private final Report report;

    public static String version() {
        if (VERSION == null) {
            Properties prop = new Properties();
            InputStream in = EpubCheck.class.getResourceAsStream("project.properties");
            try {
                prop.load(in);
            }
            catch (Exception e) {
                System.err.println("Couldn't read project properties: " + e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            VERSION = prop.getProperty("version");
            BUILD_DATE = prop.getProperty("buildDate");
        }
        return VERSION;
    }

    public static String buildDate() {
        return BUILD_DATE;
    }

    public EpubCheck(File epubFile) {
        this(epubFile, new DefaultReportImpl(epubFile.getName()));
    }

    public EpubCheck(File epubFile, PrintWriter out) {
        this(epubFile, new WriterReportImpl(out));
    }

    public EpubCheck(File epubFile, Report report) {
        this(epubFile, report, null);
    }

    public EpubCheck(File epubFile, Report report, EPUBProfile profile) {
        this.epubFile = epubFile;
        this.report = report;
        this.profile = profile == null ? EPUBProfile.DEFAULT : profile;
    }

    public EpubCheck(InputStream inputStream, Report report, String uri) {
        this(inputStream, report, uri, EPUBProfile.DEFAULT);
    }

    public EpubCheck(InputStream inputStream, Report report, String uri, EPUBProfile profile) {
        OutputStream out = null;
        try {
            int read;
            File epubFile = File.createTempFile("epub", "." + ResourceUtil.getExtension(uri));
            epubFile.deleteOnExit();
            out = new FileOutputStream(epubFile);
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            this.epubFile = epubFile;
            this.profile = profile == null ? EPUBProfile.DEFAULT : profile;
            this.report = report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null && this.report != null && this.report instanceof LocalizableReport) {
            ((LocalizableReport)this.report).setLocale(locale);
        }
    }

    @Override
    public boolean validate() {
        int validateResult = this.doValidate();
        return validateResult == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doValidate() {
        ZipFile zip = null;
        try {
            if (!this.epubFile.exists()) {
                this.report.message(MessageId.PKG_018, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
                int n = 2;
                return n;
            }
            zip = new ZipFile(this.epubFile);
            OCFZipPackage ocf = new OCFZipPackage(zip);
            OCFChecker checker = new OCFChecker(new ValidationContext.ValidationContextBuilder().path(this.epubFile.getAbsolutePath()).ocf(ocf).report(this.report).profile(this.profile).build());
            checker.runChecks();
            String extension = ResourceUtil.getExtension(this.epubFile.getName());
            this.checkExtension(ocf, extension);
            CheckManager c = new CheckManager(zip, this.report);
            c.checkPackage();
        }
        catch (IOException e) {
            OCFChecker.checkZipHeader(this.epubFile, this.report);
            this.report.message(MessageId.PKG_008, EPUBLocation.create(this.epubFile.getName(), ""), e.getMessage());
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {}
        }
        int returnValue = 0;
        if (this.report.getFatalErrorCount() != 0) {
            returnValue |= 4;
        }
        if (this.report.getErrorCount() != 0) {
            returnValue |= 2;
        }
        if (this.report.getWarningCount() != 0) {
            returnValue |= 1;
        }
        return returnValue;
    }

    void checkExtension(OCFPackage ocf, String extension) {
        if (extension != null && !extension.equals("epub")) {
            if (extension.matches("[Ee][Pp][Uu][Bb]")) {
                this.report.message(MessageId.PKG_016, EPUBLocation.create(this.epubFile.getName()), new Object[0]);
            } else {
                List<String> opfPaths = ocf.getOcfData().getEntries("application/oebps-package+xml");
                if (!opfPaths.isEmpty()) {
                    if (ocf.getOpfData().get(opfPaths.get(0)).getVersion() == EPUBVersion.VERSION_3) {
                        this.report.message(MessageId.PKG_024, EPUBLocation.create(this.epubFile.getName(), extension), new Object[0]);
                    } else {
                        this.report.message(MessageId.PKG_017, EPUBLocation.create(this.epubFile.getName(), extension), new Object[0]);
                    }
                }
            }
        }
    }
}

