/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.ExtensionHandler;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MagnetState;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PeerConnectionIn;
import org.klomp.snark.PeerConnectionOut;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.PeerState;
import org.klomp.snark.Request;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class Peer
implements Comparable<Peer> {
    protected final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
    private final PeerID peerID;
    private final byte[] my_id;
    private final byte[] infohash;
    protected MetaInfo metainfo;
    private Map<String, BEValue> handshakeMap;
    private DataInputStream din;
    private DataOutputStream dout;
    private final AtomicLong downloaded = new AtomicLong();
    private final AtomicLong uploaded = new AtomicLong();
    volatile PeerState state;
    MagnetState magnetState;
    private I2PSocket sock;
    private boolean deregister = true;
    private static final AtomicLong __id = new AtomicLong();
    private final long _id;
    private final AtomicBoolean _disconnected = new AtomicBoolean();
    static final long CHECK_PERIOD = 40000L;
    static final int RATE_DEPTH = 3;
    private final long[] uploaded_old = new long[]{-1L, -1L, -1L};
    private final long[] downloaded_old = new long[]{-1L, -1L, -1L};
    private static final byte[] HANDSHAKE = DataHelper.getASCII("BitTorrent protocol");
    private static final long OPTION_EXTENSION = 0x100000L;
    private static final long OPTION_FAST = 4L;
    private static final long OPTION_V2 = 16L;
    private long options;
    private final boolean _isIncoming;
    private int _totalCommentsSent;
    private int _maxPipeline = 5;

    public Peer(PeerID peerID, byte[] my_id, byte[] infohash, MetaInfo metainfo) {
        this.peerID = peerID;
        this.my_id = my_id;
        this.infohash = infohash;
        this.metainfo = metainfo;
        this._id = __id.incrementAndGet();
        this._isIncoming = false;
    }

    public Peer(I2PSocket sock, InputStream in, OutputStream out, byte[] my_id, byte[] infohash, MetaInfo metainfo) throws IOException {
        this.my_id = my_id;
        this.infohash = infohash;
        this.metainfo = metainfo;
        this.sock = sock;
        byte[] id = this.handshake(in, out);
        this.peerID = new PeerID(id, sock.getPeerDestination());
        this._id = __id.incrementAndGet();
        if (this._log.shouldLog(10)) {
            this._log.debug("Creating a new peer " + this.peerID.toString(), new Exception("creating " + this._id));
        }
        this._isIncoming = true;
    }

    public boolean isIncoming() {
        return this._isIncoming;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public String toString() {
        if (this.peerID != null) {
            return this.peerID.toString() + ' ' + this._id;
        }
        return "[unknown id] " + this._id;
    }

    public String getSocket() {
        String r;
        if (this.state != null && (r = this.state.getRequests()) != null) {
            return this.sock.toString() + "<br><b>Requests:</b> <span class=\"debugRequests\">" + r + "</span>";
        }
        return this.sock.toString();
    }

    public int hashCode() {
        return this.peerID.hashCode() ^ 7777 * (int)this._id;
    }

    public boolean equals(Object o) {
        if (o instanceof Peer) {
            Peer p = (Peer)o;
            return this._id == p._id && this.peerID.equals(p.peerID);
        }
        return false;
    }

    @Override
    @Deprecated
    public int compareTo(Peer p) {
        int rv = this.peerID.compareTo(p.peerID);
        if (rv == 0) {
            if (this._id > p._id) {
                return 1;
            }
            if (this._id < p._id) {
                return -1;
            }
            return 0;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runConnection(I2PSnarkUtil util, PeerListener listener, BitField bitfield, MagnetState mState, boolean uploadOnly) {
        if (this.state != null) {
            throw new IllegalStateException("Peer already started");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Running connection to " + this.peerID.toString(), new Exception("connecting"));
        }
        try {
            Object out;
            Object in;
            if (this.din == null) {
                this.sock = util.connect(this.peerID);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Connected to " + this.peerID + ": " + this.sock);
                }
                if (this.sock == null || this.sock.isClosed()) {
                    throw new IOException("Unable to reach " + this.peerID);
                }
                in = this.sock.getInputStream();
                out = this.sock.getOutputStream();
                byte[] id = this.handshake((InputStream)in, (OutputStream)out);
                byte[] expected_id = this.peerID.getID();
                if (expected_id == null) {
                    this.peerID.setID(id);
                } else {
                    if (!Arrays.equals(expected_id, id)) throw new IOException("Unexpected peerID '" + PeerID.idencode(id) + "' expected '" + PeerID.idencode(expected_id) + "'");
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Handshake got matching IDs with " + this.toString());
                    }
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Already have din [" + this.sock + "] with " + this.toString());
            }
            if (this.metainfo == null && (this.options & 0x100000L) == 0L) {
                if (!this._log.shouldLog(20)) throw new IOException("Peer does not support extensions and we need metainfo, dropping");
                this._log.info("Peer does not support extensions and we need metainfo, dropping");
                throw new IOException("Peer does not support extensions and we need metainfo, dropping");
            }
            in = new PeerConnectionIn(this, this.din);
            out = new PeerConnectionOut(this, this.dout);
            PeerState s = new PeerState(this, listener, this.metainfo, (PeerConnectionIn)in, (PeerConnectionOut)out);
            if ((this.options & 0x100000L) != 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Peer supports extensions, sending reply message");
                }
                int metasize = this.metainfo != null ? this.metainfo.getInfoBytesLength() : -1;
                boolean pexAndMetadata = this.metainfo == null || !this.metainfo.isPrivate();
                boolean dht = util.getDHT() != null;
                boolean comment = util.utCommentsEnabled();
                ((PeerConnectionOut)out).sendExtension(0, ExtensionHandler.getHandshake(metasize, pexAndMetadata, dht, uploadOnly, comment));
            }
            if (bitfield != null) {
                s.out.sendBitfield(bitfield);
            }
            this.state = s;
            this.magnetState = mState;
            listener.connected(this);
            if (this._log.shouldLog(10)) {
                this._log.debug("Start running the reader with " + this.toString());
            }
            ((PeerConnectionOut)out).startup();
            Thread.currentThread().setName("Snark reader from " + this.peerID);
            s.in.run();
            return;
        }
        catch (IOException eofe) {
            if (!this._log.shouldLog(10)) return;
            this._log.debug(this.toString(), eofe);
            return;
        }
        catch (Throwable t) {
            this._log.error(this + ": " + t.getMessage(), t);
            if (!(t instanceof OutOfMemoryError)) return;
            throw (OutOfMemoryError)t;
        }
        finally {
            if (this.deregister) {
                listener.disconnected(this);
            }
            this.disconnect();
        }
    }

    private byte[] handshake(InputStream in, OutputStream out) throws IOException {
        this.dout = new DataOutputStream(out);
        this.dout.write(HANDSHAKE.length);
        this.dout.write(HANDSHAKE);
        long myOptions = 0x100000L;
        if (this.metainfo != null) {
            myOptions |= 4L;
        }
        this.dout.writeLong(myOptions);
        this.dout.write(this.infohash);
        this.dout.write(this.my_id);
        this.dout.flush();
        if (this._log.shouldLog(10)) {
            this._log.debug("Wrote my shared hash and ID to " + this.toString());
        }
        this.din = new DataInputStream(in);
        byte b = this.din.readByte();
        if (b != HANDSHAKE.length) {
            throw new IOException("Handshake failure, expected 19, got " + (b & 0xFF) + " on " + this.sock);
        }
        byte[] bs = new byte[HANDSHAKE.length];
        this.din.readFully(bs);
        if (!Arrays.equals(HANDSHAKE, bs)) {
            throw new IOException("Handshake failure, expected 'BitTorrent protocol'");
        }
        this.options = this.din.readLong();
        bs = new byte[20];
        this.din.readFully(bs);
        if (!Arrays.equals(this.infohash, bs)) {
            throw new IOException("Unexpected MetaInfo hash");
        }
        this.din.readFully(bs);
        if (this._log.shouldLog(10)) {
            this._log.debug("Read the remote side's hash and peerID fully from " + this.toString());
        }
        if (DataHelper.eq(this.my_id, bs)) {
            throw new IOException("Connected to myself");
        }
        if (this.options != 0L && this._log.shouldLog(10)) {
            this._log.debug("Peer supports options 0x" + Long.toHexString(this.options) + ": " + this.toString());
        }
        return bs;
    }

    public boolean supportsFast() {
        return (this.options & 4L) != 0L;
    }

    public Destination getDestination() {
        if (this.sock == null) {
            return null;
        }
        return this.sock.getPeerDestination();
    }

    public MagnetState getMagnetState() {
        return this.magnetState;
    }

    public Map<String, BEValue> getHandshakeMap() {
        return this.handshakeMap;
    }

    public void setHandshakeMap(Map<String, BEValue> map) {
        this.handshakeMap = map;
        BEValue bev = map.get("reqq");
        if (bev != null) {
            try {
                int reqq = bev.getInt();
                this._maxPipeline = Math.min(8, Math.max(5, reqq));
            }
            catch (InvalidBEncodingException invalidBEncodingException) {}
        } else {
            this._maxPipeline = 8;
        }
    }

    public int getMaxPipeline() {
        return this._maxPipeline;
    }

    public void sendExtension(int type, byte[] payload) {
        PeerState s = this.state;
        if (s != null) {
            s.out.sendExtension(type, payload);
        }
    }

    public void setMetaInfo(MetaInfo meta) {
        this.metainfo = meta;
        PeerState s = this.state;
        if (s != null) {
            s.setMetaInfo(meta);
        }
    }

    public boolean isConnected() {
        return this.state != null;
    }

    public void disconnect(boolean deregister) {
        this.deregister = deregister;
        this.disconnect();
    }

    void disconnect() {
        PeerConnectionOut out;
        if (!this._disconnected.compareAndSet(false, true)) {
            return;
        }
        PeerState s = this.state;
        if (s != null) {
            PeerListener pl;
            List<Request> pcs;
            PeerListener p;
            if (this.deregister && (p = s.listener) != null && !(pcs = s.returnPartialPieces()).isEmpty()) {
                p.savePartialPieces(this, pcs);
            }
            this.state = null;
            PeerConnectionIn in = s.in;
            if (in != null) {
                in.disconnect();
            }
            if ((pl = s.listener) != null) {
                pl.disconnected(this);
            }
        }
        I2PSocket csock = this.sock;
        this.sock = null;
        if (csock != null && !csock.isClosed()) {
            try {
                csock.close();
            }
            catch (IOException ioe) {
                this._log.warn("Error disconnecting " + this.toString(), ioe);
            }
        }
        if (s != null && (out = s.out) != null) {
            out.disconnect();
        }
    }

    public void have(int piece) {
        PeerState s = this.state;
        if (s != null) {
            s.havePiece(piece);
        }
    }

    void cancel(int piece) {
        PeerState s = this.state;
        if (s != null) {
            s.cancelPiece(piece);
        }
    }

    @Deprecated
    boolean isRequesting(int p) {
        PeerState s = this.state;
        return s != null && s.isRequesting(p);
    }

    void request() {
        PeerState s = this.state;
        if (s != null) {
            s.addRequest();
        }
    }

    public boolean isInterested() {
        PeerState s = this.state;
        return s != null && s.interested;
    }

    @Deprecated
    public void setInteresting(boolean interest) {
        PeerState s = this.state;
        if (s != null) {
            s.setInteresting(interest);
        }
    }

    public boolean isInteresting() {
        PeerState s = this.state;
        return s != null && s.interesting;
    }

    public void setChoking(boolean choke) {
        PeerState s = this.state;
        if (s != null) {
            s.setChoking(choke);
        }
    }

    public boolean isChoking() {
        PeerState s = this.state;
        return s == null || s.choking;
    }

    public boolean isChoked() {
        PeerState s = this.state;
        return s == null || s.choked;
    }

    public void downloaded(int size) {
        this.downloaded.addAndGet(size);
    }

    public void uploaded(int size) {
        this.uploaded.addAndGet(size);
    }

    public long getDownloaded() {
        return this.downloaded.get();
    }

    public long getUploaded() {
        return this.uploaded.get();
    }

    public void resetCounters() {
        this.downloaded.set(0L);
        this.uploaded.set(0L);
    }

    public long getInactiveTime() {
        PeerState s = this.state;
        if (s != null) {
            PeerConnectionIn in = s.in;
            PeerConnectionOut out = s.out;
            if (in != null && out != null) {
                long now = System.currentTimeMillis();
                return Math.max(now - out.lastSent, now - in.lastRcvd);
            }
            return -1L;
        }
        return -1L;
    }

    public long getMaxInactiveTime() {
        return this.isCompleted() && !this.isInteresting() ? 120000L : 480000L;
    }

    public void keepAlive() {
        PeerState s = this.state;
        if (s != null) {
            s.keepAlive();
        }
    }

    public void retransmitRequests() {
        PeerState s = this.state;
        if (s != null) {
            s.retransmitRequests();
        }
    }

    public int completed() {
        PeerState s = this.state;
        if (s == null || s.bitfield == null) {
            return 0;
        }
        return s.bitfield.count();
    }

    public boolean isCompleted() {
        PeerState s = this.state;
        if (s == null || s.bitfield == null) {
            return false;
        }
        return s.bitfield.complete();
    }

    public void setRateHistory(long up, long down) {
        PeerCoordinator.setRate(up, this.uploaded_old);
        PeerCoordinator.setRate(down, this.downloaded_old);
    }

    public long getUploadRate() {
        return PeerCoordinator.getRate(this.uploaded_old);
    }

    public long getDownloadRate() {
        return PeerCoordinator.getRate(this.downloaded_old);
    }

    int getTotalCommentsSent() {
        return this._totalCommentsSent;
    }

    void setTotalCommentsSent(int count) {
        this._totalCommentsSent = count;
    }

    public boolean isWebPeer() {
        return false;
    }
}

