/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.CRC32;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.eddsa.EdDSABlinding;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.data.Base32;
import net.i2p.data.BlindData;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

public final class Blinding {
    private static final SigType TYPE = SigType.EdDSA_SHA512_Ed25519;
    private static final SigType TYPER = SigType.RedDSA_SHA512_Ed25519;
    private static final String INFO = "i2pblinding1";
    private static final byte[] INFO_ALPHA = DataHelper.getASCII("I2PGenerateAlpha");
    private static final byte FLAG_TWOBYTE = 1;
    private static final byte FLAG_SECRET = 2;
    private static final byte FLAG_AUTH = 4;
    private static final String FORMAT = "yyyyMMdd";
    private static final int LENGTH = "yyyyMMdd".length();
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("yyyyMMdd", Locale.US);

    private Blinding() {
    }

    public static SigningPublicKey blind(SigningPublicKey key, SigningPrivateKey alpha) {
        SigType type = key.getType();
        if (type != TYPE && type != TYPER || alpha.getType() != TYPER) {
            throw new IllegalArgumentException("Unsupported blinding from " + (Object)((Object)type) + " to " + (Object)((Object)alpha.getType()));
        }
        try {
            EdDSAPublicKey jk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey ajk = SigUtil.toJavaEdDSAKey(alpha);
            EdDSAPublicKey bjk = EdDSABlinding.blind(jk, ajk);
            return SigUtil.fromJavaKey(bjk, TYPER);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey blind(SigningPrivateKey key, SigningPrivateKey alpha) {
        SigType type = key.getType();
        if (type != TYPE && type != TYPER || alpha.getType() != TYPER) {
            throw new IllegalArgumentException("Unsupported blinding from " + (Object)((Object)type) + " to " + (Object)((Object)alpha.getType()));
        }
        try {
            EdDSAPrivateKey jk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey ajk = SigUtil.toJavaEdDSAKey(alpha);
            EdDSAPrivateKey bjk = EdDSABlinding.blind(jk, ajk);
            return SigUtil.fromJavaKey(bjk, TYPER);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey unblind(SigningPrivateKey key, SigningPrivateKey alpha) {
        if (key.getType() != TYPER || alpha.getType() != TYPER) {
            throw new IllegalArgumentException("Unsupported blinding from " + (Object)((Object)key.getType()) + " / " + (Object)((Object)alpha.getType()));
        }
        try {
            EdDSAPrivateKey bjk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey ajk = SigUtil.toJavaEdDSAKey(alpha);
            EdDSAPrivateKey jk = EdDSABlinding.unblind(bjk, ajk);
            return SigUtil.fromJavaKey(jk, TYPE);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey generateAlpha(I2PAppContext ctx, SigningPublicKey destspk, String secret) {
        long now = ctx.clock().now();
        return Blinding.generateAlpha(ctx, destspk, secret, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SigningPrivateKey generateAlpha(I2PAppContext ctx, SigningPublicKey destspk, String secret, long now) {
        byte[] data;
        String modVal;
        SigType type = destspk.getType();
        if (type != TYPE && type != TYPER) {
            throw new IllegalArgumentException("Unsupported blinding from " + (Object)((Object)type));
        }
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            modVal = _fmt.format(now);
        }
        if (modVal.length() != LENGTH) {
            throw new IllegalStateException();
        }
        byte[] mod = DataHelper.getASCII(modVal);
        if (secret != null && secret.length() > 0) {
            byte[] sb = DataHelper.getUTF8(secret);
            data = new byte[LENGTH + sb.length];
            System.arraycopy(mod, 0, data, 0, LENGTH);
            System.arraycopy(sb, 0, data, LENGTH, sb.length);
        } else {
            data = mod;
        }
        HKDF hkdf = new HKDF(ctx);
        byte[] out = new byte[64];
        int stoff = INFO_ALPHA.length + destspk.length();
        byte[] in = new byte[stoff + 4];
        System.arraycopy(INFO_ALPHA, 0, in, 0, INFO_ALPHA.length);
        System.arraycopy(destspk.getData(), 0, in, INFO_ALPHA.length, destspk.length());
        DataHelper.toLong(in, stoff, 2, type.getCode());
        DataHelper.toLong(in, stoff + 2, 2, TYPER.getCode());
        Hash salt = ctx.sha().calculateHash(in);
        hkdf.calculate(salt.getData(), data, INFO, out, out, 32);
        byte[] b = EdDSABlinding.reduce(out);
        return new SigningPrivateKey(TYPER, b);
    }

    public static SigType getDefaultBlindedType(SigType unblindedType) {
        if (unblindedType == TYPE) {
            return TYPER;
        }
        return unblindedType;
    }

    public static BlindData decode(I2PAppContext ctx, String address) throws IllegalArgumentException {
        if (!(address = address.toLowerCase(Locale.US)).endsWith(".b32.i2p")) {
            throw new IllegalArgumentException("Not a .b32.i2p address");
        }
        byte[] b = Base32.decode(address.substring(0, address.length() - 8));
        if (b == null) {
            throw new IllegalArgumentException("Corrupt b32 address");
        }
        if (b.length < 35) {
            throw new IllegalArgumentException("Not a new-format address");
        }
        return Blinding.decode(ctx, b);
    }

    public static BlindData decode(I2PAppContext ctx, byte[] b) throws IllegalArgumentException {
        CRC32 crc = new CRC32();
        crc.update(b, 3, b.length - 3);
        long check = crc.getValue();
        b[0] = (byte)(b[0] ^ (byte)check);
        b[1] = (byte)(b[1] ^ (byte)(check >> 8));
        b[2] = (byte)(b[2] ^ (byte)(check >> 16));
        int flag = b[0] & 0xFF;
        if ((flag & 0xF8) != 0) {
            throw new IllegalArgumentException("Corrupt b32 address (or unsupported options)");
        }
        if ((flag & 1) != 0) {
            throw new IllegalArgumentException("Two byte signature types unsupported");
        }
        int st1 = b[1] & 0xFF;
        int st2 = b[2] & 0xFF;
        SigType sigt1 = SigType.getByCode(st1);
        SigType sigt2 = SigType.getByCode(st2);
        if (sigt1 == null) {
            throw new IllegalArgumentException("Unsupported signature type " + st1);
        }
        if (!sigt1.isAvailable()) {
            throw new IllegalArgumentException("Unavailable signature type " + (Object)((Object)sigt1));
        }
        if (sigt2 == null) {
            throw new IllegalArgumentException("Unsupported blinded signature type " + st2);
        }
        if (!sigt2.isAvailable()) {
            throw new IllegalArgumentException("Unavailable blinded signature type " + (Object)((Object)sigt2));
        }
        int spkLen = sigt1.getPubkeyLen();
        if (3 + spkLen > b.length) {
            throw new IllegalArgumentException("b32 too short");
        }
        byte[] spkData = new byte[spkLen];
        System.arraycopy(b, 3, spkData, 0, spkLen);
        SigningPublicKey spk = new SigningPublicKey(sigt1, spkData);
        if (3 + spkLen != b.length) {
            throw new IllegalArgumentException("b32 too long");
        }
        BlindData rv = new BlindData(ctx, spk, sigt2, null);
        if ((flag & 2) != 0) {
            rv.setSecretRequired();
        }
        if ((flag & 4) != 0) {
            rv.setAuthRequired();
        }
        return rv;
    }

    public static String encode(SigningPublicKey key) throws IllegalArgumentException {
        return Blinding.encode(key, false, false);
    }

    public static String encode(SigningPublicKey key, boolean requireSecret, boolean requireAuth) throws IllegalArgumentException {
        SigType type = key.getType();
        if (type != TYPE && type != TYPER) {
            throw new IllegalArgumentException("Unsupported blinding from " + (Object)((Object)type));
        }
        byte[] d = key.getData();
        byte[] b = new byte[d.length + 3];
        System.arraycopy(d, 0, b, 3, d.length);
        CRC32 crc = new CRC32();
        crc.update(b, 3, b.length - 3);
        long check = crc.getValue();
        if (requireSecret) {
            b[0] = 2;
        }
        if (requireAuth) {
            b[0] = (byte)(b[0] | 4);
        }
        b[1] = (byte)(type.getCode() & 0xFF);
        b[2] = (byte)(TYPER.getCode() & 0xFF);
        b[0] = (byte)(b[0] ^ (byte)check);
        b[1] = (byte)(b[1] ^ (byte)(check >> 8));
        b[2] = (byte)(b[2] ^ (byte)(check >> 16));
        return Base32.encode(b) + ".b32.i2p";
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: blinding {56 chars}.b32.i2p");
            System.exit(1);
        }
        System.out.println("Blinded B32: " + args[0]);
        System.out.println(Blinding.decode(I2PAppContext.getGlobalContext(), args[0]).toString());
    }

    static {
        _fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

