/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.crypto.SHA1;
import net.i2p.crypto.SU3File;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.Addresses;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.RandomSource;

public final class SelfSignedGenerator {
    private static final boolean DEBUG = false;
    private static final String OID_QT_CPSURI = "1.3.6.1.5.5.7.2.1";
    private static final String OID_QT_UNOTICE = "1.3.6.1.5.5.7.2.2";
    private static final String OID_CN = "2.5.4.3";
    private static final String OID_C = "2.5.4.6";
    private static final String OID_L = "2.5.4.7";
    private static final String OID_ST = "2.5.4.8";
    private static final String OID_O = "2.5.4.10";
    private static final String OID_OU = "2.5.4.11";
    private static final String OID_SKI = "2.5.29.14";
    private static final String OID_USAGE = "2.5.29.15";
    private static final String OID_SAN = "2.5.29.17";
    private static final String OID_BASIC = "2.5.29.19";
    private static final String OID_CRLNUM = "2.5.29.20";
    private static final String OID_POLICY = "2.5.29.32";
    private static final String OID_POLICY_ANY = "2.5.29.32.0";
    private static final String OID_AKI = "2.5.29.35";
    private static final String OID_EKU = "2.5.29.37";
    private static final String OID_ID_KP_SERVERAUTH = "1.3.6.1.5.5.7.3.1";
    private static final Map<String, String> OIDS = new HashMap<String, String>(16);

    public static Object[] generate(String cname, String ou, String o, String l, String st, String c, int validDays, SigType type) throws GeneralSecurityException {
        return SelfSignedGenerator.generate(cname, null, ou, o, l, st, c, validDays, type);
    }

    public static Object[] generate(String cname, Set<String> altNames, String ou, String o, String l, String st, String c, int validDays, SigType type) throws GeneralSecurityException {
        SimpleDataStructure[] keys = KeyGenerator.getInstance().generateSigningKeys(type);
        SigningPublicKey pub = (SigningPublicKey)keys[0];
        SigningPrivateKey priv = (SigningPrivateKey)keys[1];
        PublicKey jpub = SigUtil.toJavaKey(pub);
        PrivateKey jpriv = SigUtil.toJavaKey(priv);
        try {
            return SelfSignedGenerator.generate(jpub, jpriv, priv, type, cname, altNames, ou, o, l, st, c, validDays);
        }
        catch (ProviderException pe) {
            throw new GeneralSecurityException(pe);
        }
    }

    public static X509Certificate generate(SigningPrivateKey priv, String cname, int validDays) throws GeneralSecurityException {
        SigningPublicKey pub = priv.toPublic();
        PublicKey jpub = SigUtil.toJavaKey(pub);
        PrivateKey jpriv = SigUtil.toJavaKey(priv);
        SigType type = priv.getType();
        Object[] o = SelfSignedGenerator.generate(jpub, jpriv, priv, type, cname, null, null, null, null, null, null, validDays);
        return (X509Certificate)o[2];
    }

    private static Object[] generate(PublicKey jpub, PrivateKey jpriv, SigningPrivateKey priv, SigType type, String cname, Set<String> altNames, String ou, String o, String l, String st, String c, int validDays) throws GeneralSecurityException {
        X509Certificate cert;
        String oid;
        switch (type) {
            case DSA_SHA1: 
            case ECDSA_SHA256_P256: 
            case ECDSA_SHA384_P384: 
            case ECDSA_SHA512_P521: 
            case RSA_SHA256_2048: 
            case RSA_SHA384_3072: 
            case RSA_SHA512_4096: 
            case EdDSA_SHA512_Ed25519: 
            case EdDSA_SHA512_Ed25519ph: {
                oid = type.getOID();
                break;
            }
            default: {
                throw new GeneralSecurityException("Unsupported: " + (Object)((Object)type));
            }
        }
        byte[] sigoid = SelfSignedGenerator.getEncodedOIDSeq(oid);
        byte[] tbs = SelfSignedGenerator.genTBS(cname, altNames, ou, o, l, st, c, validDays, sigoid, jpub);
        int tbslen = tbs.length;
        Signature sig = DSAEngine.getInstance().sign(tbs, priv);
        if (sig == null) {
            throw new GeneralSecurityException("sig failed");
        }
        byte[] sigbytes = SigUtil.toJavaSig(sig);
        int seqlen = tbslen + sigoid.length + SelfSignedGenerator.spaceFor(sigbytes.length + 1);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] cb = new byte[totlen];
        int idx = 0;
        cb[idx++] = 48;
        idx = SigUtil.intToASN1(cb, idx, seqlen);
        System.arraycopy(tbs, 0, cb, idx, tbs.length);
        System.arraycopy(sigoid, 0, cb, idx += tbs.length, sigoid.length);
        idx += sigoid.length;
        cb[idx++] = 3;
        idx = SigUtil.intToASN1(cb, idx, sigbytes.length + 1);
        cb[idx++] = 0;
        System.arraycopy(sigbytes, 0, cb, idx, sigbytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(cb);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(bais);
            cert.checkValidity();
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        X509CRL crl = SelfSignedGenerator.generateCRL(cert, validDays, 1, sigoid, priv);
        PublicKey cpub = cert.getPublicKey();
        cert.verify(cpub);
        if (!cpub.equals(jpub)) {
            boolean ok = false;
            if (jpub instanceof EdDSAPublicKey && cpub.getClass().getName().equals("sun.security.x509.X509Key")) {
                try {
                    cpub = new EdDSAPublicKey(new X509EncodedKeySpec(cpub.getEncoded()));
                    ok = cpub.equals(jpub);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    // empty catch block
                }
            }
            if (!ok) {
                throw new GeneralSecurityException("pubkey mismatch, in: " + jpub.getClass() + " cert: " + cpub.getClass());
            }
        }
        Object[] rv = new Object[]{jpub, jpriv, cert, crl};
        return rv;
    }

    public static Object[] renew(X509Certificate cert, PrivateKey jpriv, int validDays) throws GeneralSecurityException {
        String cname = CertUtil.getSubjectValue(cert, "CN");
        if (cname == null) {
            cname = "localhost";
        }
        String ou = CertUtil.getSubjectValue(cert, "OU");
        String o = CertUtil.getSubjectValue(cert, "O");
        String l = CertUtil.getSubjectValue(cert, "L");
        String st = CertUtil.getSubjectValue(cert, "ST");
        String c = CertUtil.getSubjectValue(cert, "C");
        Set<String> altNames = CertUtil.getSubjectAlternativeNames(cert);
        SigningPrivateKey priv = SigUtil.fromJavaKey(jpriv);
        SigType type = priv.getType();
        SigningPublicKey pub = KeyGenerator.getSigningPublicKey(priv);
        PublicKey jpub = SigUtil.toJavaKey(pub);
        if (type == null) {
            throw new GeneralSecurityException("Unsupported: " + jpriv);
        }
        return SelfSignedGenerator.generate(jpub, jpriv, priv, type, cname, altNames, ou, o, l, st, c, validDays);
    }

    private static X509CRL generateCRL(X509Certificate cert, int validDays, int crlNum, byte[] sigoid, SigningPrivateKey priv) throws GeneralSecurityException {
        X509CRL rv;
        byte[] tbs = SelfSignedGenerator.genTBSCRL(cert, validDays, crlNum, sigoid);
        int tbslen = tbs.length;
        Signature sig = DSAEngine.getInstance().sign(tbs, priv);
        if (sig == null) {
            throw new GeneralSecurityException("sig failed");
        }
        byte[] sigbytes = SigUtil.toJavaSig(sig);
        int seqlen = tbslen + sigoid.length + SelfSignedGenerator.spaceFor(sigbytes.length + 1);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] cb = new byte[totlen];
        int idx = 0;
        cb[idx++] = 48;
        idx = SigUtil.intToASN1(cb, idx, seqlen);
        System.arraycopy(tbs, 0, cb, idx, tbs.length);
        System.arraycopy(sigoid, 0, cb, idx += tbs.length, sigoid.length);
        idx += sigoid.length;
        cb[idx++] = 3;
        idx = SigUtil.intToASN1(cb, idx, sigbytes.length + 1);
        cb[idx++] = 0;
        System.arraycopy(sigbytes, 0, cb, idx, sigbytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(cb);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            rv = (X509CRL)cf.generateCRL(bais);
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        return rv;
    }

    private static byte[] genTBS(String cname, Set<String> altNames, String ou, String o, String l, String st, String c, int validDays, byte[] sigoid, PublicKey jpub) throws GeneralSecurityException {
        byte[] version = new byte[]{-96, 3, 2, 1, 2};
        byte[] serial = new byte[11];
        serial[0] = 2;
        serial[1] = 9;
        RandomSource.getInstance().nextBytes(serial, 2, 9);
        serial[2] = (byte)(serial[2] & 0x7F);
        StringBuilder buf = new StringBuilder(128);
        buf.append("CN=").append(cname);
        if (ou != null) {
            buf.append(",OU=").append(ou);
        }
        if (o != null) {
            buf.append(",O=").append(o);
        }
        if (l != null) {
            buf.append(",L=").append(l);
        }
        if (st != null) {
            buf.append(",ST=").append(st);
        }
        if (c != null) {
            buf.append(",C=").append(c);
        }
        String dname = buf.toString();
        byte[] issuer = new X500Principal(dname, OIDS).getEncoded();
        byte[] validity = SelfSignedGenerator.getValidity(validDays);
        byte[] subject = issuer;
        byte[] pubbytes = jpub.getEncoded();
        byte[] extbytes = SelfSignedGenerator.getExtensions(pubbytes, cname, altNames);
        int len = version.length + serial.length + sigoid.length + issuer.length + validity.length + subject.length + pubbytes.length + extbytes.length;
        int totlen = SelfSignedGenerator.spaceFor(len);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, len);
        System.arraycopy(version, 0, rv, idx, version.length);
        System.arraycopy(serial, 0, rv, idx += version.length, serial.length);
        System.arraycopy(sigoid, 0, rv, idx += serial.length, sigoid.length);
        System.arraycopy(issuer, 0, rv, idx += sigoid.length, issuer.length);
        System.arraycopy(validity, 0, rv, idx += issuer.length, validity.length);
        System.arraycopy(subject, 0, rv, idx += validity.length, subject.length);
        System.arraycopy(pubbytes, 0, rv, idx += subject.length, pubbytes.length);
        System.arraycopy(extbytes, 0, rv, idx += pubbytes.length, extbytes.length);
        return rv;
    }

    private static byte[] genTBSCRL(X509Certificate cert, int validDays, int crlNum, byte[] sigalg) throws GeneralSecurityException {
        byte[] version = new byte[]{2, 1, 1};
        byte[] issuer = cert.getIssuerX500Principal().getEncoded();
        byte[] serial = cert.getSerialNumber().toByteArray();
        if (serial.length > 255) {
            throw new IllegalArgumentException();
        }
        long now = System.currentTimeMillis() - 86400000L;
        long then = now + (long)(validDays + 1) * 24L * 60L * 60L * 1000L;
        byte[] nowbytes = SelfSignedGenerator.getDate(now);
        byte[] thenbytes = SelfSignedGenerator.getDate(then);
        byte[] extbytes = SelfSignedGenerator.getCRLExtensions(crlNum);
        int revlen = 2 + serial.length + nowbytes.length;
        int revseqlen = SelfSignedGenerator.spaceFor(revlen);
        int revsseqlen = SelfSignedGenerator.spaceFor(revseqlen);
        int len = version.length + sigalg.length + issuer.length + nowbytes.length + thenbytes.length + revsseqlen + extbytes.length;
        int totlen = SelfSignedGenerator.spaceFor(len);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, len);
        System.arraycopy(version, 0, rv, idx, version.length);
        System.arraycopy(sigalg, 0, rv, idx += version.length, sigalg.length);
        System.arraycopy(issuer, 0, rv, idx += sigalg.length, issuer.length);
        System.arraycopy(nowbytes, 0, rv, idx += issuer.length, nowbytes.length);
        System.arraycopy(thenbytes, 0, rv, idx += nowbytes.length, thenbytes.length);
        idx += thenbytes.length;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, revseqlen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, revlen);
        rv[idx++] = 2;
        rv[idx++] = (byte)serial.length;
        System.arraycopy(serial, 0, rv, idx, serial.length);
        System.arraycopy(nowbytes, 0, rv, idx += serial.length, nowbytes.length);
        System.arraycopy(extbytes, 0, rv, idx += nowbytes.length, extbytes.length);
        return rv;
    }

    private static int spaceFor(int val) {
        int rv = val > 255 ? 3 : (val > 127 ? 2 : 1);
        return 1 + rv + val;
    }

    private static byte[] getValidity(int validDays) {
        byte[] rv = new byte[32];
        rv[0] = 48;
        rv[1] = 30;
        long now = System.currentTimeMillis() - 86400000L;
        long then = now + (long)(validDays + 1) * 24L * 60L * 60L * 1000L;
        byte[] nowbytes = SelfSignedGenerator.getDate(now);
        byte[] thenbytes = SelfSignedGenerator.getDate(then);
        System.arraycopy(nowbytes, 0, rv, 2, 15);
        System.arraycopy(thenbytes, 0, rv, 17, 15);
        return rv;
    }

    private static byte[] getDate(long now) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyMMddHHmmss");
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        byte[] nowbytes = DataHelper.getASCII(fmt.format(new Date(now)));
        if (nowbytes.length != 12) {
            throw new IllegalArgumentException();
        }
        byte[] rv = new byte[15];
        rv[0] = 23;
        rv[1] = 13;
        System.arraycopy(nowbytes, 0, rv, 2, 12);
        rv[14] = 90;
        return rv;
    }

    private static byte[] getExtensions(byte[] pubbytes, String cname, Set<String> altNames) {
        boolean isCA;
        byte skip;
        int pidx = 1;
        if (((skip = pubbytes[pidx++]) & 0x80) != 0) {
            pidx += skip & 0x80;
        }
        MessageDigest md = SHA1.getInstance();
        md.update(pubbytes, ++pidx, pubbytes.length - pidx);
        byte[] sha = md.digest();
        byte[] oid1 = SelfSignedGenerator.getEncodedOID(OID_SKI);
        byte[] oid2 = SelfSignedGenerator.getEncodedOID(OID_USAGE);
        byte[] oid3 = SelfSignedGenerator.getEncodedOID(OID_BASIC);
        byte[] oid4 = SelfSignedGenerator.getEncodedOID(OID_SAN);
        byte[] oid5 = SelfSignedGenerator.getEncodedOID(OID_AKI);
        byte[] oid6 = SelfSignedGenerator.getEncodedOID(OID_POLICY);
        byte[] oid7 = SelfSignedGenerator.getEncodedOID(OID_POLICY_ANY);
        byte[] oid8 = SelfSignedGenerator.getEncodedOID(OID_QT_UNOTICE);
        byte[] oid9 = SelfSignedGenerator.getEncodedOID(OID_QT_CPSURI);
        byte[] oid10 = SelfSignedGenerator.getEncodedOID(OID_EKU);
        byte[] oid11 = SelfSignedGenerator.getEncodedOID(OID_ID_KP_SERVERAUTH);
        byte[] TRUE = new byte[]{1, 1, -1};
        int wrap1len = SelfSignedGenerator.spaceFor(sha.length);
        int ext1len = oid1.length + SelfSignedGenerator.spaceFor(wrap1len);
        int wrap2len = 4;
        int ext2len = oid2.length + TRUE.length + SelfSignedGenerator.spaceFor(wrap2len);
        int wrap3len = SelfSignedGenerator.spaceFor(TRUE.length);
        int ext3len = oid3.length + TRUE.length + SelfSignedGenerator.spaceFor(wrap3len);
        int wrap41len = 0;
        if (altNames == null) {
            altNames = new TreeSet<String>();
        } else {
            altNames = new TreeSet<String>(altNames);
            altNames.remove("0:0:0:0:0:0:0:1");
        }
        altNames.add(cname);
        boolean bl = isCA = !cname.contains("@") && !cname.endsWith(".family.i2p.net");
        if (isCA) {
            altNames.add("localhost");
            altNames.add("127.0.0.1");
            altNames.add("::1");
        }
        for (String n : altNames) {
            int len = Addresses.isIPv4Address(n) ? 4 : (Addresses.isIPv6Address(n) ? 16 : n.length());
            wrap41len += SelfSignedGenerator.spaceFor(len);
        }
        int wrap4len = SelfSignedGenerator.spaceFor(wrap41len);
        int ext4len = oid4.length + SelfSignedGenerator.spaceFor(wrap4len);
        int wrap51len = wrap1len;
        int wrap5len = SelfSignedGenerator.spaceFor(wrap51len);
        int ext5len = oid5.length + SelfSignedGenerator.spaceFor(wrap5len);
        byte[] policyTextBytes = DataHelper.getASCII("This self-signed certificate is required for secure local access to I2P services.");
        byte[] policyURIBytes = DataHelper.getASCII("https://geti2p.net/");
        int wrap61len = SelfSignedGenerator.spaceFor(policyTextBytes.length);
        int wrap62len = oid8.length + SelfSignedGenerator.spaceFor(wrap61len);
        int wrap63len = SelfSignedGenerator.spaceFor(policyURIBytes.length);
        int wrap64len = oid9.length + wrap63len;
        int wrap65len = SelfSignedGenerator.spaceFor(wrap62len) + SelfSignedGenerator.spaceFor(wrap64len);
        int wrap66len = SelfSignedGenerator.spaceFor(oid7.length + wrap65len);
        int wrap67len = SelfSignedGenerator.spaceFor(wrap66len);
        int wrap68len = SelfSignedGenerator.spaceFor(wrap67len);
        int ext6len = oid6.length + SelfSignedGenerator.spaceFor(wrap68len);
        int wrap7len = SelfSignedGenerator.spaceFor(oid11.length);
        int ext7len = oid10.length + SelfSignedGenerator.spaceFor(wrap7len);
        int extslen = SelfSignedGenerator.spaceFor(ext1len) + SelfSignedGenerator.spaceFor(ext2len) + SelfSignedGenerator.spaceFor(ext4len) + SelfSignedGenerator.spaceFor(ext5len);
        if (isCA) {
            extslen += SelfSignedGenerator.spaceFor(ext3len) + SelfSignedGenerator.spaceFor(ext6len) + SelfSignedGenerator.spaceFor(ext7len);
        }
        int seqlen = SelfSignedGenerator.spaceFor(extslen);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = -93;
        idx = SigUtil.intToASN1(rv, idx, seqlen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extslen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, ext1len);
        System.arraycopy(oid1, 0, rv, idx, oid1.length);
        idx += oid1.length;
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, wrap1len);
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, sha.length);
        System.arraycopy(sha, 0, rv, idx, sha.length);
        idx += sha.length;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, ext5len);
        System.arraycopy(oid5, 0, rv, idx, oid5.length);
        idx += oid5.length;
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, wrap5len);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, wrap51len);
        rv[idx++] = -128;
        idx = SigUtil.intToASN1(rv, idx, sha.length);
        System.arraycopy(sha, 0, rv, idx, sha.length);
        idx += sha.length;
        if (isCA) {
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, ext3len);
            System.arraycopy(oid3, 0, rv, idx, oid3.length);
            System.arraycopy(TRUE, 0, rv, idx += oid3.length, TRUE.length);
            idx += TRUE.length;
            rv[idx++] = 4;
            idx = SigUtil.intToASN1(rv, idx, wrap3len);
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, TRUE.length);
            System.arraycopy(TRUE, 0, rv, idx, TRUE.length);
            idx += TRUE.length;
        }
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, ext2len);
        System.arraycopy(oid2, 0, rv, idx, oid2.length);
        System.arraycopy(TRUE, 0, rv, idx += oid2.length, TRUE.length);
        idx += TRUE.length;
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, wrap2len);
        rv[idx++] = 3;
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = -90;
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, ext4len);
        System.arraycopy(oid4, 0, rv, idx, oid4.length);
        idx += oid4.length;
        rv[idx++] = 4;
        idx = SigUtil.intToASN1(rv, idx, wrap4len);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, wrap41len);
        for (String n : altNames) {
            byte[] b;
            if (Addresses.isIPv4Address(n) || Addresses.isIPv6Address(n)) {
                b = Addresses.getIP(n);
                if (b == null) {
                    throw new IllegalArgumentException("fail " + n);
                }
                rv[idx++] = -121;
            } else {
                b = DataHelper.getASCII(n);
                rv[idx++] = (byte)(isCA ? 130 : 129);
            }
            idx = SigUtil.intToASN1(rv, idx, b.length);
            System.arraycopy(b, 0, rv, idx, b.length);
            idx += b.length;
        }
        if (isCA) {
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, ext6len);
            System.arraycopy(oid6, 0, rv, idx, oid6.length);
            idx += oid6.length;
            rv[idx++] = 4;
            idx = SigUtil.intToASN1(rv, idx, wrap68len);
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, wrap67len);
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, wrap66len);
            System.arraycopy(oid7, 0, rv, idx, oid7.length);
            idx += oid7.length;
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, wrap65len);
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, wrap64len);
            System.arraycopy(oid9, 0, rv, idx, oid9.length);
            idx += oid9.length;
            rv[idx++] = 22;
            idx = SigUtil.intToASN1(rv, idx, policyURIBytes.length);
            System.arraycopy(policyURIBytes, 0, rv, idx, policyURIBytes.length);
            idx += policyURIBytes.length;
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, wrap62len);
            System.arraycopy(oid8, 0, rv, idx, oid8.length);
            idx += oid8.length;
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, wrap61len);
            rv[idx++] = 22;
            idx = SigUtil.intToASN1(rv, idx, policyTextBytes.length);
            System.arraycopy(policyTextBytes, 0, rv, idx, policyTextBytes.length);
            idx += policyTextBytes.length;
        }
        if (isCA) {
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, ext7len);
            System.arraycopy(oid10, 0, rv, idx, oid10.length);
            idx += oid10.length;
            rv[idx++] = 4;
            idx = SigUtil.intToASN1(rv, idx, wrap7len);
            rv[idx++] = 48;
            idx = SigUtil.intToASN1(rv, idx, oid11.length);
            System.arraycopy(oid11, 0, rv, idx, oid11.length);
            idx += oid11.length;
        }
        return rv;
    }

    private static byte[] getCRLExtensions(int crlNum) {
        if (crlNum < 0 || crlNum > 255) {
            throw new IllegalArgumentException();
        }
        byte[] oid = SelfSignedGenerator.getEncodedOID(OID_CRLNUM);
        int extlen = oid.length + 5;
        int extslen = SelfSignedGenerator.spaceFor(extlen);
        int seqlen = SelfSignedGenerator.spaceFor(extslen);
        int totlen = SelfSignedGenerator.spaceFor(seqlen);
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = -96;
        idx = SigUtil.intToASN1(rv, idx, seqlen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extslen);
        rv[idx++] = 48;
        idx = SigUtil.intToASN1(rv, idx, extlen);
        System.arraycopy(oid, 0, rv, idx, oid.length);
        idx += oid.length;
        rv[idx++] = 4;
        rv[idx++] = 3;
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = (byte)crlNum;
        return rv;
    }

    private static byte[] getEncodedOIDSeq(String oid) {
        byte[] b = SelfSignedGenerator.getEncodedOID(oid);
        ByteArrayStream baos = new ByteArrayStream(4 + b.length);
        baos.write(48);
        baos.write(0);
        baos.write(b, 0, b.length);
        baos.write(5);
        baos.write(0);
        byte[] rv = baos.toByteArray();
        rv[1] = (byte)(rv.length - 2);
        return rv;
    }

    private static byte[] getEncodedOID(String oid) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16);
        baos.write(6);
        baos.write(0);
        String[] f = DataHelper.split(oid, "[.]");
        if (f.length < 2) {
            throw new IllegalArgumentException("length: " + f.length);
        }
        baos.write(40 * Integer.parseInt(f[0]) + Integer.parseInt(f[1]));
        for (int i = 2; i < f.length; ++i) {
            int v = Integer.parseInt(f[i]);
            if (v >= 0x200000 || v < 0) {
                throw new IllegalArgumentException();
            }
            if (v >= 16384) {
                baos.write(v >> 14 | 0x80);
            }
            if (v >= 128) {
                baos.write(v >> 7 | 0x80);
            }
            baos.write(v & 0x7F);
        }
        byte[] rv = baos.toByteArray();
        if (rv.length > 129) {
            throw new IllegalArgumentException();
        }
        rv[1] = (byte)(rv.length - 2);
        return rv;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            SelfSignedGenerator.usage();
        } else if (args[0].equals("keygen")) {
            if (args.length >= 4) {
                SU3File.main(args);
            } else {
                SelfSignedGenerator.usage();
            }
        } else if (args[0].equals("renew")) {
            if (args.length >= 3) {
                String ks;
                String cert;
                String ksPW;
                if (args[1].equals("-p")) {
                    ksPW = args[2];
                    cert = args[3];
                    ks = args[4];
                } else {
                    ksPW = "changeit";
                    cert = args[1];
                    ks = args[2];
                }
                String keypw = "";
                try {
                    while (keypw.length() < 6) {
                        System.out.print("Enter password for key: ");
                        keypw = DataHelper.readLine(System.in);
                        if (keypw == null) {
                            System.out.println("\nEOF reading password");
                            System.exit(1);
                        }
                        if ((keypw = keypw.trim()).length() <= 0 || keypw.length() >= 6) continue;
                        System.out.println("Key password must be at least 6 characters");
                    }
                }
                catch (IOException ioe) {
                    System.out.println("Error asking for password");
                    throw ioe;
                }
                File ksf = new File(ks);
                X509Certificate newCert = KeyStoreUtil.renewPrivateKeyCertificate(ksf, ksPW, null, keypw, 3652);
                CertUtil.saveCert(newCert, new File(cert));
                System.out.println("Certificate renewed for 10 years, and stored in " + cert + " and " + ks);
            } else {
                SelfSignedGenerator.usage();
            }
        } else {
            SelfSignedGenerator.usage();
        }
    }

    private static void usage() {
        System.err.println("Usage: selfsignedgenerator keygen [-t type|code] [-p keystorepw] [-r crlFile.crl] publicKeyFile.crt keystore.ks localhost\n       selfsignedgenerator renew  [-p keystorepw] publicKeyFile.crt keystore.ks");
    }

    static {
        OIDS.put(OID_CN, "CN");
        OIDS.put(OID_C, "C");
        OIDS.put(OID_L, "L");
        OIDS.put(OID_ST, "ST");
        OIDS.put(OID_O, "O");
        OIDS.put(OID_OU, "OU");
    }
}

