/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.Date;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class SendMessageDirectJob
extends JobImpl {
    private final Log _log = this.getContext().logManager().getLog(SendMessageDirectJob.class);
    private final I2NPMessage _message;
    private final Hash _targetHash;
    private RouterInfo _router;
    private final long _expiration;
    private final int _priority;
    private final Job _onSend;
    private final ReplyJob _onSuccess;
    private final Job _onFail;
    private final MessageSelector _selector;
    private boolean _alreadySearched;
    private boolean _sent;
    private long _searchOn;

    public SendMessageDirectJob(RouterContext ctx, I2NPMessage message, Hash toPeer, int timeoutMs, int priority) {
        this(ctx, message, toPeer, null, null, null, null, timeoutMs, priority);
    }

    public SendMessageDirectJob(RouterContext ctx, I2NPMessage message, Hash toPeer, ReplyJob onSuccess, Job onFail, MessageSelector selector, int timeoutMs, int priority) {
        this(ctx, message, toPeer, null, onSuccess, onFail, selector, timeoutMs, priority);
    }

    public SendMessageDirectJob(RouterContext ctx, I2NPMessage message, Hash toPeer, Job onSend, ReplyJob onSuccess, Job onFail, MessageSelector selector, int timeoutMs, int priority) {
        super(ctx);
        this._message = message;
        this._targetHash = toPeer;
        if (timeoutMs < 10000) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Very little time given [" + timeoutMs + "], resetting to 10s", new Exception("stingy caller!"));
            }
            this._expiration = ctx.clock().now() + 10000L;
        } else {
            this._expiration = (long)timeoutMs + ctx.clock().now();
        }
        this._priority = priority;
        this._onSend = onSend;
        this._onSuccess = onSuccess;
        this._onFail = onFail;
        this._selector = selector;
        if (message == null) {
            throw new IllegalArgumentException("Attempt to send a null message");
        }
        if (this._targetHash == null) {
            throw new IllegalArgumentException("Attempt to send a message to a null peer");
        }
    }

    @Override
    public String getName() {
        return "Send Message Direct";
    }

    @Override
    public void runJob() {
        long now = this.getContext().clock().now();
        if (this._expiration < now) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Timed out sending message " + this._message + " directly (expiration = " + new Date(this._expiration) + ") to " + this._targetHash.toBase64());
            }
            if (this._onFail != null) {
                this.getContext().jobQueue().addJob(this._onFail);
            }
            return;
        }
        if (this._router != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Router specified, sending");
            }
            this.send();
        } else {
            this._router = this.getContext().netDb().lookupRouterInfoLocally(this._targetHash);
            if (this._router != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Router not specified but lookup found it");
                }
                this.send();
            } else if (!this._alreadySearched) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Router not specified, so we're looking for it...");
                }
                this.getContext().netDb().lookupRouterInfo(this._targetHash, this, this, this._expiration - this.getContext().clock().now());
                this._searchOn = this.getContext().clock().now();
                this._alreadySearched = true;
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to find the router to send to: " + this._targetHash + " after searching for " + (this.getContext().clock().now() - this._searchOn) + "ms, message: " + this._message);
                }
                if (this._onFail != null) {
                    this.getContext().jobQueue().addJob(this._onFail);
                }
            }
        }
    }

    private void send() {
        if (this._sent) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not resending!", new Exception("blah"));
            }
            return;
        }
        this._sent = true;
        Hash to = this._router.getIdentity().getHash();
        Hash us = this.getContext().routerHash();
        if (us.equals(to)) {
            if (this._selector != null) {
                OutNetMessage outM = new OutNetMessage(this.getContext(), this._message, this._expiration, this._priority, this._router);
                outM.setOnFailedReplyJob(this._onFail);
                outM.setOnFailedSendJob(this._onFail);
                outM.setOnReplyJob(this._onSuccess);
                outM.setOnSendJob(this._onSend);
                outM.setReplySelector(this._selector);
                this.getContext().messageRegistry().registerPending(outM);
            }
            if (this._onSend != null) {
                this.getContext().jobQueue().addJob(this._onSend);
            }
            this.getContext().inNetMessagePool().add(this._message, this._router.getIdentity(), null);
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding " + this._message.getClass().getName() + " to inbound message pool as it was destined for ourselves");
            }
        } else {
            OutNetMessage msg = new OutNetMessage(this.getContext(), this._message, this._expiration, this._priority, this._router);
            msg.setOnFailedReplyJob(this._onFail);
            msg.setOnFailedSendJob(this._onFail);
            msg.setOnReplyJob(this._onSuccess);
            msg.setOnSendJob(this._onSend);
            msg.setReplySelector(this._selector);
            this.getContext().outNetMessagePool().add(msg);
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding " + this._message.getClass().getName() + " to outbound message pool targeting " + this._router.getIdentity().getHash().toBase64());
            }
        }
    }
}

