/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.control;

import org.cybergarage.soap.SOAPResponse;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.control.ControlResponse;
import org.cybergarage.xml.Node;

public class ActionResponse
extends ControlResponse {
    public ActionResponse() {
        this.setHeader("EXT", "");
    }

    public ActionResponse(SOAPResponse soapRes) {
        super(soapRes);
        this.setHeader("EXT", "");
    }

    public void setResponse(Action action) {
        this.setStatusCode(200);
        Node bodyNode = this.getBodyNode();
        Node resNode = this.createResponseNode(action);
        bodyNode.addNode(resNode);
        Node envNode = this.getEnvelopeNode();
        this.setContent(envNode);
    }

    private Node createResponseNode(Action action) {
        String actionName = action.getName();
        Node actionNameResNode = new Node("u:" + actionName + "Response");
        Service service = action.getService();
        if (service != null) {
            actionNameResNode.setAttribute("xmlns:u", service.getServiceType());
        }
        ArgumentList argList = action.getArgumentList();
        int nArgs = argList.size();
        for (int n = 0; n < nArgs; ++n) {
            Argument arg = argList.getArgument(n);
            if (!arg.isOutDirection()) continue;
            Node argNode = new Node();
            argNode.setName(arg.getName());
            argNode.setValue(arg.getValue());
            actionNameResNode.addNode(argNode);
        }
        return actionNameResNode;
    }

    private Node getActionResponseNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null || !bodyNode.hasNodes()) {
            return null;
        }
        return bodyNode.getNode(0);
    }

    public ArgumentList getResponse() {
        ArgumentList argList = new ArgumentList();
        Node resNode = this.getActionResponseNode();
        if (resNode == null) {
            return argList;
        }
        int nArgs = resNode.getNNodes();
        for (int n = 0; n < nArgs; ++n) {
            Node node = resNode.getNode(n);
            String name = node.getName();
            String value = node.getValue();
            Argument arg = new Argument(name, value);
            argList.add(arg);
        }
        return argList;
    }
}

