/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.timespec.TimeParser;
import org.rrd4j.core.timespec.TimeSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Util {
    public static final long MAX_LONG = Long.MAX_VALUE;
    public static final long MIN_LONG = -9223372036854775807L;
    public static final double MAX_DOUBLE = Double.MAX_VALUE;
    public static final double MIN_DOUBLE = -1.7976931348623157E308;
    static final String PATTERN = "0.0000000000E00";
    static final String RRD4J_DIR = "rrd4j-demo";
    static final ThreadLocal<NumberFormat> df = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            DecimalFormat ldf = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
            ldf.applyPattern(Util.PATTERN);
            ldf.setPositivePrefix("+");
            return ldf;
        }
    };
    private static final Pattern SPRINTF_PATTERN = Pattern.compile("([^%]|^)%([^a-zA-Z%]*)l(f|g|e)");
    static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static long lastLap = System.currentTimeMillis();

    private Util() {
    }

    public static double[] toDoubleArray(long[] array) {
        double[] values = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            values[i] = array[i];
        }
        return values;
    }

    public static long getTime() {
        return (System.currentTimeMillis() + 500L) / 1000L;
    }

    public static long getTimestamp() {
        return Util.getTime();
    }

    public static long normalize(long timestamp, long step) {
        return timestamp - timestamp % step;
    }

    public static double max(double x, double y) {
        return Double.isNaN(x) ? y : (Double.isNaN(y) ? x : Math.max(x, y));
    }

    public static double min(double x, double y) {
        return Double.isNaN(x) ? y : (Double.isNaN(y) ? x : Math.min(x, y));
    }

    public static double sum(double x, double y) {
        return Double.isNaN(x) ? y : (Double.isNaN(y) ? x : x + y);
    }

    static String formatDouble(double x, String nanString, boolean forceExponents) {
        if (Double.isNaN(x)) {
            return nanString;
        }
        if (forceExponents) {
            return df.get().format(x);
        }
        return Double.toString(x);
    }

    static String formatDouble(double x, boolean forceExponents) {
        return Util.formatDouble(x, Double.toString(Double.NaN), forceExponents);
    }

    public static String formatDouble(double x) {
        return Util.formatDouble(x, true);
    }

    public static Date getDate(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static Calendar getCalendar(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp * 1000L);
        return calendar;
    }

    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static long getTimestamp(Date date) {
        return (date.getTime() + 499L) / 1000L;
    }

    public static long getTimestamp(Calendar gc) {
        return Util.getTimestamp(gc.getTime());
    }

    public static long getTimestamp(int year, int month, int day, int hour, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month, day, hour, min);
        return Util.getTimestamp(calendar);
    }

    public static long getTimestamp(int year, int month, int day) {
        return Util.getTimestamp(year, month, day, 0, 0);
    }

    public static long getTimestamp(String atStyleTimeSpec) {
        TimeSpec timeSpec = new TimeParser(atStyleTimeSpec).parse();
        return timeSpec.getTimestamp();
    }

    public static long[] getTimestamps(String atStyleTimeSpec1, String atStyleTimeSpec2) {
        TimeSpec timeSpec1 = new TimeParser(atStyleTimeSpec1).parse();
        TimeSpec timeSpec2 = new TimeParser(atStyleTimeSpec2).parse();
        return TimeSpec.getTimestamps(timeSpec1, timeSpec2);
    }

    public static double parseDouble(String valueStr) {
        double value;
        try {
            value = Double.parseDouble(valueStr);
        }
        catch (NumberFormatException nfe) {
            value = Double.NaN;
        }
        return value;
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean parseBoolean(String valueStr) {
        return valueStr != null && (valueStr.equalsIgnoreCase("true") || valueStr.equalsIgnoreCase("on") || valueStr.equalsIgnoreCase("yes") || valueStr.equalsIgnoreCase("y") || valueStr.equalsIgnoreCase("1"));
    }

    public static Paint parseColor(String valueStr) {
        String c;
        String string = c = valueStr.startsWith("#") ? valueStr.substring(1) : valueStr;
        if (c.length() != 6 && c.length() != 8) {
            throw new IllegalArgumentException("Invalid color specification: " + valueStr);
        }
        String r = c.substring(0, 2);
        String g = c.substring(2, 4);
        String b = c.substring(4, 6);
        if (c.length() == 6) {
            return new Color(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16));
        }
        String a = c.substring(6);
        return new Color(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16), Integer.parseInt(a, 16));
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getUserHomeDirectory() {
        return System.getProperty("user.home") + Util.getFileSeparator();
    }

    public static String getRrd4jDemoDirectory() {
        Path root = System.getProperty("rrd4j.demopath") != null ? Paths.get(System.getProperty("rrd4j.demopath"), new String[0]) : Paths.get(Util.getUserHomeDirectory(), RRD4J_DIR);
        try {
            root = Files.createDirectories(root.toAbsolutePath().normalize(), new FileAttribute[0]);
            return root.toString() + File.separator;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getRrd4jDemoPath(String filename) {
        String demoDir = Util.getRrd4jDemoDirectory();
        if (demoDir != null) {
            return demoDir + filename;
        }
        return null;
    }

    static boolean sameFilePath(String pathname1, String pathname2) throws IOException {
        Path path1 = Paths.get(pathname1, new String[0]);
        Path path2 = Paths.get(pathname2, new String[0]);
        if (Files.exists(path1, new LinkOption[0]) != Files.exists(path2, new LinkOption[0])) {
            return false;
        }
        if (Files.exists(path1, new LinkOption[0]) && Files.exists(path2, new LinkOption[0])) {
            path1 = Paths.get(pathname1, new String[0]).toRealPath(new LinkOption[0]).normalize();
            path2 = Paths.get(pathname2, new String[0]).toRealPath(new LinkOption[0]).normalize();
            return Files.isSameFile(path1, path2);
        }
        return false;
    }

    static int getMatchingDatasourceIndex(RrdDb rrd1, int dsIndex, RrdDb rrd2) throws IOException {
        String dsName = rrd1.getDatasource(dsIndex).getName();
        try {
            return rrd2.getDsIndex(dsName);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    static int getMatchingArchiveIndex(RrdDb rrd1, int arcIndex, RrdDb rrd2) throws IOException {
        Archive archive = rrd1.getArchive(arcIndex);
        ConsolFun consolFun = archive.getConsolFun();
        int steps = archive.getSteps();
        try {
            return rrd2.getArcIndex(consolFun, steps);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    static String getTmpFilename() throws IOException {
        return File.createTempFile("rrd4j_", ".tmp").getCanonicalPath();
    }

    public static Calendar getCalendar(String timeStr) {
        try {
            long timestamp = Long.parseLong(timeStr);
            return Util.getCalendar(timestamp);
        }
        catch (NumberFormatException timestamp) {
            SimpleDateFormat df = new SimpleDateFormat(ISO_DATE_FORMAT);
            df.setLenient(false);
            try {
                Date date = df.parse(timeStr);
                return Util.getCalendar(date);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Time/date not in yyyy-MM-dd HH:mm:ss format: " + timeStr);
            }
        }
    }

    public static String getLapTime() {
        long newLap = System.currentTimeMillis();
        double seconds = (double)(newLap - lastLap) / 1000.0;
        lastLap = newLap;
        return "[" + seconds + " sec]";
    }

    public static String getRrd4jHomeDirectory() {
        String homedir = null;
        try {
            String className = Util.class.getName().replace('.', '/');
            URI uri = Util.class.getResource("/" + className + ".class").toURI();
            if ("file".equals(uri.getScheme())) {
                homedir = Paths.get(uri).toString();
            } else if ("jar".equals(uri.getScheme())) {
                JarURLConnection connection = (JarURLConnection)uri.toURL().openConnection();
                homedir = connection.getJarFileURL().getFile();
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        if (homedir != null) {
            return Paths.get(homedir, new String[0]).toAbsolutePath().toString();
        }
        return null;
    }

    public static boolean equal(double x, double y) {
        return Double.isNaN(x) && Double.isNaN(y) || x == y;
    }

    public static String getCanonicalPath(String path) throws IOException {
        return Paths.get(path, new String[0]).toRealPath(new LinkOption[0]).toString();
    }

    @Deprecated
    public static long getLastModified(String file) {
        try {
            return Files.getLastModifiedTime(Paths.get(file, new String[0]), new LinkOption[0]).to(TimeUnit.SECONDS);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static long getLastModifiedTime(String file) throws IOException {
        return Files.getLastModifiedTime(Paths.get(file, new String[0]), new LinkOption[0]).to(TimeUnit.SECONDS);
    }

    public static boolean fileExists(String filename) {
        return Files.exists(Paths.get(filename, new String[0]), new LinkOption[0]);
    }

    public static double max(double[] values) {
        double max = Double.NaN;
        for (double value : values) {
            max = Util.max(max, value);
        }
        return max;
    }

    public static double min(double[] values) {
        double min = Double.NaN;
        for (double value : values) {
            min = Util.min(min, value);
        }
        return min;
    }

    public static String sprintf(Locale l, String format, Object ... args) {
        String fmt = SPRINTF_PATTERN.matcher(format).replaceAll("$1%$2$3");
        return String.format(l, fmt, args);
    }

    public static class Xml {
        private static final ErrorHandler eh = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }
        };

        private Xml() {
        }

        public static Node[] getChildNodes(Node parentNode) {
            return Xml.getChildNodes(parentNode, null);
        }

        public static Node[] getChildNodes(Node parentNode, String childName) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            NodeList nodeList = parentNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || childName != null && !node.getNodeName().equals(childName)) continue;
                nodes.add(node);
            }
            return nodes.toArray(new Node[0]);
        }

        public static Node getFirstChildNode(Node parentNode, String childName) {
            Node[] childs = Xml.getChildNodes(parentNode, childName);
            if (childs.length > 0) {
                return childs[0];
            }
            throw new IllegalArgumentException("XML Error, no such child: " + childName);
        }

        public static boolean hasChildNode(Node parentNode, String childName) {
            Node[] childs = Xml.getChildNodes(parentNode, childName);
            return childs.length > 0;
        }

        public static String getChildValue(Node parentNode, String childName) {
            return Xml.getChildValue(parentNode, childName, true);
        }

        public static String getChildValue(Node parentNode, String childName, boolean trim) {
            NodeList children = parentNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals(childName)) continue;
                return Xml.getValue(child, trim);
            }
            throw new IllegalStateException("XML Error, no such child: " + childName);
        }

        public static String getValue(Node node) {
            return Xml.getValue(node, true);
        }

        public static String getValue(Node node, boolean trimValue) {
            String value = null;
            Node child = node.getFirstChild();
            if (child != null && (value = child.getNodeValue()) != null && trimValue) {
                value = value.trim();
            }
            return value;
        }

        public static int getChildValueAsInt(Node parentNode, String childName) {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Integer.parseInt(valueStr);
        }

        public static int getValueAsInt(Node node) {
            String valueStr = Xml.getValue(node);
            return Integer.parseInt(valueStr);
        }

        public static long getChildValueAsLong(Node parentNode, String childName) {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Long.parseLong(valueStr);
        }

        public static long getValueAsLong(Node node) {
            String valueStr = Xml.getValue(node);
            return Long.parseLong(valueStr);
        }

        public static double getChildValueAsDouble(Node parentNode, String childName) {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Util.parseDouble(valueStr);
        }

        public static double getValueAsDouble(Node node) {
            String valueStr = Xml.getValue(node);
            return Util.parseDouble(valueStr);
        }

        public static boolean getChildValueAsBoolean(Node parentNode, String childName) {
            String valueStr = Xml.getChildValue(parentNode, childName);
            return Util.parseBoolean(valueStr);
        }

        public static boolean getValueAsBoolean(Node node) {
            String valueStr = Xml.getValue(node);
            return Util.parseBoolean(valueStr);
        }

        public static Element getRootElement(InputSource inputSource) throws IOException {
            try {
                DocumentBuilder builder = SingletonHelper.factory.newDocumentBuilder();
                builder.setErrorHandler(eh);
                Document doc = builder.parse(inputSource);
                return doc.getDocumentElement();
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public static Element getRootElement(String xmlString) throws IOException {
            return Xml.getRootElement(new InputSource(new StringReader(xmlString)));
        }

        public static Element getRootElement(File xmlFile) throws IOException {
            try (FileReader reader = new FileReader(xmlFile);){
                Element element = Xml.getRootElement(new InputSource(reader));
                return element;
            }
        }

        private static class SingletonHelper {
            private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

            private SingletonHelper() {
            }

            static {
                try {
                    factory.setIgnoringComments(true);
                    factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    factory.setValidating(false);
                    factory.setNamespaceAware(false);
                }
                catch (ParserConfigurationException e) {
                    throw new UnsupportedOperationException("Missing DOM feature: " + e.getMessage(), e);
                }
            }
        }
    }
}

