/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.ReleaseReferencesStrategy;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.RAck;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Reason;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Require;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.AddressParser;
import gov.nist.javax.sip.parser.CallIDParser;
import gov.nist.javax.sip.parser.ContactParser;
import gov.nist.javax.sip.parser.RecordRouteParser;
import gov.nist.javax.sip.stack.AckSendingStrategy;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialogErrorEvent;
import gov.nist.javax.sip.stack.SIPDialogEventListener;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionState;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.OptionTag;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.RequireHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPDialog
implements Dialog,
DialogExt {
    private static StackLogger logger = CommonLogger.getLogger(SIPDialog.class);
    private static final long serialVersionUID = -1429794423085204069L;
    private transient boolean dialogTerminatedEventDelivered;
    private transient String stackTrace;
    protected String method;
    protected transient boolean isAssigned;
    protected boolean reInviteFlag;
    private transient Object applicationData;
    private transient SIPRequest originalRequest;
    protected transient String originalRequestRecordRouteHeadersString;
    protected transient RecordRouteList originalRequestRecordRouteHeaders;
    protected String lastResponseDialogId;
    private Via lastResponseTopMostVia;
    protected Integer lastResponseStatusCode;
    protected long lastResponseCSeqNumber;
    protected long lastInviteResponseCSeqNumber;
    protected int lastInviteResponseCode;
    protected String lastResponseMethod;
    protected String lastResponseFromTag;
    protected String lastResponseToTag;
    protected SIPTransaction firstTransaction;
    protected SIPTransaction lastTransaction;
    protected String dialogId;
    protected transient String earlyDialogId;
    protected long localSequenceNumber = 0L;
    protected long remoteSequenceNumber = -1L;
    protected String myTag;
    protected String hisTag;
    protected RouteList routeList;
    private transient SIPTransactionStack sipStack;
    private int dialogState = -1;
    protected transient SIPRequest lastAckSent;
    protected Long lastAckReceivedCSeqNumber;
    protected transient boolean ackProcessed;
    protected transient DialogTimerTask timerTask;
    protected transient long nextSeqno;
    private transient int retransmissionTicksLeft;
    private transient int prevRetransmissionTicks;
    protected long originalLocalSequenceNumber;
    private transient int ackLine;
    public transient long auditTag = 0L;
    protected Address localParty;
    protected String localPartyStringified;
    protected Address remoteParty;
    protected String remotePartyStringified;
    protected CallIdHeader callIdHeader;
    protected String callIdHeaderString;
    public static final int NULL_STATE = -1;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int TERMINATED_STATE = 3;
    protected boolean serverTransactionFlag;
    private transient SipProviderImpl sipProvider;
    protected boolean terminateOnBye = true;
    protected transient boolean byeSent;
    protected Address remoteTarget;
    protected String remoteTargetStringified;
    protected EventHeader eventHeader;
    protected transient long lastInviteOkReceived;
    private transient Semaphore ackSem = new Semaphore(1);
    protected transient int reInviteWaitTime = 100;
    private transient DialogDeleteTask dialogDeleteTask;
    private transient DialogDeleteIfNoAckSentTask dialogDeleteIfNoAckSentTask;
    protected transient boolean isAcknowledged;
    private transient long highestSequenceNumberAcknowledged = -1L;
    protected boolean isBackToBackUserAgent;
    protected boolean sequenceNumberValidation = true;
    private transient Set<SIPDialogEventListener> eventListeners;
    private transient Semaphore timerTaskLock = new Semaphore(1);
    protected boolean firstTransactionSecure;
    protected boolean firstTransactionSeen;
    protected String firstTransactionMethod;
    protected String firstTransactionId;
    protected boolean firstTransactionIsServerTransaction;
    protected String firstTransactionMergeId;
    protected int firstTransactionPort = 5060;
    protected Contact contactHeader;
    protected String contactHeaderStringified;
    private boolean pendingRouteUpdateOn202Response;
    protected ProxyAuthorizationHeader proxyAuthorizationHeader;
    private ReleaseReferencesStrategy releaseReferencesStrategy;
    private transient EarlyStateTimerTask earlyStateTimerTask;
    private int earlyDialogTimeout = 180;
    private Set<String> responsesReceivedInForkingCase = new HashSet<String>(0);
    private SIPDialog originalDialog;
    private transient AckSendingStrategy ackSendingStrategy = new AckSendingStrategyImpl();

    private SIPDialog(SipProviderImpl provider) {
        this.routeList = new RouteList();
        this.sipProvider = provider;
        this.eventListeners = new CopyOnWriteArraySet<SIPDialogEventListener>();
        this.earlyDialogTimeout = ((SIPTransactionStack)provider.getSipStack()).getEarlyDialogTimeout();
    }

    private void recordStackTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        new Exception().printStackTrace(writer);
        String stackTraceSignature = Integer.toString(Math.abs(new Random().nextInt()));
        logger.logDebug("TraceRecord = " + stackTraceSignature);
        this.stackTrace = "TraceRecord = " + stackTraceSignature + ":" + stringWriter.getBuffer().toString();
    }

    public SIPDialog(SIPTransaction transaction) {
        this(transaction.getSipProvider());
        SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
        this.callIdHeader = sipRequest.getCallId();
        this.earlyDialogId = sipRequest.getDialogId(false);
        if (transaction == null) {
            throw new NullPointerException("Null tx");
        }
        this.sipStack = transaction.getSIPStack();
        this.sipProvider = transaction.getSipProvider();
        if (this.sipProvider == null) {
            throw new NullPointerException("Null Provider!");
        }
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
        this.addTransaction(transaction);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating a dialog : " + this);
            logger.logDebug("provider port = " + this.sipProvider.getListeningPoint().getPort());
            logger.logStackTrace();
        }
        this.addEventListener(this.sipStack);
        this.releaseReferencesStrategy = this.sipStack.getReleaseReferencesStrategy();
    }

    public SIPDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        this(transaction);
        if (sipResponse == null) {
            throw new NullPointerException("Null SipResponse");
        }
        this.setLastResponse(transaction, sipResponse);
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
    }

    public SIPDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        this(sipProvider);
        this.sipStack = (SIPTransactionStack)sipProvider.getSipStack();
        this.setLastResponse(null, sipResponse);
        this.originalLocalSequenceNumber = this.localSequenceNumber = sipResponse.getCSeq().getSeqNumber();
        this.localParty = sipResponse.getFrom().getAddress();
        this.remoteParty = sipResponse.getTo().getAddress();
        this.method = sipResponse.getCSeq().getMethod();
        this.callIdHeader = sipResponse.getCallId();
        this.serverTransactionFlag = false;
        this.setLocalTag(sipResponse.getFrom().getTag());
        this.setRemoteTag(sipResponse.getTo().getTag());
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Creating a dialog : " + this);
            logger.logStackTrace();
        }
        this.isBackToBackUserAgent = this.sipStack.isBackToBackUserAgent;
        this.addEventListener(this.sipStack);
        this.releaseReferencesStrategy = this.sipStack.getReleaseReferencesStrategy();
    }

    public SIPDialog(SIPClientTransaction subscribeTx, SIPTransaction notifyST) {
        this(notifyST);
        this.serverTransactionFlag = false;
        this.lastTransaction = subscribeTx;
        this.storeFirstTransactionInfo(this, subscribeTx);
        this.terminateOnBye = false;
        this.localSequenceNumber = subscribeTx.getCSeq();
        SIPRequest not = (SIPRequest)notifyST.getRequest();
        this.remoteSequenceNumber = not.getCSeq().getSeqNumber();
        this.setDialogId(not.getDialogId(true));
        this.setLocalTag(not.getToTag());
        this.setRemoteTag(not.getFromTag());
        this.setLastResponse(subscribeTx, subscribeTx.getLastResponse());
        this.localParty = not.getTo().getAddress();
        this.remoteParty = not.getFrom().getAddress();
        this.addRoute(not);
        this.setState(1);
    }

    private void printRouteList() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("this : " + this);
            logger.logDebug("printRouteList : " + this.routeList.encode());
        }
    }

    private void raiseIOException(String host, int port2, String protocol) {
        IOExceptionEvent ioError = new IOExceptionEvent((Object)this, host, port2, protocol);
        this.sipProvider.handleEvent((EventObject)ioError, null);
        this.setState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseErrorEvent(int dialogTimeoutError, SIPClientTransaction clientTransaction) {
        SIPDialogErrorEvent newErrorEvent = new SIPDialogErrorEvent(this, dialogTimeoutError);
        newErrorEvent.setClientTransaction(clientTransaction);
        Set<SIPDialogEventListener> set = this.eventListeners;
        synchronized (set) {
            for (SIPDialogEventListener nextListener : this.eventListeners) {
                nextListener.dialogErrorEvent(newErrorEvent);
            }
        }
        this.eventListeners.clear();
        if (dialogTimeoutError != 2 && dialogTimeoutError != 1 && dialogTimeoutError != 4 && dialogTimeoutError != 3) {
            this.delete();
        }
        this.stopTimer();
    }

    private void raiseErrorEvent(int dialogTimeoutError) {
        this.raiseErrorEvent(dialogTimeoutError, null);
    }

    protected void setRemoteParty(SIPMessage sipMessage) {
        this.remoteParty = !this.isServer() ? sipMessage.getTo().getAddress() : sipMessage.getFrom().getAddress();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("settingRemoteParty " + this.remoteParty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoute(RecordRouteList recordRouteList) {
        try {
            AddressImpl address;
            Route route;
            RecordRoute rr;
            ListIterator li;
            if (!this.isServer()) {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator(recordRouteList.size());
                while (li.hasPrevious()) {
                    rr = (RecordRoute)li.previous();
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress(address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            } else {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator();
                while (li.hasNext()) {
                    rr = (RecordRoute)li.next();
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress(address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            }
        }
        finally {
            if (logger.isLoggingEnabled()) {
                Iterator it = this.routeList.iterator();
                while (it.hasNext()) {
                    SipURI sipUri = (SipURI)((Route)it.next()).getAddress().getURI();
                    if (!sipUri.hasLrParam()) {
                        if (!logger.isLoggingEnabled()) continue;
                        logger.logWarning("NON LR route in Route set detected for dialog : " + this);
                        logger.logStackTrace();
                        continue;
                    }
                    if (!logger.isLoggingEnabled(32)) continue;
                    logger.logDebug("route = " + sipUri);
                }
            }
        }
    }

    protected void setRemoteTarget(ContactHeader contact) {
        this.remoteTarget = contact.getAddress();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Dialog.setRemoteTarget: " + this.remoteTarget);
            logger.logStackTrace();
        }
    }

    private synchronized void addRoute(SIPResponse sipResponse) {
        try {
            ContactList contactList;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
            }
            if (sipResponse.getStatusCode() == 100) {
                return;
            }
            if (this.dialogState == 3) {
                return;
            }
            if (this.dialogState == 1) {
                if (sipResponse.getStatusCode() / 100 == 2 && !this.isServer() && (contactList = sipResponse.getContactHeaders()) != null && SIPRequest.isTargetRefresh(sipResponse.getCSeq().getMethod())) {
                    this.setRemoteTarget((ContactHeader)contactList.getFirst());
                }
                if (!this.pendingRouteUpdateOn202Response) {
                    return;
                }
            }
            if (!this.isServer() || this.pendingRouteUpdateOn202Response) {
                if (this.getState() != DialogState.CONFIRMED && this.getState() != DialogState.TERMINATED || this.pendingRouteUpdateOn202Response) {
                    RecordRouteList rrlist = sipResponse.getRecordRouteHeaders();
                    if (rrlist != null) {
                        this.addRoute(rrlist);
                    } else {
                        this.routeList = new RouteList();
                    }
                }
                if ((contactList = sipResponse.getContactHeaders()) != null) {
                    this.setRemoteTarget((ContactHeader)contactList.getFirst());
                }
            }
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logStackTrace();
            }
        }
    }

    private synchronized RouteList getRouteList() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("getRouteList " + this);
        }
        RouteList retval = new RouteList();
        retval = new RouteList();
        if (this.routeList != null) {
            ListIterator li = this.routeList.listIterator();
            while (li.hasNext()) {
                Route route = (Route)li.next();
                retval.add((Route)route.clone());
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("----- ");
            logger.logDebug("getRouteList for " + this);
            if (retval != null) {
                logger.logDebug("RouteList = " + retval.encode());
            }
            if (this.routeList != null) {
                logger.logDebug("myRouteList = " + this.routeList.encode());
            }
            logger.logDebug("----- ");
        }
        return retval;
    }

    void setRouteList(RouteList routeList) {
        this.routeList = routeList;
    }

    private void sendAck(Request request, boolean throwIOExceptionAsSipException) throws SipException {
        SIPRequest ackRequest = (SIPRequest)request;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendAck" + this);
        }
        if (!ackRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (this.getState() == null || this.getState().getValue() == 0) {
            if (logger.isLoggingEnabled(4)) {
                logger.logError("Bad Dialog State for " + this + " dialogID = " + this.getDialogId());
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logError("CallID " + this.getCallId());
                logger.logError("RequestCallID = " + ackRequest.getCallId().getCallId());
                logger.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("setting from tag For outgoing ACK= " + this.getLocalTag());
                logger.logDebug("setting To tag for outgoing ACK = " + this.getRemoteTag());
                logger.logDebug("ack = " + ackRequest);
            }
            if (this.getLocalTag() != null) {
                ackRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                ackRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        boolean releaseAckSem = false;
        long cseqNo = ((SIPRequest)request).getCSeq().getSeqNumber();
        if (!this.isAckSent(cseqNo)) {
            releaseAckSem = true;
        }
        this.setLastAckSent((SIPRequest)ackRequest.clone());
        try {
            this.ackSendingStrategy.send(ackRequest);
            this.isAcknowledged = true;
            this.highestSequenceNumberAcknowledged = Math.max(this.highestSequenceNumberAcknowledged, ackRequest.getCSeq().getSeqNumber());
            if (releaseAckSem && this.isBackToBackUserAgent) {
                this.releaseAckSem();
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Not releasing ack sem for " + this + " isAckSent " + releaseAckSem);
            }
        }
        catch (IOException ex) {
            if (throwIOExceptionAsSipException) {
                throw new SipException("Could not send ack", (Throwable)ex);
            }
            Hop hop = this.ackSendingStrategy.getLastHop();
            if (hop == null) {
                hop = this.sipStack.getNextHop(ackRequest);
            }
            this.raiseIOException(hop.getHost(), hop.getPort(), hop.getTransport());
        }
        catch (SipException ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        if (this.dialogDeleteTask != null) {
            this.getStack().getTimer().cancel(this.dialogDeleteTask);
            this.dialogDeleteTask = null;
        }
    }

    void setStack(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    SIPTransactionStack getStack() {
        return this.sipStack;
    }

    boolean isTerminatedOnBye() {
        return this.terminateOnBye;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ackReceived(long cseqNumber) {
        if (this.isAckSeen()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Ack already seen for response -- dropping");
            }
            return;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        if (tr != null) {
            if (tr.getCSeq() == cseqNumber) {
                this.acquireTimerTaskSem();
                try {
                    if (this.timerTask != null) {
                        this.getStack().getTimer().cancel(this.timerTask);
                        this.timerTask = null;
                    }
                }
                finally {
                    this.releaseTimerTaskSem();
                }
                if (this.dialogDeleteTask != null) {
                    this.getStack().getTimer().cancel(this.dialogDeleteTask);
                    this.dialogDeleteTask = null;
                }
                this.lastAckReceivedCSeqNumber = cseqNumber;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("ackReceived for " + tr.getMethod());
                    this.ackLine = logger.getLineCount();
                    this.printDebugInfo();
                }
                if (this.isBackToBackUserAgent) {
                    this.releaseAckSem();
                }
                this.setState(1);
            }
        } else if (logger.isLoggingEnabled(32)) {
            logger.logDebug("tr is null -- not updating the ack state");
        }
    }

    synchronized boolean testAndSetIsDialogTerminatedEventDelivered() {
        boolean retval = this.dialogTerminatedEventDelivered;
        this.dialogTerminatedEventDelivered = true;
        return retval;
    }

    public void addEventListener(SIPDialogEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPDialogEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public synchronized void requestConsumed() {
        this.nextSeqno = this.getRemoteSeqNumber() + 1L;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Request Consumed -- next consumable Request Seqno = " + this.nextSeqno);
        }
    }

    public synchronized boolean isRequestConsumable(SIPRequest dialogRequest) {
        if (dialogRequest.getMethod().equals("ACK")) {
            throw new RuntimeException("Illegal method");
        }
        if (!this.isSequenceNumberValidation()) {
            return true;
        }
        return this.remoteSequenceNumber < dialogRequest.getCSeq().getSeqNumber();
    }

    public void doDeferredDelete() {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else {
            this.dialogDeleteTask = new DialogDeleteTask();
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                int delay = 500;
                if (this.lastTransaction != null) {
                    delay = this.lastTransaction.getBaseTimerInterval();
                }
                this.sipStack.getTimer().schedule(this.dialogDeleteTask, 64 * delay);
            } else {
                this.delete();
            }
        }
    }

    public void setState(int state) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::setState:Setting dialog state for " + this + "newState = " + state);
            logger.logStackTrace();
            if (state != -1 && state != this.dialogState && logger.isLoggingEnabled()) {
                logger.logDebug("SIPDialog::setState:" + this + "  old dialog state is " + this.getState());
                logger.logDebug("SIPDialog::setState:" + this + "  New dialog state is " + DialogState.getObject((int)state));
            }
        }
        if (state == 0) {
            this.addEventListener(this.getSipProvider());
        }
        this.dialogState = state;
        if (state == 3) {
            this.removeEventListener(this.getSipProvider());
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                if (this.sipStack.getConnectionLingerTimer() > 0) {
                    this.sipStack.getTimer().schedule(new LingerTimer(), this.sipStack.getConnectionLingerTimer() * 1000);
                } else {
                    new LingerTimer().runTask();
                }
            }
            this.stopTimer();
        }
    }

    public void printDebugInfo() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("isServer = " + this.isServer());
            logger.logDebug("localTag = " + this.getLocalTag());
            logger.logDebug("remoteTag = " + this.getRemoteTag());
            logger.logDebug("localSequenceNumer = " + this.getLocalSeqNumber());
            logger.logDebug("remoteSequenceNumer = " + this.getRemoteSeqNumber());
            logger.logDebug("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public boolean isAckSeen() {
        if (this.lastAckReceivedCSeqNumber == null && this.lastResponseStatusCode == 200) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::isAckSeen:" + this + "lastAckReceived is null -- returning false");
            }
            return false;
        }
        if (this.lastResponseMethod == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::isAckSeen:" + this + "lastResponse is null -- returning false");
            }
            return false;
        }
        if (this.lastAckReceivedCSeqNumber == null && this.lastResponseStatusCode / 100 > 2) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::isAckSeen:" + this + "lastResponse statusCode " + this.lastResponseStatusCode);
            }
            return true;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::isAckSeen:lastAckReceivedCSeqNumber = " + this.lastAckReceivedCSeqNumber + " remoteCSeqNumber = " + this.getRemoteSeqNumber());
        }
        return this.lastAckReceivedCSeqNumber != null && this.lastAckReceivedCSeqNumber >= this.getRemoteSeqNumber();
    }

    public SIPRequest getLastAckSent() {
        return this.lastAckSent;
    }

    public boolean isAckSent(long cseqNo) {
        if (this.getLastTransaction() == null) {
            return true;
        }
        if (this.getLastTransaction() instanceof ClientTransaction) {
            if (this.getLastAckSent() == null) {
                return false;
            }
            return cseqNo <= this.getLastAckSent().getCSeq().getSeqNumber();
        }
        return true;
    }

    @Deprecated
    public Transaction getFirstTransaction() {
        throw new UnsupportedOperationException("This method has been deprecated and is no longer supported");
    }

    public Transaction getFirstTransactionInt() {
        if (this.firstTransaction != null) {
            return this.firstTransaction;
        }
        return this.sipStack.findTransaction(this.firstTransactionId, this.firstTransactionIsServerTransaction);
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    public synchronized void addRoute(SIPRequest sipRequest) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
        }
        if (this.dialogState == 1 && SIPRequest.isTargetRefresh(sipRequest.getMethod())) {
            this.doTargetRefresh(sipRequest);
        }
        if (this.dialogState == 1 || this.dialogState == 3) {
            return;
        }
        ContactList contactList = sipRequest.getContactHeaders();
        if (contactList != null) {
            this.setRemoteTarget((ContactHeader)contactList.getFirst());
        }
        if (sipRequest.getToTag() != null) {
            return;
        }
        RecordRouteList rrlist = sipRequest.getRecordRouteHeaders();
        if (rrlist != null) {
            this.addRoute(rrlist);
        } else {
            this.routeList = new RouteList();
        }
    }

    public void setDialogId(String dialogId) {
        if (this.firstTransaction != null) {
            this.firstTransaction.setDialog(this, dialogId);
        }
        this.dialogId = dialogId;
    }

    public boolean isServer() {
        if (!this.firstTransactionSeen) {
            return this.serverTransactionFlag;
        }
        return this.firstTransactionIsServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.dialogId == null && this.lastResponseDialogId != null) {
            this.dialogId = this.lastResponseDialogId;
        }
        return this.dialogId;
    }

    protected void storeFirstTransactionInfo(SIPDialog dialog, SIPTransaction transaction) {
        dialog.firstTransactionSeen = true;
        dialog.firstTransaction = transaction;
        dialog.firstTransactionIsServerTransaction = transaction.isServerTransaction();
        dialog.firstTransactionSecure = dialog.firstTransactionIsServerTransaction ? transaction.getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips") : ((SIPClientTransaction)transaction).getOriginalRequestScheme().equalsIgnoreCase("sips");
        dialog.firstTransactionPort = transaction.getPort();
        dialog.firstTransactionId = transaction.getBranchId();
        dialog.firstTransactionMethod = transaction.getMethod();
        if (transaction instanceof SIPServerTransaction && dialog.firstTransactionMethod.equals("INVITE")) {
            this.sipStack.removeMergeDialog(this.firstTransactionMergeId);
            dialog.firstTransactionMergeId = transaction.getMergeId();
            this.sipStack.putMergeDialog(this);
        }
        if (transaction.isServerTransaction()) {
            SIPServerTransaction st = (SIPServerTransaction)transaction;
            SIPResponse response2 = st.getLastResponse();
            dialog.contactHeader = response2 != null ? response2.getContactHeader() : null;
        } else {
            SIPClientTransaction ct = (SIPClientTransaction)transaction;
            if (ct != null) {
                dialog.contactHeader = ct.getOriginalRequestContact();
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("firstTransaction = " + dialog.firstTransaction);
            logger.logDebug("firstTransactionIsServerTransaction = " + this.firstTransactionIsServerTransaction);
            logger.logDebug("firstTransactionSecure = " + this.firstTransactionSecure);
            logger.logDebug("firstTransactionPort = " + this.firstTransactionPort);
            logger.logDebug("firstTransactionId = " + this.firstTransactionId);
            logger.logDebug("firstTransactionMethod = " + this.firstTransactionMethod);
            logger.logDebug("firstTransactionMergeId = " + this.firstTransactionMergeId);
        }
    }

    public boolean addTransaction(SIPTransaction transaction) {
        SIPRequest sipRequest = transaction.getOriginalRequest();
        if (this.firstTransactionSeen && !this.firstTransactionId.equals(transaction.getBranchId()) && transaction.getMethod().equals(this.firstTransactionMethod)) {
            this.setReInviteFlag(true);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SipDialog.addTransaction() " + this + " transaction = " + transaction);
        }
        if (!this.firstTransactionSeen) {
            this.storeFirstTransactionInfo(this, transaction);
            if (sipRequest.getMethod().equals("SUBSCRIBE")) {
                this.eventHeader = (EventHeader)sipRequest.getHeader("Event");
            }
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            if (this.originalRequest == null && transaction.isInviteTransaction()) {
                this.originalRequest = sipRequest;
            } else if (this.originalRequest != null) {
                this.originalRequestRecordRouteHeaders = sipRequest.getRecordRouteHeaders();
            }
            if (this.method == null) {
                this.method = sipRequest.getMethod();
            }
            if (transaction instanceof SIPServerTransaction) {
                this.hisTag = sipRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeq().getSeqNumber());
                this.originalLocalSequenceNumber = this.getLocalSeqNumber();
                this.setLocalTag(sipRequest.getFrom().getTag());
                if (this.myTag == null && logger.isLoggingEnabled()) {
                    logger.logError("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (transaction.getMethod().equals(this.firstTransactionMethod) && this.firstTransactionIsServerTransaction != transaction.isServerTransaction()) {
            this.storeFirstTransactionInfo(this, transaction);
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            if (transaction.isInviteTransaction()) {
                this.originalRequest = sipRequest;
            } else {
                this.originalRequestRecordRouteHeaders = sipRequest.getRecordRouteHeaders();
            }
            this.method = sipRequest.getMethod();
        } else if (this.firstTransaction == null && transaction.isInviteTransaction()) {
            this.firstTransaction = transaction;
        }
        if (transaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeq().getSeqNumber());
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("isBackToBackUserAgent = " + this.isBackToBackUserAgent);
        }
        if (transaction.isInviteTransaction()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::setLastTransaction:dialog= " + this + " lastTransaction = " + transaction);
            }
            this.lastTransaction = transaction;
        }
        try {
            if (transaction.getRequest().getMethod().equals("REFER") && transaction instanceof SIPServerTransaction) {
                long lastReferCSeq = ((SIPRequest)transaction.getRequest()).getCSeq().getSeqNumber();
                this.eventHeader = new Event();
                this.eventHeader.setEventType("refer");
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::setLastTransaction:lastReferCSeq = " + lastReferCSeq);
                }
                this.eventHeader.setEventId(Long.toString(lastReferCSeq));
            }
        }
        catch (Exception ex) {
            logger.logFatalError("Unexpected exception in REFER processing");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            logger.logDebug("TID = " + transaction.getTransactionId() + "/" + transaction.isServerTransaction());
            logger.logStackTrace();
        }
        return true;
    }

    protected void setRemoteTag(String hisTag) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setRemoteTag(): " + this + " remoteTag = " + this.hisTag + " new tag = " + hisTag);
        }
        if (this.hisTag != null && hisTag != null && !hisTag.equals(this.hisTag)) {
            if (this.getState() != DialogState.EARLY) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dialog is already established -- ignoring remote tag re-assignment");
                }
                return;
            }
            if (this.sipStack.isRemoteTagReassignmentAllowed()) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("UNSAFE OPERATION !  tag re-assignment " + this.hisTag + " trying to set to " + hisTag + " can cause unexpected effects ");
                }
                boolean removed = false;
                if (this.sipStack.getDialog(this.dialogId) == this) {
                    this.sipStack.removeDialog(this.dialogId);
                    removed = true;
                }
                this.dialogId = null;
                this.hisTag = hisTag;
                if (removed) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("ReInserting Dialog");
                    }
                    this.sipStack.putDialog(this);
                }
            }
        } else if (hisTag != null) {
            this.hisTag = hisTag;
        } else if (logger.isLoggingEnabled()) {
            logger.logWarning("setRemoteTag : called with null argument ");
        }
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        DialogTimerTask t = this.timerTask;
        if (t != null) {
            return t.transaction;
        }
        return null;
    }

    private void setLocalSequenceNumber(long lCseq) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setLocalSequenceNumber: original  " + this.localSequenceNumber + " new  = " + lCseq);
        }
        if (lCseq <= this.localSequenceNumber) {
            throw new RuntimeException("Sequence number should not decrease !");
        }
        this.localSequenceNumber = lCseq;
    }

    public void setRemoteSequenceNumber(long rCseq) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setRemoteSeqno " + this + "/" + rCseq);
        }
        this.remoteSequenceNumber = rCseq;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return (int)this.localSequenceNumber;
    }

    public long getOriginalLocalSequenceNumber() {
        return this.originalLocalSequenceNumber;
    }

    public long getLocalSeqNumber() {
        return this.localSequenceNumber;
    }

    public long getRemoteSeqNumber() {
        return this.remoteSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    protected void setLocalTag(String mytag) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("set Local tag " + mytag + " dialog = " + this);
            logger.logStackTrace();
        }
        this.myTag = mytag;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        if (this.callIdHeader == null && this.callIdHeaderString != null) {
            try {
                this.callIdHeader = (CallIdHeader)new CallIDParser(this.callIdHeaderString).parse();
            }
            catch (ParseException e) {
                logger.logError("error reparsing the call id header", e);
            }
        }
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sipRequest) {
        this.callIdHeader = sipRequest.getCallId();
    }

    public Address getLocalParty() {
        if (this.localParty == null && this.localPartyStringified != null) {
            try {
                this.localParty = new AddressParser(this.localPartyStringified).address(true);
            }
            catch (ParseException e) {
                logger.logError("error reparsing the localParty", e);
            }
        }
        return this.localParty;
    }

    protected void setLocalParty(SIPMessage sipMessage) {
        this.localParty = !this.isServer() ? sipMessage.getFrom().getAddress() : sipMessage.getTo().getAddress();
    }

    public Address getRemoteParty() {
        if (this.remoteParty == null && this.remotePartyStringified != null) {
            try {
                this.remoteParty = new AddressParser(this.remotePartyStringified).address(true);
            }
            catch (ParseException e) {
                logger.logError("error reparsing the remoteParty", e);
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("gettingRemoteParty " + this.remoteParty);
        }
        return this.remoteParty;
    }

    public Address getRemoteTarget() {
        if (this.remoteTarget == null && this.remoteTargetStringified != null) {
            try {
                this.remoteTarget = new AddressParser(this.remoteTargetStringified).address(true);
            }
            catch (ParseException e) {
                logger.logError("error reparsing the remoteTarget", e);
            }
        }
        return this.remoteTarget;
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject((int)this.dialogState);
    }

    public boolean isSecure() {
        return this.firstTransactionSecure;
    }

    public void sendAck(Request request) throws SipException {
        this.sendAck(request, true);
    }

    public Request createRequest(String method) throws SipException {
        if (method.equals("ACK") || method.equals("PRACK")) {
            throw new SipException("Invalid method specified for createRequest:" + method);
        }
        if (this.lastResponseTopMostVia != null) {
            return this.createRequest(method, this.lastResponseTopMostVia.getTransport());
        }
        throw new SipException("Dialog not yet established -- no response!");
    }

    private SIPRequest createRequest(String method, String topMostViaTransport) throws SipException {
        if (method == null || topMostViaTransport == null) {
            throw new NullPointerException("null argument");
        }
        if (method.equals("CANCEL")) {
            throw new SipException("Dialog.createRequest(): Invalid request");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !method.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && method.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        SipUri sipUri = null;
        if (this.getRemoteTarget() != null) {
            sipUri = (SipUri)this.getRemoteTarget().getURI().clone();
        } else {
            sipUri = (SipUri)this.getRemoteParty().getURI().clone();
            sipUri.clearUriParms();
        }
        CSeq cseq = new CSeq();
        try {
            cseq.setMethod(method);
            cseq.setSeqNumber(this.getLocalSeqNumber());
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Unexpected error");
            }
            InternalErrorHandler.handleException(ex);
        }
        ListeningPointImpl lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(topMostViaTransport);
        if (lp == null) {
            if (logger.isLoggingEnabled()) {
                logger.logError("Cannot find listening point for transport " + topMostViaTransport);
            }
            throw new SipException("Cannot find listening point for transport " + topMostViaTransport);
        }
        Via via = lp.getViaHeader();
        From from = new From();
        from.setAddress(this.getLocalParty());
        To to = new To();
        to.setAddress(this.getRemoteParty());
        SIPRequest sipRequest = this.createRequest(sipUri, via, cseq, from, to);
        if (SIPRequest.isTargetRefresh(method)) {
            ContactHeader contactHeader = ((ListeningPointImpl)this.sipProvider.getListeningPoint(lp.getTransport())).createContactHeader();
            ((SipURI)contactHeader.getAddress().getURI()).setSecure(this.isSecure());
            sipRequest.setHeader((Header)contactHeader);
        }
        try {
            cseq = (CSeq)sipRequest.getCSeq();
            cseq.setSeqNumber(this.getLocalSeqNumber() + 1L);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::createRequest:setting Request Seq Number to " + cseq.getSeqNumber());
            }
        }
        catch (InvalidArgumentException ex) {
            InternalErrorHandler.handleException((Exception)((Object)ex));
        }
        if (method.equals("SUBSCRIBE") && this.eventHeader != null) {
            sipRequest.addHeader((Header)this.eventHeader);
        }
        if (method.equals("NOTIFY") && this.eventHeader != null) {
            sipRequest.addHeader((Header)this.eventHeader);
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            } else {
                from.removeTag();
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            } else {
                to.removeTag();
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        this.updateRequest(sipRequest);
        return sipRequest;
    }

    public SIPRequest createRequest(SipUri requestURI, Via via, CSeq cseq, From from, To to) {
        SIPRequest newRequest = new SIPRequest();
        String method = cseq.getMethod();
        newRequest.setMethod(method);
        newRequest.setRequestURI(requestURI);
        this.setBranch(via, method);
        newRequest.setHeader(via);
        newRequest.setHeader(cseq);
        newRequest.setHeader(from);
        newRequest.setHeader(to);
        newRequest.setHeader((Header)this.getCallId());
        try {
            newRequest.attachHeader(new MaxForwards(70), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            newRequest.setHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        return newRequest;
    }

    private final void setBranch(Via via, String method) {
        String branch;
        if (method.equals("ACK")) {
            branch = this.getLastResponseStatusCode() >= 300 ? this.lastResponseTopMostVia.getBranch() : Utils.getInstance().generateBranchId();
        } else if (method.equals("CANCEL")) {
            branch = this.lastResponseTopMostVia.getBranch();
        } else {
            return;
        }
        try {
            via.setBranch(branch);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void sendRequest(ClientTransaction clientTransactionId) throws TransactionDoesNotExistException, SipException {
        this.sendRequest(clientTransactionId, !this.isBackToBackUserAgent);
    }

    public void sendRequest(ClientTransaction clientTransaction, boolean allowInterleaving) throws TransactionDoesNotExistException, SipException {
        if (clientTransaction == null) {
            throw new NullPointerException("null parameter");
        }
        if (!allowInterleaving && clientTransaction.getRequest().getMethod().equals("INVITE")) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::sendRequest " + this + " clientTransaction = " + clientTransaction);
            }
            this.sipStack.getReinviteExecutor().execute(new ReInviteSender(clientTransaction));
            return;
        }
        SIPRequest dialogRequest = ((SIPClientTransaction)clientTransaction).getOriginalRequest();
        this.proxyAuthorizationHeader = (ProxyAuthorizationHeader)dialogRequest.getHeader("Proxy-Authorization");
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::sendRequest:dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + dialogRequest);
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (this.byeSent && this.isTerminatedOnBye() && !dialogRequest.getMethod().equals("BYE")) {
            if (logger.isLoggingEnabled()) {
                logger.logError("BYE already sent for " + this);
            }
            throw new SipException("Cannot send request; BYE already sent");
        }
        if (dialogRequest.getTopmostVia() == null) {
            Via via = ((SIPClientTransaction)clientTransaction).getOutgoingViaHeader();
            dialogRequest.addHeader(via);
        }
        if (!this.getCallId().getCallId().equalsIgnoreCase(dialogRequest.getCallId().getCallId())) {
            if (logger.isLoggingEnabled()) {
                logger.logError("CallID " + this.getCallId());
                logger.logError("SIPDialog::sendRequest:RequestCallID = " + dialogRequest.getCallId().getCallId());
                logger.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransaction).setDialog(this, this.dialogId);
        this.addTransaction((SIPTransaction)clientTransaction);
        ((SIPClientTransaction)clientTransaction).setTransactionMapped(true);
        From from = (From)dialogRequest.getFrom();
        To to = (To)dialogRequest.getTo();
        if (this.getLocalTag() != null && from.getTag() != null && !from.getTag().equals(this.getLocalTag())) {
            throw new SipException("From tag mismatch expecting  " + this.getLocalTag());
        }
        if (this.getRemoteTag() != null && to.getTag() != null && !to.getTag().equals(this.getRemoteTag()) && logger.isLoggingEnabled()) {
            logger.logWarning("SIPDialog::sendRequest:To header tag mismatch expecting " + this.getRemoteTag());
        }
        if (this.getLocalTag() == null && dialogRequest.getMethod().equals("NOTIFY")) {
            if (!this.getMethod().equals("SUBSCRIBE")) {
                throw new SipException("Trying to send NOTIFY without SUBSCRIBE Dialog!");
            }
            this.setLocalTag(from.getTag());
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Hop hop = ((SIPClientTransaction)clientTransaction).getNextHop();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::sendRequest:Using hop = " + hop.getHost() + " : " + hop.getPort());
        }
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.firstTransactionPort, hop);
            MessageChannel oldChannel = ((SIPClientTransaction)clientTransaction).getMessageChannel();
            oldChannel.uncache();
            if (!this.sipStack.cacheClientConnections) {
                --oldChannel.useCount;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::sendRequest:oldChannel: useCount " + oldChannel.useCount);
                }
            }
            if (messageChannel == null) {
                Hop outboundProxy;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Null message channel using outbound proxy !");
                }
                if ((outboundProxy = this.sipStack.getRouter(dialogRequest).getOutboundProxy()) == null) {
                    throw new SipException("No route found! hop=" + hop);
                }
                messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(outboundProxy.getTransport()).getIPAddress(), this.firstTransactionPort, outboundProxy);
                if (messageChannel != null) {
                    ((SIPClientTransaction)clientTransaction).setEncapsulatedChannel(messageChannel);
                }
            } else {
                ((SIPClientTransaction)clientTransaction).setEncapsulatedChannel(messageChannel);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::sendRequest:using message channel " + messageChannel);
                }
            }
            if (messageChannel != null) {
                ++messageChannel.useCount;
            }
            if (!this.sipStack.cacheClientConnections && oldChannel != null && oldChannel.useCount <= 0) {
                oldChannel.close();
            }
        }
        catch (Exception ex) {
            if (logger.isLoggingEnabled()) {
                logger.logException(ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        try {
            long cseqNumber;
            long l = cseqNumber = dialogRequest.getCSeq() == null ? this.getLocalSeqNumber() : dialogRequest.getCSeq().getSeqNumber();
            if (cseqNumber > this.getLocalSeqNumber()) {
                this.setLocalSequenceNumber(cseqNumber);
            } else {
                this.setLocalSequenceNumber(this.getLocalSeqNumber() + 1L);
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::sendRequest:setting Seq Number to " + this.getLocalSeqNumber());
            }
            dialogRequest.getCSeq().setSeqNumber(this.getLocalSeqNumber());
        }
        catch (InvalidArgumentException ex) {
            logger.logFatalError(ex.getMessage());
        }
        try {
            ((SIPClientTransaction)clientTransaction).sendMessage(dialogRequest);
            if (dialogRequest.getMethod().equals("BYE")) {
                this.byeSent = true;
                if (this.isTerminatedOnBye()) {
                    this.setState(3);
                }
            }
        }
        catch (IOException ex) {
            throw new SipException("error sending message", (Throwable)ex);
        }
    }

    private boolean toRetransmitFinalResponse(int T2) {
        if (--this.retransmissionTicksLeft == 0) {
            this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks <= T2 ? 2 * this.prevRetransmissionTicks : this.prevRetransmissionTicks;
            this.prevRetransmissionTicks = this.retransmissionTicksLeft;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.getLastAckSent() != null) {
            if (this.getLastAckSent().getHeader("Timestamp") != null && this.sipStack.generateTimeStampHeader) {
                TimeStamp ts = new TimeStamp();
                try {
                    ts.setTimeStamp(System.currentTimeMillis());
                    this.getLastAckSent().setHeader(ts);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
            this.sendAck(this.getLastAckSent(), false);
        } else if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::resendAck:lastAck sent is NULL hence not resending ACK");
        }
    }

    public String getMethod() {
        return this.method;
    }

    protected void startTimer(SIPServerTransaction transaction) {
        if (this.timerTask != null && this.timerTask.transaction == transaction) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Timer already running for " + this.getDialogId());
            }
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Starting dialog timer for " + this.getDialogId());
        }
        this.acquireTimerTaskSem();
        try {
            if (this.timerTask != null) {
                this.timerTask.transaction = transaction;
            } else {
                this.timerTask = new DialogTimerTask(transaction);
                if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                    this.sipStack.getTimer().scheduleWithFixedDelay(this.timerTask, transaction.getBaseTimerInterval(), transaction.getBaseTimerInterval());
                }
            }
        }
        finally {
            this.releaseTimerTaskSem();
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            this.acquireTimerTaskSem();
            try {
                if (this.timerTask != null) {
                    this.getStack().getTimer().cancel(this.timerTask);
                    this.timerTask = null;
                }
                if (this.earlyStateTimerTask != null) {
                    this.getStack().getTimer().cancel(this.earlyStateTimerTask);
                    this.earlyStateTimerTask = null;
                }
            }
            finally {
                this.releaseTimerTaskSem();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request createPrack(Response relResponse) throws DialogDoesNotExistException, SipException {
        if (this.getState() == null || this.getState().equals((Object)DialogState.TERMINATED)) {
            throw new DialogDoesNotExistException("Dialog not initialized or terminated");
        }
        if ((RSeq)relResponse.getHeader("RSeq") == null) {
            throw new SipException("Missing RSeq Header");
        }
        try {
            SIPResponse sipResponse = (SIPResponse)relResponse;
            SIPRequest sipRequest = this.createRequest("PRACK", sipResponse.getTopmostVia().getTransport());
            String toHeaderTag = sipResponse.getTo().getTag();
            sipRequest.setToTag(toHeaderTag);
            RAck rack = new RAck();
            RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
            rack.setMethod(sipResponse.getCSeq().getMethod());
            rack.setCSequenceNumber((int)sipResponse.getCSeq().getSeqNumber());
            rack.setRSequenceNumber(rseq.getSeqNumber());
            sipRequest.setHeader(rack);
            if (this.proxyAuthorizationHeader != null) {
                sipRequest.addHeader((Header)this.proxyAuthorizationHeader);
            }
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    private void updateRequest(SIPRequest sipRequest) {
        RouteList rl = this.getRouteList();
        if (rl.size() > 0) {
            sipRequest.setHeader((Header)rl);
        } else {
            sipRequest.removeHeader("Route");
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            sipRequest.setHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        if (this.proxyAuthorizationHeader != null && sipRequest.getHeader("Proxy-Authorization") == null) {
            sipRequest.setHeader((Header)this.proxyAuthorizationHeader);
        }
    }

    public Request createAck(long cseqno) throws InvalidArgumentException, SipException {
        if (!this.method.equals("INVITE")) {
            throw new SipException("Dialog was not created with an INVITE" + this.method);
        }
        if (cseqno <= 0L) {
            throw new InvalidArgumentException("bad cseq <= 0 ");
        }
        if (cseqno > 0xFFFFFFFFL) {
            throw new InvalidArgumentException("bad cseq > 4294967295");
        }
        if (this.getRemoteTarget() == null) {
            throw new SipException("Cannot create ACK - no remote Target!");
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("createAck " + this + " cseqno " + cseqno);
        }
        if (this.lastInviteOkReceived < cseqno) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("WARNING : Attempt to crete ACK without OK " + this);
                logger.logDebug("LAST RESPONSE = " + this.getLastResponseStatusCode());
            }
            throw new SipException("Dialog not yet established -- no OK response! lastInviteOkReceived=" + this.lastInviteOkReceived + " cseqno=" + cseqno);
        }
        try {
            NameValueList originalRequestParameters;
            ListeningPointImpl lp;
            SipURI uri4transport = null;
            if (this.routeList != null && !this.routeList.isEmpty()) {
                Route r = (Route)this.routeList.getFirst();
                uri4transport = (SipURI)r.getAddress().getURI();
            } else {
                uri4transport = (SipURI)this.getRemoteTarget().getURI();
            }
            String transport = uri4transport.getTransportParam();
            if (uri4transport.isSecure()) {
                if (transport != null && transport.equalsIgnoreCase("UDP")) {
                    throw new SipException("Cannot create ACK - impossible to use sips uri with transport UDP:" + uri4transport);
                }
                transport = "TLS";
            }
            if (transport != null) {
                lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(transport);
            } else if (uri4transport.isSecure()) {
                lp = (ListeningPointImpl)this.sipProvider.getListeningPoint("TLS");
            } else {
                lp = (ListeningPointImpl)this.sipProvider.getListeningPoint("UDP");
                if (lp == null) {
                    lp = (ListeningPointImpl)this.sipProvider.getListeningPoint("TCP");
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("uri4transport =  " + uri4transport);
            }
            if (lp == null) {
                if (!uri4transport.isSecure()) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("No Listening point for " + uri4transport + " Using last response topmost");
                    }
                    lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(this.lastResponseTopMostVia.getTransport());
                }
                if (lp == null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("remoteTargetURI " + this.getRemoteTarget().getURI());
                        logger.logError("uri4transport = " + uri4transport);
                        logger.logError("No LP found for transport=" + transport);
                    }
                    throw new SipException("Cannot create ACK - no ListeningPoint for transport towards next hop found:" + transport);
                }
            }
            SIPRequest sipRequest = new SIPRequest();
            sipRequest.setMethod("ACK");
            sipRequest.setRequestURI((SipUri)this.getRemoteTarget().getURI().clone());
            sipRequest.setCallId(this.getCallId());
            sipRequest.setCSeq(new CSeq(cseqno, "ACK"));
            ArrayList<Via> vias = new ArrayList<Via>();
            Via via = this.lastResponseTopMostVia;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("lastResponseTopMostVia " + this.lastResponseTopMostVia);
            }
            via.removeParameters();
            if (this.originalRequest != null && this.originalRequest.getTopmostVia() != null && (originalRequestParameters = this.originalRequest.getTopmostVia().getParameters()) != null && originalRequestParameters.size() > 0) {
                via.setParameters((NameValueList)originalRequestParameters.clone());
            }
            via.setBranch(Utils.getInstance().generateBranchId());
            vias.add(via);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Adding via to the ACK we are creating : " + via + " lastResponseTopMostVia " + this.lastResponseTopMostVia);
            }
            sipRequest.setVia(vias);
            From from = new From();
            from.setAddress(this.getLocalParty());
            from.setTag(this.myTag);
            sipRequest.setFrom(from);
            To to = new To();
            to.setAddress(this.getRemoteParty());
            if (this.hisTag != null) {
                to.setTag(this.hisTag);
            }
            sipRequest.setTo(to);
            sipRequest.setMaxForwards(new MaxForwards(70));
            if (this.originalRequest != null) {
                Authorization authorization = this.originalRequest.getAuthorization();
                if (authorization != null) {
                    sipRequest.setHeader(authorization);
                }
                this.originalRequestRecordRouteHeaders = this.originalRequest.getRecordRouteHeaders();
                this.originalRequest = null;
            }
            this.updateRequest(sipRequest);
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            throw new SipException("unexpected exception ", (Throwable)ex);
        }
    }

    @Override
    public SipProviderImpl getSipProvider() {
        return this.sipProvider;
    }

    public void setSipProvider(SipProviderImpl sipProvider) {
        this.sipProvider = sipProvider;
    }

    public void setResponseTags(SIPResponse sipResponse) {
        if (this.getLocalTag() != null || this.getRemoteTag() != null) {
            return;
        }
        String responseFromTag = sipResponse.getFromTag();
        if (responseFromTag != null) {
            if (responseFromTag.equals(this.getLocalTag())) {
                sipResponse.setToTag(this.getRemoteTag());
            } else if (responseFromTag.equals(this.getRemoteTag())) {
                sipResponse.setToTag(this.getLocalTag());
            }
        } else if (logger.isLoggingEnabled()) {
            logger.logWarning("No from tag in response! Not RFC 3261 compatible.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastResponse(SIPTransaction transaction, SIPResponse sipResponse) {
        block65: {
            this.callIdHeader = sipResponse.getCallId();
            int statusCode = sipResponse.getStatusCode();
            if (statusCode == 100) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Invalid status code - 100 in setLastResponse - ignoring");
                }
                return;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logStackTrace();
            }
            try {
                String cseqMethod;
                this.lastResponseStatusCode = statusCode;
                this.lastResponseTopMostVia = (Via)sipResponse.getTopmostVia().clone();
                this.lastResponseMethod = cseqMethod = sipResponse.getCSeqHeader().getMethod();
                long responseCSeqNumber = sipResponse.getCSeq().getSeqNumber();
                boolean is100ClassResponse = statusCode / 100 == 1;
                boolean is200ClassResponse = statusCode / 100 == 2;
                this.lastResponseCSeqNumber = responseCSeqNumber;
                if ("INVITE".equals(cseqMethod)) {
                    this.lastInviteResponseCSeqNumber = responseCSeqNumber;
                    this.lastInviteResponseCode = statusCode;
                }
                if (sipResponse.getToTag() != null) {
                    this.lastResponseToTag = sipResponse.getToTag();
                }
                if (sipResponse.getFromTag() != null) {
                    this.lastResponseFromTag = sipResponse.getFromTag();
                }
                if (transaction != null) {
                    this.lastResponseDialogId = sipResponse.getDialogId(transaction.isServerTransaction());
                }
                this.setAssigned();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("sipDialog: setLastResponse:" + this + " lastResponse = " + this.lastResponseStatusCode + " response " + sipResponse.toString() + " topMostViaHeader " + this.lastResponseTopMostVia);
                }
                if (this.getState() == DialogState.TERMINATED) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("sipDialog: setLastResponse -- dialog is terminated - ignoring ");
                    }
                    if (cseqMethod.equals("INVITE") && statusCode == 200) {
                        this.lastInviteOkReceived = Math.max(responseCSeqNumber, this.lastInviteOkReceived);
                    }
                    return;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logStackTrace();
                    logger.logDebug("cseqMethod = " + cseqMethod);
                    logger.logDebug("dialogState = " + this.getState());
                    logger.logDebug("method = " + this.getMethod());
                    logger.logDebug("statusCode = " + statusCode);
                    logger.logDebug("transaction = " + transaction);
                }
                if (transaction == null || transaction instanceof ClientTransaction) {
                    if (SIPTransactionStack.isDialogCreated(cseqMethod)) {
                        if (this.getState() == null && is100ClassResponse) {
                            this.setState(0);
                            if ((sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getRemoteTag() == null) {
                                this.setRemoteTag(sipResponse.getToTag());
                                this.setDialogId(sipResponse.getDialogId(false));
                                this.sipStack.putDialog(this);
                                this.addRoute(sipResponse);
                            }
                        } else if (this.getState() != null && this.getState().equals((Object)DialogState.EARLY) && is100ClassResponse) {
                            if (cseqMethod.equals(this.getMethod()) && transaction != null && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported)) {
                                this.setRemoteTag(sipResponse.getToTag());
                                this.setDialogId(sipResponse.getDialogId(false));
                                this.sipStack.putDialog(this);
                                this.addRoute(sipResponse);
                            }
                        } else if (is200ClassResponse) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("pendingRouteUpdateOn202Response : " + this.pendingRouteUpdateOn202Response);
                            }
                            if (cseqMethod.equals(this.getMethod()) && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && (this.getState() != DialogState.CONFIRMED || this.getState() == DialogState.CONFIRMED && cseqMethod.equals("SUBSCRIBE") && this.pendingRouteUpdateOn202Response && is200ClassResponse)) {
                                if (this.getState() != DialogState.CONFIRMED) {
                                    this.setRemoteTag(sipResponse.getToTag());
                                    this.setDialogId(sipResponse.getDialogId(false));
                                    this.sipStack.putDialog(this);
                                    this.addRoute(sipResponse);
                                    this.setState(1);
                                }
                                if (cseqMethod.equals("SUBSCRIBE") && is200ClassResponse && this.pendingRouteUpdateOn202Response) {
                                    this.setRemoteTag(sipResponse.getToTag());
                                    this.addRoute(sipResponse);
                                    this.pendingRouteUpdateOn202Response = false;
                                }
                            }
                            if (cseqMethod.equals("INVITE")) {
                                this.lastInviteOkReceived = Math.max(responseCSeqNumber, this.lastInviteOkReceived);
                                if (this.getState() != null && this.getState().getValue() == 1 && transaction != null) {
                                    this.doTargetRefresh(sipResponse);
                                }
                            }
                        } else if (statusCode >= 300 && statusCode <= 699 && (this.getState() == null || cseqMethod.equals(this.getMethod()) && this.getState().getValue() == 0)) {
                            this.setState(3);
                        }
                        if (this.getState() == DialogState.CONFIRMED || this.getState() == DialogState.TERMINATED || this.getOriginalRequestRecordRouteHeaders() == null) break block65;
                        ListIterator it = this.getOriginalRequestRecordRouteHeaders().listIterator(this.getOriginalRequestRecordRouteHeaders().size());
                        while (it.hasPrevious()) {
                            RecordRoute rr = (RecordRoute)it.previous();
                            Route route = (Route)this.routeList.getFirst();
                            if (route != null && rr.getAddress().equals((Object)route.getAddress())) {
                                this.routeList.removeFirst();
                                continue;
                            }
                            break block65;
                        }
                        break block65;
                    }
                    if (cseqMethod.equals("NOTIFY") && (this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER")) && is200ClassResponse && this.getState() == null) {
                        this.setDialogId(sipResponse.getDialogId(true));
                        this.sipStack.putDialog(this);
                        this.setState(1);
                    } else if (cseqMethod.equals("BYE") && is200ClassResponse && this.isTerminatedOnBye()) {
                        this.setState(3);
                    }
                    break block65;
                }
                if (cseqMethod.equals("BYE") && is200ClassResponse && this.isTerminatedOnBye()) {
                    this.setState(3);
                } else {
                    boolean doPutDialog = false;
                    if (this.getLocalTag() == null && sipResponse.getTo().getTag() != null && SIPTransactionStack.isDialogCreated(cseqMethod) && cseqMethod.equals(this.getMethod())) {
                        this.setLocalTag(sipResponse.getTo().getTag());
                        doPutDialog = true;
                    }
                    if (!is200ClassResponse) {
                        if (is100ClassResponse) {
                            if (doPutDialog) {
                                this.setState(0);
                                this.setDialogId(sipResponse.getDialogId(true));
                                this.sipStack.putDialog(this);
                            }
                        } else if (statusCode == 489 && (cseqMethod.equals("NOTIFY") || cseqMethod.equals("SUBSCRIBE"))) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("RFC 3265 : Not setting dialog to TERMINATED for 489");
                            }
                        } else if (!this.isReInvite() && this.getState() != DialogState.CONFIRMED) {
                            this.setState(3);
                        }
                    } else {
                        if (this.dialogState <= 0 && (cseqMethod.equals("INVITE") || cseqMethod.equals("SUBSCRIBE") || cseqMethod.equals("REFER"))) {
                            this.setState(1);
                        }
                        if (doPutDialog) {
                            this.setDialogId(sipResponse.getDialogId(true));
                            this.sipStack.putDialog(this);
                        }
                    }
                }
            }
            finally {
                if (sipResponse.getCSeq().getMethod().equals("INVITE") && transaction != null && transaction instanceof ClientTransaction && this.getState() != DialogState.TERMINATED) {
                    this.acquireTimerTaskSem();
                    try {
                        if (this.getState() == DialogState.EARLY) {
                            if (this.earlyStateTimerTask != null) {
                                this.sipStack.getTimer().cancel(this.earlyStateTimerTask);
                            }
                            logger.logDebug("EarlyStateTimerTask craeted " + this.earlyDialogTimeout * 1000);
                            this.earlyStateTimerTask = new EarlyStateTimerTask();
                            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                                this.sipStack.getTimer().schedule(this.earlyStateTimerTask, this.earlyDialogTimeout * 1000);
                            }
                        } else if (this.earlyStateTimerTask != null) {
                            this.sipStack.getTimer().cancel(this.earlyStateTimerTask);
                            this.earlyStateTimerTask = null;
                        }
                    }
                    finally {
                        this.releaseTimerTaskSem();
                    }
                }
            }
        }
    }

    public void startRetransmitTimer(SIPServerTransaction sipServerTx, Response response2) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("startRetransmitTimer() " + response2.getStatusCode() + " method " + sipServerTx.getMethod());
        }
        if (sipServerTx.isInviteTransaction() && response2.getStatusCode() / 100 == 2) {
            this.startTimer(sipServerTx);
        }
    }

    private void doTargetRefresh(SIPMessage sipMessage) {
        ContactList contactList = sipMessage.getContactHeaders();
        if (contactList != null) {
            Contact contact = (Contact)contactList.getFirst();
            this.setRemoteTarget(contact);
        }
    }

    private static final boolean optionPresent(ListIterator l, String option) {
        while (l.hasNext()) {
            OptionTag opt = (OptionTag)l.next();
            if (opt == null || !option.equalsIgnoreCase(opt.getOptionTag())) continue;
            return true;
        }
        return false;
    }

    public Response createReliableProvisionalResponse(int statusCode) throws InvalidArgumentException, SipException {
        if (!this.firstTransactionIsServerTransaction) {
            throw new SipException("Not a Server Dialog!");
        }
        if (statusCode <= 100 || statusCode > 199) {
            throw new InvalidArgumentException("Bad status code ");
        }
        SIPRequest request = this.originalRequest;
        if (!request.getMethod().equals("INVITE")) {
            throw new SipException("Bad method");
        }
        ListIterator<SIPHeader> list = request.getHeaders("Supported");
        if (!(list != null && SIPDialog.optionPresent(list, "100rel") || (list = request.getHeaders("Require")) != null && SIPDialog.optionPresent(list, "100rel"))) {
            throw new SipException("No Supported/Require 100rel header in the request");
        }
        SIPResponse response2 = request.createResponse(statusCode);
        Require require = new Require();
        try {
            require.setOptionTag("100rel");
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
        response2.addHeader(require);
        RSeq rseq = new RSeq();
        rseq.setSeqNumber(1L);
        RecordRouteList rrl = request.getRecordRouteHeaders();
        if (rrl != null) {
            RecordRouteList rrlclone = (RecordRouteList)rrl.clone();
            response2.setHeader((Header)rrlclone);
        }
        return response2;
    }

    public boolean handlePrack(SIPRequest prackRequest) {
        if (!this.isServer()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- not a server Dialog");
            }
            return false;
        }
        SIPServerTransaction sipServerTransaction = (SIPServerTransaction)this.getFirstTransactionInt();
        byte[] sipResponse = sipServerTransaction.getReliableProvisionalResponse();
        if (sipResponse == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- ReliableResponse not found");
            }
            return false;
        }
        RAck rack = (RAck)prackRequest.getHeader("RAck");
        if (rack == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- rack header not found");
            }
            return false;
        }
        if (!rack.getMethod().equals(sipServerTransaction.getPendingReliableResponseMethod())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rack.getCSeqNumberLong() != sipServerTransaction.getPendingReliableCSeqNumber()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rack.getRSequenceNumber() != sipServerTransaction.getPendingReliableRSeqNumber()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Dropping Prack -- RSeq Header does not match PRACK");
            }
            return false;
        }
        return sipServerTransaction.prackRecieved();
    }

    public void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (!this.isServer()) {
            throw new SipException("Not a Server Dialog");
        }
        SIPResponse sipResponse = (SIPResponse)relResponse;
        if (relResponse.getStatusCode() == 100) {
            throw new SipException("Cannot send 100 as a reliable provisional response");
        }
        if (relResponse.getStatusCode() / 100 > 2) {
            throw new SipException("Response code is not a 1xx response - should be in the range 101 to 199 ");
        }
        if (sipResponse.getToTag() == null) {
            throw new SipException("Badly formatted response -- To tag mandatory for Reliable Provisional Response");
        }
        ListIterator requireList = relResponse.getHeaders("Require");
        boolean found = false;
        if (requireList != null) {
            while (requireList.hasNext() && !found) {
                RequireHeader rh = (RequireHeader)requireList.next();
                if (!rh.getOptionTag().equalsIgnoreCase("100rel")) continue;
                found = true;
            }
        }
        if (!found) {
            Require require = new Require("100rel");
            relResponse.addHeader((Header)require);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Require header with optionTag 100rel is needed -- adding one");
            }
        }
        SIPServerTransaction serverTransaction = (SIPServerTransaction)this.getFirstTransactionInt();
        this.setLastResponse(serverTransaction, sipResponse);
        this.setDialogId(sipResponse.getDialogId(true));
        serverTransaction.sendReliableProvisionalResponse(relResponse);
        this.startRetransmitTimer(serverTransaction, relResponse);
    }

    public void terminateOnBye(boolean terminateFlag) throws SipException {
        this.terminateOnBye = terminateFlag;
    }

    public void setAssigned() {
        this.isAssigned = true;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public Contact getMyContactHeader() {
        if (this.contactHeader == null && this.contactHeaderStringified != null) {
            try {
                this.contactHeader = (Contact)new ContactParser(this.contactHeaderStringified).parse();
            }
            catch (ParseException e) {
                logger.logError("error reparsing the contact header", e);
            }
        }
        return this.contactHeader;
    }

    public boolean handleAck(SIPServerTransaction ackTransaction) {
        if (this.isAckSeen() && this.getRemoteSeqNumber() == ackTransaction.getCSeq()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::handleAck: ACK already seen by dialog -- dropping Ack retransmission");
            }
            this.acquireTimerTaskSem();
            try {
                if (this.timerTask != null) {
                    this.getStack().getTimer().cancel(this.timerTask);
                    this.timerTask = null;
                }
            }
            finally {
                this.releaseTimerTaskSem();
            }
            return false;
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::handleAck: Dialog is terminated -- dropping ACK");
            }
            return false;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SIPDialog::handleAck: lastResponseCSeqNumber = " + this.lastInviteOkReceived + " ackTxCSeq " + ackTransaction.getCSeq());
        }
        if (this.lastResponseStatusCode != null && this.lastInviteResponseCode / 100 == 2 && this.lastInviteResponseCSeqNumber == ackTransaction.getCSeq()) {
            ackTransaction.setDialog(this, this.lastResponseDialogId);
            this.ackReceived(ackTransaction.getCSeq());
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SIPDialog::handleACK: ACK for 2XX response --- sending to TU ");
            }
            return true;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(" INVITE transaction not found");
        }
        if (this.isBackToBackUserAgent()) {
            this.releaseAckSem();
        }
        return false;
    }

    String getEarlyDialogId() {
        return this.earlyDialogId;
    }

    void releaseAckSem() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("releaseAckSem-enter]]" + this + " sem=" + this.ackSem + " b2bua=" + this.isBackToBackUserAgent);
            logger.logStackTrace();
        }
        if (this.isBackToBackUserAgent) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("releaseAckSem]]" + this + " sem=" + this.ackSem);
                logger.logStackTrace();
            }
            if (this.ackSem.availablePermits() == 0) {
                this.ackSem.release();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releaseAckSem]]" + this + " sem=" + this.ackSem);
                }
            }
        }
    }

    boolean isBlockedForReInvite() {
        return this.ackSem.availablePermits() == 0;
    }

    boolean takeAckSem() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("[takeAckSem " + this + " sem=" + this.ackSem);
        }
        try {
            if (!this.ackSem.tryAcquire(2L, TimeUnit.SECONDS)) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Cannot aquire ACK semaphore ");
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Semaphore previously acquired at " + this.stackTrace + " sem=" + this.ackSem);
                    logger.logStackTrace();
                }
                return false;
            }
            if (logger.isLoggingEnabled(32)) {
                this.recordStackTrace();
            }
        }
        catch (InterruptedException ex) {
            logger.logError("Cannot aquire ACK semaphore");
            return false;
        }
        return true;
    }

    private void setLastAckSent(SIPRequest lastAckSent) {
        this.lastAckSent = lastAckSent;
        this.lastAckSent.setTransaction(null);
    }

    public boolean isAtleastOneAckSent() {
        return this.isAcknowledged;
    }

    public boolean isBackToBackUserAgent() {
        return this.isBackToBackUserAgent;
    }

    public synchronized void doDeferredDeleteIfNoAckSent(long seqno) {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else if (this.dialogDeleteIfNoAckSentTask == null) {
            this.dialogDeleteIfNoAckSentTask = new DialogDeleteIfNoAckSentTask(seqno);
            if (this.sipStack.getTimer() != null && this.sipStack.getTimer().isStarted()) {
                int delay = 500;
                if (this.lastTransaction != null) {
                    delay = this.lastTransaction.getBaseTimerInterval();
                }
                this.sipStack.getTimer().schedule(this.dialogDeleteIfNoAckSentTask, this.sipStack.getAckTimeoutFactor() * delay);
            }
        }
    }

    @Override
    public void setBackToBackUserAgent() {
        this.isBackToBackUserAgent = true;
    }

    EventHeader getEventHeader() {
        return this.eventHeader;
    }

    void setEventHeader(EventHeader eventHeader) {
        this.eventHeader = eventHeader;
    }

    void setServerTransactionFlag(boolean serverTransactionFlag) {
        this.serverTransactionFlag = serverTransactionFlag;
    }

    protected void setReInviteFlag(boolean reInviteFlag) {
        this.reInviteFlag = reInviteFlag;
    }

    public boolean isSequenceNumberValidation() {
        return this.sequenceNumberValidation;
    }

    @Override
    public void disableSequenceNumberValidation() {
        this.sequenceNumberValidation = false;
    }

    public void acquireTimerTaskSem() {
        boolean acquired = false;
        try {
            acquired = this.timerTaskLock.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            acquired = false;
        }
        if (!acquired) {
            throw new IllegalStateException("Impossible to acquire the dialog timer task lock");
        }
    }

    public void releaseTimerTaskSem() {
        this.timerTaskLock.release();
    }

    public String getMergeId() {
        return this.firstTransactionMergeId;
    }

    public void setPendingRouteUpdateOn202Response(SIPRequest sipRequest) {
        this.pendingRouteUpdateOn202Response = true;
        String fromTag = sipRequest.getFromHeader().getTag();
        if (fromTag != null) {
            this.setRemoteTag(fromTag);
        }
    }

    public String getLastResponseMethod() {
        return this.lastResponseMethod;
    }

    public Integer getLastResponseStatusCode() {
        return this.lastResponseStatusCode;
    }

    public long getLastResponseCSeqNumber() {
        return this.lastResponseCSeqNumber;
    }

    protected void cleanUpOnAck() {
        if (this.getReleaseReferencesStrategy() != ReleaseReferencesStrategy.None) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("cleanupOnAck : " + this.getDialogId());
            }
            if (this.originalRequest != null) {
                if (this.originalRequestRecordRouteHeaders != null) {
                    this.originalRequestRecordRouteHeadersString = this.originalRequestRecordRouteHeaders.toString();
                }
                this.originalRequestRecordRouteHeaders = null;
                this.originalRequest = null;
            }
            if (this.firstTransaction != null) {
                if (this.firstTransaction.getOriginalRequest() != null) {
                    this.firstTransaction.getOriginalRequest().cleanUp();
                }
                this.firstTransaction = null;
            }
            if (this.lastTransaction != null) {
                if (this.lastTransaction.getOriginalRequest() != null) {
                    this.lastTransaction.getOriginalRequest().cleanUp();
                }
                this.lastTransaction = null;
            }
            if (this.callIdHeader != null) {
                this.callIdHeaderString = this.callIdHeader.toString();
                this.callIdHeader = null;
            }
            if (this.contactHeader != null) {
                this.contactHeaderStringified = this.contactHeader.toString();
                this.contactHeader = null;
            }
            if (this.remoteTarget != null) {
                this.remoteTargetStringified = this.remoteTarget.toString();
                this.remoteTarget = null;
            }
            if (this.remoteParty != null) {
                this.remotePartyStringified = this.remoteParty.toString();
                this.remoteParty = null;
            }
            if (this.localParty != null) {
                this.localPartyStringified = this.localParty.toString();
                this.localParty = null;
            }
        }
    }

    protected void cleanUp() {
        if (this.getReleaseReferencesStrategy() != ReleaseReferencesStrategy.None) {
            this.cleanUpOnAck();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dialog cleanup : " + this.getDialogId());
            }
            if (this.eventListeners != null) {
                this.eventListeners.clear();
            }
            this.timerTaskLock = null;
            this.ackSem = null;
            this.contactHeader = null;
            this.eventHeader = null;
            this.firstTransactionId = null;
            this.firstTransactionMethod = null;
            this.lastResponseDialogId = null;
            this.lastResponseMethod = null;
            this.lastResponseTopMostVia = null;
            if (this.originalRequestRecordRouteHeaders != null) {
                this.originalRequestRecordRouteHeaders.clear();
                this.originalRequestRecordRouteHeaders = null;
                this.originalRequestRecordRouteHeadersString = null;
            }
            if (this.routeList != null) {
                this.routeList.clear();
                this.routeList = null;
            }
            this.responsesReceivedInForkingCase.clear();
        }
    }

    protected RecordRouteList getOriginalRequestRecordRouteHeaders() {
        if (this.originalRequestRecordRouteHeaders == null && this.originalRequestRecordRouteHeadersString != null) {
            try {
                this.originalRequestRecordRouteHeaders = (RecordRouteList)new RecordRouteParser(this.originalRequestRecordRouteHeadersString).parse();
            }
            catch (ParseException e) {
                logger.logError("error reparsing the originalRequest RecordRoute Headers", e);
            }
            this.originalRequestRecordRouteHeadersString = null;
        }
        return this.originalRequestRecordRouteHeaders;
    }

    public Via getLastResponseTopMostVia() {
        return this.lastResponseTopMostVia;
    }

    @Override
    public ReleaseReferencesStrategy getReleaseReferencesStrategy() {
        return this.releaseReferencesStrategy;
    }

    @Override
    public void setReleaseReferencesStrategy(ReleaseReferencesStrategy releaseReferencesStrategy) {
        this.releaseReferencesStrategy = releaseReferencesStrategy;
    }

    @Override
    public void setEarlyDialogTimeoutSeconds(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Invalid value " + seconds);
        }
        this.earlyDialogTimeout = seconds;
    }

    public void checkRetransmissionForForking(SIPResponse response2) {
        int statusCode = response2.getStatusCode();
        String responseMethod = response2.getCSeqHeader().getMethod();
        long responseCSeqNumber = response2.getCSeq().getSeqNumber();
        boolean isRetransmission = !this.responsesReceivedInForkingCase.add(statusCode + "/" + responseCSeqNumber + "/" + responseMethod);
        response2.setRetransmission(isRetransmission);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("marking response as retransmission " + isRetransmission + " for dialog " + this);
        }
    }

    public int hashCode() {
        if (this.callIdHeader == null && this.callIdHeaderString == null) {
            return 0;
        }
        return this.getCallId().getCallId().hashCode();
    }

    public void setOriginalDialog(SIPDialog originalDialog) {
        this.originalDialog = originalDialog;
    }

    @Override
    public boolean isForked() {
        return this.originalDialog != null;
    }

    @Override
    public Dialog getOriginalDialog() {
        return this.originalDialog;
    }

    public void setAckSendingStrategy(AckSendingStrategy ackSendingStrategy) {
        this.ackSendingStrategy = ackSendingStrategy;
    }

    class DialogDeleteIfNoAckSentTask
    extends SIPStackTimerTask
    implements Serializable {
        private long seqno;

        public DialogDeleteIfNoAckSentTask(long seqno) {
            this.seqno = seqno;
        }

        @Override
        public void runTask() {
            if (SIPDialog.this.highestSequenceNumberAcknowledged < this.seqno) {
                SIPDialog.this.dialogDeleteIfNoAckSentTask = null;
                if (!SIPDialog.this.isBackToBackUserAgent) {
                    if (logger.isLoggingEnabled()) {
                        logger.logError("ACK Was not sent. killing dialog " + SIPDialog.this.dialogId);
                    }
                    if (SIPDialog.this.sipProvider.getSipListener() instanceof SipListenerExt) {
                        SIPDialog.this.raiseErrorEvent(2);
                    } else {
                        SIPDialog.this.delete();
                    }
                } else {
                    if (logger.isLoggingEnabled()) {
                        logger.logError("ACK Was not sent. Sending BYE " + SIPDialog.this.dialogId);
                    }
                    if (SIPDialog.this.sipProvider.getSipListener() instanceof SipListenerExt) {
                        SIPDialog.this.raiseErrorEvent(2);
                    } else {
                        try {
                            Request byeRequest = SIPDialog.this.createRequest("BYE");
                            if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
                                byeRequest.addHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
                            }
                            Reason reasonHeader = new Reason();
                            reasonHeader.setProtocol("SIP");
                            reasonHeader.setCause(1025);
                            reasonHeader.setText("Timed out waiting to send ACK " + SIPDialog.this.dialogId);
                            byeRequest.addHeader((Header)reasonHeader);
                            ClientTransaction byeCtx = SIPDialog.this.getSipProvider().getNewClientTransaction(byeRequest);
                            SIPDialog.this.sendRequest(byeCtx);
                            return;
                        }
                        catch (Exception ex) {
                            SIPDialog.this.delete();
                        }
                    }
                }
            }
        }
    }

    class DialogDeleteTask
    extends SIPStackTimerTask
    implements Serializable {
        DialogDeleteTask() {
        }

        @Override
        public void runTask() {
            SIPDialog.this.delete();
        }
    }

    class DialogTimerTask
    extends SIPStackTimerTask
    implements Serializable {
        int nRetransmissions;
        SIPServerTransaction transaction;

        public DialogTimerTask(SIPServerTransaction transaction) {
            this.transaction = transaction;
            this.nRetransmissions = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runTask() {
            SIPDialog dialog = SIPDialog.this;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Running dialog timer");
            }
            ++this.nRetransmissions;
            SIPServerTransaction transaction = this.transaction;
            if (this.nRetransmissions > SIPDialog.this.sipStack.getAckTimeoutFactor() * 1) {
                if (SIPDialog.this.getSipProvider().getSipListener() != null && SIPDialog.this.getSipProvider().getSipListener() instanceof SipListenerExt) {
                    SIPDialog.this.raiseErrorEvent(1);
                } else {
                    SIPDialog.this.delete();
                }
                if (transaction != null && transaction.getState() != TransactionState.TERMINATED) {
                    transaction.raiseErrorEvent(1);
                }
            } else if (transaction != null && !dialog.isAckSeen() && SIPDialog.this.lastResponseStatusCode / 100 == 2) {
                try {
                    if (dialog.toRetransmitFinalResponse(transaction.getTimerT2())) {
                        transaction.resendLastResponseAsBytes();
                    }
                }
                catch (IOException ex) {
                    SIPDialog.this.raiseIOException(transaction.getPeerAddress(), transaction.getPeerPort(), transaction.getPeerProtocol());
                }
                finally {
                    SIPTransactionStack stack = dialog.sipStack;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("resend 200 response from " + dialog);
                    }
                    transaction.fireTimer();
                }
            }
            if (dialog.isAckSeen() || dialog.dialogState == 3) {
                this.transaction = null;
                SIPDialog.this.getStack().getTimer().cancel(this);
            }
        }

        @Override
        public void cleanUpBeforeCancel() {
            this.transaction = null;
            SIPDialog.this.cleanUpOnAck();
            super.cleanUpBeforeCancel();
        }
    }

    class LingerTimer
    extends SIPStackTimerTask
    implements Serializable {
        LingerTimer() {
        }

        @Override
        public void runTask() {
            SIPDialog dialog = SIPDialog.this;
            SIPDialog.this.sipStack.removeDialog(dialog);
            if (((SipStackImpl)SIPDialog.this.getStack()).isReEntrantListener()) {
                SIPDialog.this.cleanUp();
            }
        }
    }

    public class ReInviteSender
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1019346148741070635L;
        ClientTransaction ctx;

        public void terminate() {
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("ReInviteSender::terminate: ctx = " + this.ctx);
                }
                this.ctx.terminate();
                Thread.currentThread().interrupt();
            }
            catch (ObjectInUseException e) {
                logger.logError("unexpected error", (Exception)((Object)e));
            }
        }

        public ReInviteSender(ClientTransaction ctx) {
            this.ctx = ctx;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("ReInviteSender::ReInviteSender: ctx = " + ctx);
                logger.logStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long timeToWait = 0L;
                long startTime = System.currentTimeMillis();
                boolean dialogTimedOut = false;
                boolean busyWait = false;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("SIPDialog::reInviteSender: dialog = " + this.ctx.getDialog() + " lastTransaction = " + SIPDialog.this.lastTransaction + " lastTransactionState " + SIPDialog.this.lastTransaction.getState());
                }
                if (SIPDialog.this.lastTransaction != null && SIPDialog.this.lastTransaction instanceof SIPServerTransaction && SIPDialog.this.lastTransaction.isInviteTransaction() && SIPDialog.this.lastTransaction.getState() != TransactionState.TERMINATED) {
                    ((SIPServerTransaction)SIPDialog.this.lastTransaction).waitForTermination();
                    Thread.sleep(50L);
                }
                if (!SIPDialog.this.takeAckSem()) {
                    if (logger.isLoggingEnabled()) {
                        logger.logError("Could not send re-INVITE time out ClientTransaction");
                    }
                    ((SIPClientTransaction)this.ctx).fireTimeoutTimer();
                    if (SIPDialog.this.sipProvider.getSipListener() != null && SIPDialog.this.sipProvider.getSipListener() instanceof SipListenerExt) {
                        dialogTimedOut = true;
                        SIPDialog.this.raiseErrorEvent(3, (SIPClientTransaction)this.ctx);
                    } else {
                        Request byeRequest = SIPDialog.this.createRequest("BYE");
                        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
                            byeRequest.addHeader((Header)MessageFactoryImpl.getDefaultUserAgentHeader());
                        }
                        Reason reasonHeader = new Reason();
                        reasonHeader.setCause(1024);
                        reasonHeader.setText("Timed out waiting to re-INVITE");
                        byeRequest.addHeader((Header)reasonHeader);
                        ClientTransaction byeCtx = SIPDialog.this.getSipProvider().getNewClientTransaction(byeRequest);
                        SIPDialog.this.sendRequest(byeCtx);
                        return;
                    }
                }
                if (SIPDialog.this.getState() != DialogState.TERMINATED) {
                    timeToWait = System.currentTimeMillis() - startTime;
                }
                try {
                    if (timeToWait != 0L) {
                        Thread.sleep(SIPDialog.this.reInviteWaitTime);
                    }
                }
                catch (InterruptedException ex) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Interrupted sleep");
                    }
                    this.ctx = null;
                    return;
                }
                if (SIPDialog.this.getState() != DialogState.TERMINATED && !dialogTimedOut && this.ctx.getState() != TransactionState.TERMINATED) {
                    SIPDialog.this.sendRequest(this.ctx, true);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("re-INVITE successfully sent");
                    }
                }
            }
            catch (Exception ex) {
                logger.logError("Error sending re-INVITE", ex);
            }
            finally {
                this.ctx = null;
            }
        }
    }

    class EarlyStateTimerTask
    extends SIPStackTimerTask
    implements Serializable {
        @Override
        public void runTask() {
            try {
                if (SIPDialog.this.getState().equals((Object)DialogState.EARLY)) {
                    SIPDialog.this.raiseErrorEvent(4);
                } else if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("EarlyStateTimerTask : Dialog state is " + SIPDialog.this.getState());
                }
            }
            catch (Exception ex) {
                logger.logError("Unexpected exception delivering event", ex);
            }
        }
    }

    public class AckSendingStrategyImpl
    implements AckSendingStrategy {
        private Hop hop = null;

        @Override
        public void send(SIPRequest ackRequest) throws SipException, IOException {
            ListeningPointImpl lp;
            this.hop = SIPDialog.this.sipStack.getNextHop(ackRequest);
            if (this.hop == null) {
                throw new SipException("No route!");
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("hop = " + this.hop);
            }
            if ((lp = (ListeningPointImpl)SIPDialog.this.sipProvider.getListeningPoint(this.hop.getTransport())) == null) {
                throw new SipException("No listening point for this provider registered at " + this.hop);
            }
            InetAddress inetAddress = InetAddress.getByName(this.hop.getHost());
            MessageChannel messageChannel = lp.getMessageProcessor().createMessageChannel(inetAddress, this.hop.getPort());
            messageChannel.sendMessage(ackRequest);
        }

        @Override
        public Hop getLastHop() {
            return this.hop;
        }
    }
}

