/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.util.Arrays;

public class BcX25519
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[32];
    protected final byte[] peerPublicKey = new byte[32];

    public BcX25519(BcTlsCrypto bcTlsCrypto) {
        this.crypto = bcTlsCrypto;
    }

    public byte[] generateEphemeral() throws IOException {
        this.crypto.getSecureRandom().nextBytes(this.privateKey);
        byte[] byArray = new byte[32];
        X25519.scalarMultBase(this.privateKey, 0, byArray, 0);
        return byArray;
    }

    public void receivePeerValue(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 32) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(byArray, 0, this.peerPublicKey, 0, 32);
    }

    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] byArray = new byte[32];
            if (!X25519.calculateAgreement(this.privateKey, 0, this.peerPublicKey, 0, byArray, 0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(byArray);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill(this.privateKey, (byte)0);
            Arrays.fill(this.peerPublicKey, (byte)0);
        }
    }
}

