/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jndi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingEntryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NamingEntryUtil.class);

    public static boolean bindToENC(Object scope2, String asName, String mappedName) throws NamingException {
        NamingEntry entry;
        if (asName == null || asName.trim().equals("")) {
            throw new NamingException("No name for NamingEntry");
        }
        if (mappedName == null || "".equals(mappedName)) {
            mappedName = asName;
        }
        if ((entry = NamingEntryUtil.lookupNamingEntry(scope2, mappedName)) == null) {
            return false;
        }
        entry.bindToENC(asName);
        return true;
    }

    public static NamingEntry lookupNamingEntry(Object scope2, String jndiName) throws NamingException {
        NamingEntry entry = null;
        try {
            Name scopeName = NamingEntryUtil.getNameForScope(scope2);
            InitialContext ic = new InitialContext();
            NameParser parser2 = ic.getNameParser("");
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(parser2, jndiName);
            scopeName.addAll(namingEntryName);
            entry = (NamingEntry)ic.lookup(scopeName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return entry;
    }

    public static Object lookup(Object scope2, String jndiName) throws NamingException {
        Name scopeName = NamingEntryUtil.getNameForScope(scope2);
        InitialContext ic = new InitialContext();
        NameParser parser2 = ic.getNameParser("");
        scopeName.addAll(parser2.parse(jndiName));
        return ic.lookup(scopeName);
    }

    public static <T> List<? extends T> lookupNamingEntries(Object scope2, Class<T> clazz) throws NamingException {
        try {
            Context scopeContext = NamingEntryUtil.getContextForScope(scope2);
            Context namingEntriesContext = (Context)scopeContext.lookup("__");
            ArrayList<Object> list = new ArrayList<Object>();
            NamingEntryUtil.lookupNamingEntries(list, namingEntriesContext, clazz);
            return list;
        }
        catch (NameNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private static List<Object> lookupNamingEntries(List<Object> list, Context context, Class<?> clazz) throws NamingException {
        block4: {
            try {
                NamingEnumeration<Binding> nenum = context.listBindings("");
                while (nenum.hasMoreElements()) {
                    Binding binding = nenum.next();
                    if (binding.getObject() instanceof Context) {
                        NamingEntryUtil.lookupNamingEntries(list, (Context)binding.getObject(), clazz);
                        continue;
                    }
                    if (!clazz.isInstance(binding.getObject())) continue;
                    list.add(binding.getObject());
                }
            }
            catch (NameNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("No entries of type {} in context={}", (Object)clazz.getName(), (Object)context);
            }
        }
        return list;
    }

    public static Name makeNamingEntryName(NameParser parser2, NamingEntry namingEntry) throws NamingException {
        return NamingEntryUtil.makeNamingEntryName(parser2, namingEntry == null ? null : namingEntry.getJndiName());
    }

    public static Name makeNamingEntryName(NameParser parser2, String jndiName) throws NamingException {
        if (jndiName == null) {
            return null;
        }
        if (parser2 == null) {
            InitialContext ic = new InitialContext();
            parser2 = ic.getNameParser("");
        }
        Name name = parser2.parse("");
        name.add("__");
        name.addAll(parser2.parse(jndiName));
        return name;
    }

    public static Name getNameForScope(Object scope2) {
        try {
            InitialContext ic = new InitialContext();
            NameParser parser2 = ic.getNameParser("");
            Name name = parser2.parse("");
            if (scope2 != null) {
                name.add(NamingEntryUtil.canonicalizeScope(scope2));
            }
            return name;
        }
        catch (NamingException e) {
            LOG.warn("Unable to get name for scope {}", scope2, (Object)e);
            return null;
        }
    }

    public static Context getContextForScope(Object scope2) throws NamingException {
        InitialContext ic = new InitialContext();
        NameParser parser2 = ic.getNameParser("");
        Name name = parser2.parse("");
        if (scope2 != null) {
            name.add(NamingEntryUtil.canonicalizeScope(scope2));
        }
        return (Context)ic.lookup(name);
    }

    public static Context getContextForNamingEntries(Object scope2) throws NamingException {
        Context scopeContext = NamingEntryUtil.getContextForScope(scope2);
        return (Context)scopeContext.lookup("__");
    }

    private static String canonicalizeScope(Object scope2) {
        if (scope2 == null) {
            return "";
        }
        Object str = scope2.getClass().getName() + "@" + Long.toHexString(scope2.hashCode());
        str = StringUtil.replace((String)str, '/', '_');
        str = StringUtil.replace((String)str, ' ', '_');
        return str;
    }
}

