/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

public abstract class IterativeDescriptorProcessor
implements DescriptorProcessor {
    public static final Class<?>[] __signature = new Class[]{WebAppContext.class, Descriptor.class, XmlParser.Node.class};
    protected Map<String, Method> _visitors = new HashMap<String, Method>();

    public abstract void start(WebAppContext var1, Descriptor var2);

    public abstract void end(WebAppContext var1, Descriptor var2);

    public void registerVisitor(String nodeName, Method m3) {
        this._visitors.put(nodeName, m3);
    }

    @Override
    public void process(WebAppContext context, Descriptor descriptor2) throws Exception {
        if (descriptor2 == null) {
            return;
        }
        this.start(context, descriptor2);
        XmlParser.Node root = descriptor2.getRoot();
        Iterator iter = root.iterator();
        XmlParser.Node node2 = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node2 = (XmlParser.Node)o;
            this.visit(context, descriptor2, node2);
        }
        this.end(context, descriptor2);
    }

    protected void visit(WebAppContext context, Descriptor descriptor2, XmlParser.Node node2) throws Exception {
        String name = node2.getTag();
        Method m3 = this._visitors.get(name);
        if (m3 != null) {
            m3.invoke((Object)this, context, descriptor2, node2);
        }
    }
}

