/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.CandidatePrioritizer;
import org.ice4j.ice.CandidateTcpType;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;

public abstract class Candidate<T extends Candidate<?>>
implements Comparable<T> {
    public static final int MAX_TYPE_PREFERENCE = 126;
    public static final int MIN_TYPE_PREFERENCE = 0;
    public static final int MAX_LOCAL_PREFERENCE = 65535;
    public static final int MIN_LOCAL_PREFERENCE = 0;
    private final TransportAddress transportAddress;
    private CandidateType candidateType;
    private String foundation = null;
    private T base = null;
    protected long priority = 0L;
    private boolean virtual = false;
    private final Component parentComponent;
    private TransportAddress stunServerAddress = null;
    private TransportAddress relayServerAddress = null;
    private TransportAddress mappedAddress = null;
    private T relatedCandidate = null;
    private CandidateTcpType tcpType = null;

    public Candidate(TransportAddress transportAddress, Component parentComponent, CandidateType type2, T relatedCandidate) {
        this.transportAddress = transportAddress;
        this.parentComponent = parentComponent;
        this.candidateType = type2;
        this.relatedCandidate = relatedCandidate;
    }

    public CandidateType getType() {
        return this.candidateType;
    }

    public void setCandidateType(CandidateType candidateType) {
        this.candidateType = candidateType;
    }

    public String getFoundation() {
        return this.foundation;
    }

    public void setFoundation(String foundation) {
        this.foundation = foundation;
    }

    public T getBase() {
        return this.base;
    }

    public void setBase(T base) {
        this.base = base;
    }

    public long getPriority() {
        return this.priority;
    }

    public TransportAddress getTransportAddress() {
        return this.transportAddress;
    }

    public boolean equals(Object obj) throws NullPointerException {
        boolean baseEqualsCandidateBase;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Candidate)) {
            return false;
        }
        Candidate candidate = (Candidate)obj;
        if (!candidate.getTransportAddress().equals(this.getTransportAddress())) {
            return false;
        }
        T base = this.getBase();
        T candidateBase = candidate.getBase();
        if (base == null) {
            if (candidateBase != null) {
                return false;
            }
            baseEqualsCandidateBase = true;
        } else {
            baseEqualsCandidateBase = base == this && candidateBase == candidate || ((Candidate)base).equals(candidateBase);
        }
        return baseEqualsCandidateBase && this.getPriority() == candidate.getPriority() && this.getType() == candidate.getType() && this.getFoundation().equals(candidate.getFoundation());
    }

    public int hashCode() {
        return this.getParentComponent().hashCode() + this.getTransportAddress().hashCode();
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public long computePriority() {
        this.priority = this.computePriorityForType(this.getType());
        return this.priority;
    }

    public long computeGTalkPriority() {
        this.priority = this.computeGTalkPriorityForType(this.getType());
        return this.priority;
    }

    public long computePriorityForType(CandidateType candidateType) {
        return (long)(Candidate.getTypePreference(candidateType) << 24) + (long)(this.getLocalPreference() << 8) + (long)(256 - this.getParentComponent().getComponentID());
    }

    public long computeGTalkPriorityForType(CandidateType candidateType) {
        long priority = 0L;
        priority = candidateType == CandidateType.HOST_CANDIDATE ? (long)((double)priority + (950.0 - (double)(((Candidate)this.getBase()).getTransport() == Transport.TCP ? 200 : 0))) : (candidateType == CandidateType.PEER_REFLEXIVE_CANDIDATE ? (priority += 900L - (long)(((Candidate)this.getBase()).getTransport() == Transport.TCP ? 200 : 0)) : (candidateType == CandidateType.SERVER_REFLEXIVE_CANDIDATE ? (priority += 900L) : (priority += 500L)));
        priority -= (long)(this.getParentComponent().getComponentID() - 1);
        InetAddress addr = this.getTransportAddress().getAddress();
        if (addr instanceof Inet6Address) {
            priority = addr.isLinkLocalAddress() ? (priority += 40L) : (priority += 50L);
        }
        return priority;
    }

    private static int getTypePreference(CandidateType candidateType) {
        int typePreference = candidateType == CandidateType.HOST_CANDIDATE ? 126 : (candidateType == CandidateType.PEER_REFLEXIVE_CANDIDATE ? 110 : (candidateType == CandidateType.SERVER_REFLEXIVE_CANDIDATE ? 100 : 0));
        return typePreference;
    }

    private int getLocalPreference() {
        if (this.getParentComponent().countLocalHostCandidates() < 2) {
            return 65535;
        }
        if (this.isVirtual()) {
            return 0;
        }
        InetAddress addr = this.getTransportAddress().getAddress();
        if (addr instanceof Inet6Address) {
            if (addr.isLinkLocalAddress()) {
                return 30;
            }
            return 40;
        }
        return 10;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public TransportAddress getStunServerAddress() {
        return this.stunServerAddress;
    }

    protected void setStunServerAddress(TransportAddress address) {
        this.stunServerAddress = address;
    }

    public TransportAddress getRelayServerAddress() {
        return this.relayServerAddress;
    }

    protected void setRelayServerAddress(TransportAddress address) {
        this.relayServerAddress = address;
    }

    public TransportAddress getMappedAddress() {
        return this.mappedAddress;
    }

    protected void setMappedAddress(TransportAddress address) {
        this.mappedAddress = address;
    }

    public Transport getTransport() {
        return this.getTransportAddress().getTransport();
    }

    public TransportAddress getRelatedAddress() {
        if (this.getRelatedCandidate() != null) {
            return ((Candidate)this.getRelatedCandidate()).getTransportAddress();
        }
        return null;
    }

    protected abstract T findRelatedCandidate(TransportAddress var1);

    public String toString() {
        StringBuilder buff = new StringBuilder("candidate:");
        buff.append(this.getFoundation());
        buff.append(" ").append(this.getParentComponent().getComponentID());
        buff.append(" ").append((Object)this.getTransport());
        buff.append(" ").append(this.getPriority());
        buff.append(" ").append(this.getTransportAddress().getHostAddress());
        buff.append(" ").append(this.getTransportAddress().getPort());
        buff.append(" typ ").append((Object)this.getType());
        TransportAddress relAddr = this.getRelatedAddress();
        if (relAddr != null) {
            buff.append(" raddr ").append(relAddr.getHostAddress());
            buff.append(" rport ").append(relAddr.getPort());
        }
        return buff.toString();
    }

    public String toShortString() {
        return this.getTransportAddress() + "/" + (Object)((Object)this.getType());
    }

    protected int getDefaultPreference() {
        switch (this.getType()) {
            case RELAYED_CANDIDATE: {
                return 30;
            }
            case SERVER_REFLEXIVE_CANDIDATE: {
                return 20;
            }
            case HOST_CANDIDATE: {
                return this.getTransportAddress().isIPv6() ? 10 : 15;
            }
        }
        return 5;
    }

    public boolean canReach(Candidate<?> dst) {
        return this.getTransportAddress().canReach(dst.getTransportAddress());
    }

    public abstract boolean isDefault();

    public abstract String getUfrag();

    public TransportAddress getHostAddress() {
        switch (this.getType()) {
            case SERVER_REFLEXIVE_CANDIDATE: {
                if (this.getBase() == null) break;
                return ((Candidate)this.getBase()).getHostAddress();
            }
            case PEER_REFLEXIVE_CANDIDATE: {
                if (this.getBase() == null) break;
                return ((Candidate)this.getBase()).getHostAddress();
            }
            case RELAYED_CANDIDATE: {
                if (this.getRelatedCandidate() == null) break;
                return ((Candidate)this.getRelatedCandidate()).getHostAddress();
            }
            default: {
                return this.getTransportAddress();
            }
        }
        return null;
    }

    public TransportAddress getReflexiveAddress() {
        switch (this.getType()) {
            case SERVER_REFLEXIVE_CANDIDATE: {
                return this.getTransportAddress();
            }
            case PEER_REFLEXIVE_CANDIDATE: {
                return this.getTransportAddress();
            }
            case RELAYED_CANDIDATE: {
                if (this.getRelatedCandidate() == null) break;
                return ((Candidate)this.getRelatedCandidate()).getReflexiveAddress();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public TransportAddress getRelayedAddress() {
        switch (this.getType()) {
            case SERVER_REFLEXIVE_CANDIDATE: {
                return null;
            }
            case PEER_REFLEXIVE_CANDIDATE: {
                return null;
            }
            case RELAYED_CANDIDATE: {
                return this.getTransportAddress();
            }
        }
        return null;
    }

    public T getRelatedCandidate() {
        if (this.relatedCandidate == null) {
            TransportAddress relatedAddress = null;
            switch (this.getType()) {
                case SERVER_REFLEXIVE_CANDIDATE: {
                    if (this.getBase() == null) break;
                    relatedAddress = ((Candidate)this.getBase()).getTransportAddress();
                    break;
                }
                case PEER_REFLEXIVE_CANDIDATE: {
                    if (this.getBase() == null) break;
                    relatedAddress = ((Candidate)this.getBase()).getTransportAddress();
                    break;
                }
                case RELAYED_CANDIDATE: {
                    relatedAddress = this.getMappedAddress();
                    break;
                }
                default: {
                    return null;
                }
            }
            this.relatedCandidate = this.findRelatedCandidate(relatedAddress);
        }
        return this.relatedCandidate;
    }

    @Override
    public int compareTo(T candidate) {
        return CandidatePrioritizer.compareCandidates(this, candidate);
    }

    public CandidateTcpType getTcpType() {
        return this.tcpType;
    }

    public void setTcpType(CandidateTcpType tcpType) {
        this.tcpType = tcpType;
    }
}

